/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.packageChecker.go;

import com.goide.util.GoUtil;
import com.goide.vgo.VgoUtil;
import com.goide.vgo.mod.psi.VgoFile;
import com.goide.vgo.mod.psi.VgoModuleSpec;
import com.goide.vgo.project.VgoDependency;
import com.goide.vgo.project.VgoModule;
import com.goide.vgo.project.VgoModulesRegistry;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.packageChecker.api.BuildFileProvider;
import com.intellij.packageChecker.api.PackageDeclaration;
import com.intellij.packageChecker.go.UtilsKt;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.security.package.Package;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\u0018\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\u0016\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00180\u00172\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J\u0012\u0010\u0019\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J0\u0010\u001a\u001a\u0014\u0012\u0004\u0012\u00020\u0013\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00130\u00170\u001b2\u0006\u0010\u0014\u001a\u00020\u00152\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u00130\u0017H\u0016J\u0016\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u00130\u00172\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\u0016\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u00130\u00172\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J\u0010\u0010\u001e\u001a\u00020\u001f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\u0010\u0010\u001e\u001a\u00020\u001f2\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J \u0010 \u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010!\u001a\u00020\u0006H\u0016J \u0010 \u001a\u00020\u000f2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010!\u001a\u00020\u0006H\u0016R\u0014\u0010\u0005\u001a\u00020\u0006X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0019\u0010\t\u001a\u00070\n\u00a2\u0006\u0002\b\u000bX\u0082\u0004\u00a2\u0006\b\n\u0000\u0012\u0004\b\f\u0010\rR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\""}, d2={"Lcom/intellij/packageChecker/go/GoBuildFileProvider;", "Lcom/intellij/packageChecker/api/BuildFileProvider;", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "id", "", "getId", "()Ljava/lang/String;", "logger", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "getLogger$annotations", "()V", "declarePackage", "", "module", "Lcom/intellij/openapi/module/Module;", "pkg", "Lorg/jetbrains/security/package/Package;", "file", "Lcom/intellij/psi/PsiFile;", "declaredDependencies", "", "Lcom/intellij/packageChecker/api/PackageDeclaration;", "getModule", "getRoots", "", "pkgs", "importedPackages", "supports", "", "updatePackageDeclaration", "version", "intellij.packageChecker.go"})
@SourceDebugExtension(value={"SMAP\nGoBuildFileProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GoBuildFileProvider.kt\ncom/intellij/packageChecker/go/GoBuildFileProvider\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,71:1\n1603#2,9:72\n1855#2:81\n1856#2:83\n1612#2:84\n1603#2,9:85\n1855#2:94\n1856#2:96\n1612#2:97\n1271#2,2:98\n1285#2,4:100\n661#2,11:104\n1#3:82\n1#3:95\n*S KotlinDebug\n*F\n+ 1 GoBuildFileProvider.kt\ncom/intellij/packageChecker/go/GoBuildFileProvider\n*L\n26#1:72,9\n26#1:81\n26#1:83\n26#1:84\n41#1:85,9\n41#1:94\n41#1:96\n41#1:97\n41#1:98,2\n41#1:100,4\n46#1:104,11\n26#1:82\n41#1:95\n*E\n"})
public final class GoBuildFileProvider
implements BuildFileProvider {
    @NotNull
    private final Project project;
    @NotNull
    private final String id;
    @NotNull
    private final Logger logger;

    public GoBuildFileProvider(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
        this.id = "go";
        Logger logger = Logger.getInstance(GoBuildFileProvider.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        this.logger = logger;
    }

    @Override
    @NotNull
    public String getId() {
        return this.id;
    }

    private static /* synthetic */ void getLogger$annotations() {
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public List<Package> importedPackages(@NotNull PsiFile file2) {
        void $this$mapNotNullTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        Module module = GoUtil.module((PsiElement)((PsiElement)file2));
        if (module == null) {
            return CollectionsKt.emptyList();
        }
        Module module2 = module;
        VgoModule vgoModule = VgoModulesRegistry.getInstance((Project)this.project).findVgoModule(module2, file2.getVirtualFile());
        if (vgoModule == null) {
            return CollectionsKt.emptyList();
        }
        VgoModule vgoModule2 = vgoModule;
        Collection collection = vgoModule2.getDependencies();
        Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"getDependencies(...)");
        Iterable $this$mapNotNull$iv = collection;
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            Package it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            VgoDependency it = (VgoDependency)element$iv$iv;
            boolean bl2 = false;
            ProgressManager.checkCanceled();
            Intrinsics.checkNotNull((Object)it);
            if (UtilsKt.toPackage(it) == null) continue;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    @Override
    @NotNull
    public List<Package> importedPackages(@NotNull Module module) {
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        return CollectionsKt.emptyList();
    }

    @Override
    @NotNull
    public List<PackageDeclaration> declaredDependencies(@NotNull PsiFile file2) {
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        return CollectionsKt.emptyList();
    }

    @Override
    public boolean supports(@NotNull PsiFile file2) {
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        return UtilsKt.isEnabled(file2);
    }

    @Override
    public boolean supports(@NotNull Module module) {
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        return UtilsKt.isEnabled(module);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public Map<Package, List<Package>> getRoots(@NotNull PsiFile file2, @NotNull List<Package> pkgs2) {
        void $this$mapNotNullTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        Intrinsics.checkNotNullParameter(pkgs2, (String)"pkgs");
        Iterable $this$mapNotNull$iv = UtilsKt.getDependencies(file2);
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Object object = $this$forEach$iv$iv$iv.iterator();
        while (object.hasNext()) {
            Package it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = object.next();
            boolean bl = false;
            VgoModuleSpec it = (VgoModuleSpec)element$iv$iv;
            boolean bl2 = false;
            if (UtilsKt.toPackage(it) == null) continue;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        Iterable $this$associateWith$iv = (List)destination$iv$iv;
        boolean $i$f$associateWith = false;
        LinkedHashMap result$iv = new LinkedHashMap(RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateWith$iv, (int)10)), (int)16));
        Iterable $this$associateWithTo$iv$iv = $this$associateWith$iv;
        boolean $i$f$associateWithTo = false;
        for (Object element$iv$iv : $this$associateWithTo$iv$iv) {
            object = (Package)element$iv$iv;
            Object t = element$iv$iv;
            Map map2 = result$iv;
            boolean bl = false;
            List list = CollectionsKt.emptyList();
            map2.put(t, list);
        }
        return result$iv;
    }

    @Override
    public void updatePackageDeclaration(@NotNull PsiFile file2, @NotNull Package pkg, @NotNull String version) {
        Object v3;
        VgoModule vgoModule;
        Module module;
        block5: {
            Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
            Intrinsics.checkNotNullParameter((Object)pkg, (String)"pkg");
            Intrinsics.checkNotNullParameter((Object)version, (String)"version");
            Module module2 = this.getModule(file2);
            if (module2 == null) {
                return;
            }
            module = module2;
            VgoModule vgoModule2 = VgoModulesRegistry.getInstance((Project)this.project).findVgoModule(module, file2.getVirtualFile());
            if (vgoModule2 == null) {
                return;
            }
            vgoModule = vgoModule2;
            Collection collection = vgoModule.getDependencies();
            Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"getDependencies(...)");
            Iterable $this$singleOrNull$iv = collection;
            boolean $i$f$singleOrNull = false;
            Object single$iv = null;
            boolean found$iv = false;
            for (Object element$iv : $this$singleOrNull$iv) {
                VgoDependency it = (VgoDependency)element$iv;
                boolean bl = false;
                Intrinsics.checkNotNull((Object)it);
                if (!Intrinsics.areEqual((Object)UtilsKt.toPackage(it), (Object)pkg)) continue;
                if (found$iv) {
                    v3 = null;
                    break block5;
                }
                single$iv = element$iv;
                found$iv = true;
            }
            v3 = !found$iv ? null : single$iv;
        }
        VgoDependency vgoDependency = v3;
        if (vgoDependency == null) {
            return;
        }
        VgoDependency dependency = vgoDependency;
        VgoUtil.addDependencyToGoMod((String)(dependency.getImportPath() + "@" + version), (Project)module.getProject(), (VgoModule)vgoModule);
    }

    private final Module getModule(PsiFile file2) {
        if (!(file2 instanceof VgoFile)) {
            this.logger.warn("Not a Go module file: " + file2.getName());
            return null;
        }
        Module module = GoUtil.module((PsiElement)((PsiElement)file2));
        if (module == null) {
            this.logger.warn("Not a Go module by file: " + ((VgoFile)file2).getName());
        }
        return module;
    }

    @Override
    public void updatePackageDeclaration(@NotNull Module module, @NotNull Package pkg, @NotNull String version) {
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        Intrinsics.checkNotNullParameter((Object)pkg, (String)"pkg");
        Intrinsics.checkNotNullParameter((Object)version, (String)"version");
    }

    @Override
    public void declarePackage(@NotNull PsiFile file2, @NotNull Package pkg) {
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        Intrinsics.checkNotNullParameter((Object)pkg, (String)"pkg");
    }

    @Override
    public void declarePackage(@NotNull Module module, @NotNull Package pkg) {
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        Intrinsics.checkNotNullParameter((Object)pkg, (String)"pkg");
    }
}

