/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.settingsSync;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.Service;
import com.intellij.settingsSync.SettingsSyncEventListener;
import com.intellij.settingsSync.SettingsSyncEvents;
import com.intellij.settingsSync.SyncSettingsEvent;
import com.intellij.util.EventDispatcher;
import java.util.EventListener;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Service
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0001\u0018\u0000 \u001a2\u00020\u0001:\u0002\u001a\u001bB\u0005\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u0007J\b\u0010\u000f\u001a\u00020\rH\u0002J\b\u0010\u0010\u001a\u0004\u0018\u00010\u0004J\u0006\u0010\u0011\u001a\u00020\u000bJ\u0006\u0010\u0012\u001a\u00020\u0013J\u0006\u0010\u0014\u001a\u00020\u0013J\u000e\u0010\u0015\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u0007J\u0013\u0010\u0016\u001a\u00020\r2\u000b\u0010\u0017\u001a\u00070\u0004\u00a2\u0006\u0002\b\u0018J\u0006\u0010\u0019\u001a\u00020\rR\u0010\u0010\u0003\u001a\u0004\u0018\u00010\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R!\u0010\u0005\u001a\u0015\u0012\f\u0012\n \b*\u0004\u0018\u00010\u00070\u00070\u0006\u00a2\u0006\u0002\b\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lcom/intellij/settingsSync/SettingsSyncStatusTracker;", "", "()V", "errorMessage", "", "eventDispatcher", "Lcom/intellij/util/EventDispatcher;", "Lcom/intellij/settingsSync/SettingsSyncStatusTracker$Listener;", "kotlin.jvm.PlatformType", "Lorg/jetbrains/annotations/NotNull;", "lastSyncTime", "", "addListener", "", "listener", "clear", "getErrorMessage", "getLastSyncTime", "isSyncSuccessful", "", "isSynced", "removeListener", "updateOnError", "message", "Lorg/jetbrains/annotations/Nls;", "updateOnSuccess", "Companion", "Listener", "intellij.settingsSync"})
public final class SettingsSyncStatusTracker {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private long lastSyncTime = -1L;
    @Nullable
    private String errorMessage;
    @NotNull
    private final EventDispatcher<Listener> eventDispatcher;

    public SettingsSyncStatusTracker() {
        EventDispatcher eventDispatcher = EventDispatcher.create(Listener.class);
        Intrinsics.checkNotNullExpressionValue((Object)eventDispatcher, (String)"create(...)");
        this.eventDispatcher = eventDispatcher;
        SettingsSyncEvents.Companion.getInstance().addListener(new SettingsSyncEventListener(){

            @Override
            public void settingChanged(@NotNull SyncSettingsEvent event) {
                Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                if (event instanceof SyncSettingsEvent.CloudChange) {
                    this.updateOnSuccess();
                }
            }

            @Override
            public void enabledStateChanged(boolean syncEnabled) {
                if (!syncEnabled) {
                    this.clear();
                }
            }
        });
    }

    public final void updateOnSuccess() {
        this.lastSyncTime = System.currentTimeMillis();
        this.errorMessage = null;
        ((Listener)this.eventDispatcher.getMulticaster()).syncStatusChanged();
    }

    public final void updateOnError(@NotNull String message) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        this.lastSyncTime = -1L;
        this.errorMessage = message;
        ((Listener)this.eventDispatcher.getMulticaster()).syncStatusChanged();
    }

    public final boolean isSyncSuccessful() {
        return this.errorMessage == null;
    }

    public final boolean isSynced() {
        return this.lastSyncTime >= 0L;
    }

    public final long getLastSyncTime() {
        return this.lastSyncTime;
    }

    private final void clear() {
        this.lastSyncTime = -1L;
        this.errorMessage = null;
    }

    @Nullable
    public final String getErrorMessage() {
        return this.errorMessage;
    }

    public final void addListener(@NotNull Listener listener) {
        Intrinsics.checkNotNullParameter((Object)listener, (String)"listener");
        this.eventDispatcher.addListener((EventListener)listener);
    }

    public final void removeListener(@NotNull Listener listener) {
        Intrinsics.checkNotNullParameter((Object)listener, (String)"listener");
        this.eventDispatcher.removeListener((EventListener)listener);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\u0003\u001a\u00020\u0004\u00a8\u0006\u0005"}, d2={"Lcom/intellij/settingsSync/SettingsSyncStatusTracker$Companion;", "", "()V", "getInstance", "Lcom/intellij/settingsSync/SettingsSyncStatusTracker;", "intellij.settingsSync"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final SettingsSyncStatusTracker getInstance() {
            Object object = ApplicationManager.getApplication().getService(SettingsSyncStatusTracker.class);
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getService(...)");
            return (SettingsSyncStatusTracker)object;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0010\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\bf\u0018\u00002\u00020\u0001J\b\u0010\u0002\u001a\u00020\u0003H&\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\u0004\u00c0\u0006\u0001"}, d2={"Lcom/intellij/settingsSync/SettingsSyncStatusTracker$Listener;", "Ljava/util/EventListener;", "syncStatusChanged", "", "intellij.settingsSync"})
    public static interface Listener
    extends EventListener {
        public void syncStatusChanged();
    }
}

