/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.preloading;

import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.ServiceLoader;
import java.util.stream.Collectors;
import org.jetbrains.kotlin.preloading.ClassHandler;
import org.jetbrains.kotlin.preloading.ClassPreloadingUtils;
import org.jetbrains.kotlin.preloading.instrumentation.Instrumenter;

public class Preloader {
    public static final int DEFAULT_CLASS_NUMBER_ESTIMATE = 4096;

    public static void main(String[] args) throws Exception {
        String javaVersion = System.getProperty("java.specification.version");
        if (javaVersion.equals("1.6") || javaVersion.equals("1.7")) {
            System.err.println("error: running the Kotlin compiler under Java " + javaVersion + " is not supported. Java 1.8 or later is required");
            System.exit(1);
        }
        try {
            Preloader.run(args);
        }
        catch (PreloaderException e) {
            System.err.println("error: " + e.toString());
            System.err.println();
            Preloader.printUsage(System.err);
            System.exit(1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void run(String[] args) throws Exception {
        final long startTime = System.nanoTime();
        final Options options = Preloader.parseOptions(args);
        ClassLoader classLoader = Preloader.createClassLoader(options);
        final Handler handler = Preloader.getHandler(options, classLoader);
        ClassLoader preloaded = ClassPreloadingUtils.preloadClasses(options.classpath, options.estimate, classLoader, null, handler);
        Class<?> mainClass = preloaded.loadClass(options.mainClass);
        Method mainMethod = mainClass.getMethod("main", String[].class);
        Thread.currentThread().setContextClassLoader(preloaded);
        String classPathString = options.classpath.stream().map(File::getPath).collect(Collectors.joining(File.pathSeparator));
        String savedClasspathProperty = System.setProperty("java.class.path", classPathString);
        Runtime.getRuntime().addShutdownHook(new Thread(new Runnable(){

            @Override
            public void run() {
                if (options.measure) {
                    System.out.println();
                    System.out.println("=== Preloader's measurements: ");
                    System.out.format("Total time: %.3fs\n", (double)(System.nanoTime() - startTime) / 1.0E9);
                }
                handler.done();
            }
        }));
        try {
            mainMethod.invoke((Object)0, new Object[]{options.arguments.toArray(new String[options.arguments.size()])});
        }
        finally {
            if (savedClasspathProperty == null) {
                System.clearProperty("java.class.path");
            } else {
                System.setProperty("java.class.path", savedClasspathProperty);
            }
        }
    }

    private static ClassLoader createClassLoader(Options options) throws MalformedURLException {
        File toolsJar;
        ClassLoader parent = Preloader.class.getClassLoader();
        List<File> instrumenters = options.instrumenters;
        if (options.arguments.contains("-Xuse-javac") && (toolsJar = Preloader.getJdkToolsJar()) != null) {
            instrumenters.add(toolsJar);
        }
        if (instrumenters.isEmpty()) {
            return parent;
        }
        URL[] classpath = new URL[instrumenters.size()];
        for (int i = 0; i < instrumenters.size(); ++i) {
            classpath[i] = instrumenters.get(i).toURI().toURL();
        }
        return new URLClassLoader(classpath, parent);
    }

    private static File getJdkToolsJar() {
        try {
            String javaHomePath = System.getProperty("java.home");
            if (javaHomePath == null || javaHomePath.isEmpty()) {
                return null;
            }
            File javaHome = new File(javaHomePath);
            File toolsJar = new File(javaHome, "lib/tools.jar");
            if (toolsJar.exists()) {
                return toolsJar.getCanonicalFile();
            }
            if (javaHome.getName().equals("jre") && (toolsJar = new File(javaHome.getParent(), "lib/tools.jar")).exists()) {
                return toolsJar.getCanonicalFile();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return null;
    }

    private static Options parseOptions(String[] args) throws Exception {
        List<Object> classpath = Collections.emptyList();
        boolean measure = false;
        List<Object> instrumenters = new ArrayList();
        int estimate = 4096;
        String mainClass = null;
        ArrayList<String> arguments2 = new ArrayList<String>();
        for (int i = 0; i < args.length; ++i) {
            boolean end;
            String arg = args[i];
            boolean bl = end = i == args.length - 1;
            if ("-help".equals(arg) || "-h".equals(arg)) {
                Preloader.printUsage(System.out);
                System.exit(0);
                continue;
            }
            if ("-cp".equals(arg) || "-classpath".equals(arg)) {
                if (end) {
                    throw new PreloaderException("no argument provided to " + arg);
                }
                classpath = Preloader.parseClassPath(args[++i]);
                continue;
            }
            if ("-estimate".equals(arg)) {
                if (end) {
                    throw new PreloaderException("no argument provided to " + arg);
                }
                estimate = Integer.parseInt(args[++i]);
                continue;
            }
            if ("-instrument".equals(arg)) {
                if (end) {
                    throw new PreloaderException("no argument provided to " + arg);
                }
                instrumenters = Preloader.parseClassPath(args[++i]);
                continue;
            }
            if ("-measure".equals(arg)) {
                measure = true;
                continue;
            }
            mainClass = arg;
            arguments2.addAll(Arrays.asList(args).subList(i + 1, args.length));
            break;
        }
        if (mainClass == null) {
            throw new PreloaderException("no main class name provided");
        }
        return new Options(classpath, measure, instrumenters, estimate, mainClass, arguments2);
    }

    private static List<File> parseClassPath(String classpath) {
        String[] paths = classpath.split(File.pathSeparator);
        ArrayList<File> files2 = new ArrayList<File>(paths.length);
        for (String path : paths) {
            File file2 = new File(path);
            if (!file2.exists()) {
                throw new PreloaderException("file does not exist: " + file2);
            }
            files2.add(file2);
        }
        return files2;
    }

    private static Handler getHandler(Options options, ClassLoader withInstrumenter) {
        if (!options.measure) {
            return new Handler();
        }
        final Instrumenter instrumenter = options.instrumenters.isEmpty() ? Instrumenter.DO_NOTHING : Preloader.loadInstrumenter(withInstrumenter);
        final int[] counter = new int[1];
        final int[] size = new int[1];
        return new Handler(){

            @Override
            public void beforeDefineClass(String name2, int sizeInBytes) {
                counter[0] = counter[0] + 1;
                size[0] = size[0] + sizeInBytes;
            }

            @Override
            public void done() {
                System.out.println();
                System.out.println("Loaded classes: " + counter[0]);
                System.out.println("Loaded classes size: " + size[0]);
                System.out.println();
                instrumenter.dump(System.out);
            }

            @Override
            public byte[] instrument(String resourceName, byte[] data2) {
                return instrumenter.instrument(resourceName, data2);
            }
        };
    }

    private static Instrumenter loadInstrumenter(ClassLoader withInstrumenter) {
        ServiceLoader<Instrumenter> loader = ServiceLoader.load(Instrumenter.class, withInstrumenter);
        Iterator<Instrumenter> instrumenters = loader.iterator();
        if (instrumenters.hasNext()) {
            Instrumenter instrumenter = instrumenters.next();
            if (instrumenters.hasNext()) {
                System.err.println("warning: only the first preloader instrumenter is used: " + instrumenter.getClass());
            }
            return instrumenter;
        }
        System.err.println("warning: no preloader instrumenters found");
        return Instrumenter.DO_NOTHING;
    }

    private static void printUsage(PrintStream out) {
        out.println("usage: java -jar kotlin-preloader.jar [<preloader-options>] <main-class> [<main-class-arguments>]");
        out.println("where possible options include:");
        out.println("  -classpath (-cp) <paths>    Paths where to find class files");
        out.println("  -measure                    Record and output the total time taken by the program and number of loaded classes");
        out.println("  -instrument <paths>         Paths where the instrumenter will be looked up by java.util.ServiceLoader");
        out.println("                              (the class must implement " + Instrumenter.class.getCanonicalName() + " interface)");
        out.println("  -estimate <number>          Class number estimate (4096 by default)");
        out.println("  -help (-h)                  Output this help message");
    }

    private static class Handler
    extends ClassHandler {
        private Handler() {
        }

        public void done() {
        }
    }

    public static class PreloaderException
    extends RuntimeException {
        public PreloaderException(String message) {
            super(message);
        }

        public PreloaderException(String message, Throwable cause) {
            super(message, cause);
        }
    }

    private static class Options {
        public final List<File> classpath;
        public final boolean measure;
        public final List<File> instrumenters;
        public final int estimate;
        public final String mainClass;
        public final List<String> arguments;

        private Options(List<File> classpath, boolean measure, List<File> instrumenters, int estimate, String mainClass, List<String> arguments2) {
            this.classpath = classpath;
            this.measure = measure;
            this.instrumenters = instrumenters;
            this.estimate = estimate;
            this.mainClass = mainClass;
            this.arguments = arguments2;
        }
    }
}

