/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.name;

import kotlin.jvm.JvmField;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.jvm.internal.impl.name.Name;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class SpecialNames {
    @NotNull
    public static final SpecialNames INSTANCE = new SpecialNames();
    @JvmField
    @NotNull
    public static final Name NO_NAME_PROVIDED;
    @JvmField
    @NotNull
    public static final Name ROOT_PACKAGE;
    @JvmField
    @NotNull
    public static final Name DEFAULT_NAME_FOR_COMPANION_OBJECT;
    @JvmField
    @NotNull
    public static final Name SAFE_IDENTIFIER_FOR_NO_NAME;
    @JvmField
    @NotNull
    public static final Name ANONYMOUS;
    @JvmField
    @NotNull
    public static final Name UNARY;
    @JvmField
    @NotNull
    public static final Name THIS;
    @JvmField
    @NotNull
    public static final Name INIT;
    @JvmField
    @NotNull
    public static final Name ITERATOR;
    @JvmField
    @NotNull
    public static final Name DESTRUCT;
    @JvmField
    @NotNull
    public static final Name LOCAL;
    @JvmField
    @NotNull
    public static final Name UNDERSCORE_FOR_UNUSED_VAR;

    private SpecialNames() {
    }

    @JvmStatic
    @NotNull
    public static final Name safeIdentifier(@Nullable Name name2) {
        return name2 != null && !name2.isSpecial() ? name2 : SAFE_IDENTIFIER_FOR_NO_NAME;
    }

    public final boolean isSafeIdentifier(@NotNull Name name2) {
        Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
        String string2 = name2.asString();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"name.asString()");
        return ((CharSequence)string2).length() > 0 && !name2.isSpecial();
    }

    static {
        Name name2 = Name.special("<no name provided>");
        Intrinsics.checkNotNullExpressionValue((Object)name2, (String)"special(\"<no name provided>\")");
        NO_NAME_PROVIDED = name2;
        name2 = Name.special("<root package>");
        Intrinsics.checkNotNullExpressionValue((Object)name2, (String)"special(\"<root package>\")");
        ROOT_PACKAGE = name2;
        name2 = Name.identifier("Companion");
        Intrinsics.checkNotNullExpressionValue((Object)name2, (String)"identifier(\"Companion\")");
        DEFAULT_NAME_FOR_COMPANION_OBJECT = name2;
        name2 = Name.identifier("no_name_in_PSI_3d19d79d_1ba9_4cd0_b7f5_b46aa3cd5d40");
        Intrinsics.checkNotNullExpressionValue((Object)name2, (String)"identifier(\"no_name_in_P\u2026_4cd0_b7f5_b46aa3cd5d40\")");
        SAFE_IDENTIFIER_FOR_NO_NAME = name2;
        name2 = Name.special("<anonymous>");
        Intrinsics.checkNotNullExpressionValue((Object)name2, (String)"special(ANONYMOUS_STRING)");
        ANONYMOUS = name2;
        name2 = Name.special("<unary>");
        Intrinsics.checkNotNullExpressionValue((Object)name2, (String)"special(\"<unary>\")");
        UNARY = name2;
        name2 = Name.special("<this>");
        Intrinsics.checkNotNullExpressionValue((Object)name2, (String)"special(\"<this>\")");
        THIS = name2;
        name2 = Name.special("<init>");
        Intrinsics.checkNotNullExpressionValue((Object)name2, (String)"special(\"<init>\")");
        INIT = name2;
        name2 = Name.special("<iterator>");
        Intrinsics.checkNotNullExpressionValue((Object)name2, (String)"special(\"<iterator>\")");
        ITERATOR = name2;
        name2 = Name.special("<destruct>");
        Intrinsics.checkNotNullExpressionValue((Object)name2, (String)"special(\"<destruct>\")");
        DESTRUCT = name2;
        name2 = Name.special("<local>");
        Intrinsics.checkNotNullExpressionValue((Object)name2, (String)"special(\"<local>\")");
        LOCAL = name2;
        name2 = Name.special("<unused var>");
        Intrinsics.checkNotNullExpressionValue((Object)name2, (String)"special(\"<unused var>\")");
        UNDERSCORE_FOR_UNUSED_VAR = name2;
    }
}

