/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.util.packed;

import org.apache.lucene.util.Accountable;
import org.apache.lucene.util.ArrayUtil;
import org.apache.lucene.util.LongValues;
import org.apache.lucene.util.RamUsageEstimator;
import org.apache.lucene.util.packed.DeltaPackedLongValues;
import org.apache.lucene.util.packed.MonotonicLongValues;
import org.apache.lucene.util.packed.PackedInts;

public class PackedLongValues
extends LongValues
implements Accountable {
    private static final long BASE_RAM_BYTES_USED = RamUsageEstimator.shallowSizeOfInstance(PackedLongValues.class);
    static final int DEFAULT_PAGE_SIZE = 256;
    static final int MIN_PAGE_SIZE = 64;
    static final int MAX_PAGE_SIZE = 0x100000;
    final PackedInts.Reader[] values;
    final int pageShift;
    final int pageMask;
    private final long size;
    private final long ramBytesUsed;

    public static Builder packedBuilder(int pageSize, float acceptableOverheadRatio) {
        return new Builder(pageSize, acceptableOverheadRatio);
    }

    public static Builder packedBuilder(float acceptableOverheadRatio) {
        return PackedLongValues.packedBuilder(256, acceptableOverheadRatio);
    }

    public static Builder deltaPackedBuilder(int pageSize, float acceptableOverheadRatio) {
        return new DeltaPackedLongValues.Builder(pageSize, acceptableOverheadRatio);
    }

    public static Builder deltaPackedBuilder(float acceptableOverheadRatio) {
        return PackedLongValues.deltaPackedBuilder(256, acceptableOverheadRatio);
    }

    public static Builder monotonicBuilder(int pageSize, float acceptableOverheadRatio) {
        return new MonotonicLongValues.Builder(pageSize, acceptableOverheadRatio);
    }

    public static Builder monotonicBuilder(float acceptableOverheadRatio) {
        return PackedLongValues.monotonicBuilder(256, acceptableOverheadRatio);
    }

    PackedLongValues(int pageShift, int pageMask, PackedInts.Reader[] values, long size, long ramBytesUsed) {
        this.pageShift = pageShift;
        this.pageMask = pageMask;
        this.values = values;
        this.size = size;
        this.ramBytesUsed = ramBytesUsed;
    }

    public final long size() {
        return this.size;
    }

    int decodeBlock(int block, long[] dest) {
        PackedInts.Reader vals = this.values[block];
        int size = vals.size();
        for (int k = 0; k < size; k += vals.get(k, dest, k, size - k)) {
        }
        return size;
    }

    long get(int block, int element) {
        return this.values[block].get(element);
    }

    @Override
    public final long get(long index) {
        assert (index >= 0L && index < this.size());
        int block = (int)(index >> this.pageShift);
        int element = (int)(index & (long)this.pageMask);
        return this.get(block, element);
    }

    @Override
    public long ramBytesUsed() {
        return this.ramBytesUsed;
    }

    public Iterator iterator() {
        return new Iterator();
    }

    public static class Builder
    implements Accountable {
        private static final int INITIAL_PAGE_COUNT = 16;
        private static final long BASE_RAM_BYTES_USED = RamUsageEstimator.shallowSizeOfInstance(Builder.class);
        final int pageShift;
        final int pageMask;
        final float acceptableOverheadRatio;
        long[] pending;
        long size;
        PackedInts.Reader[] values;
        long ramBytesUsed;
        int valuesOff;
        int pendingOff;

        Builder(int pageSize, float acceptableOverheadRatio) {
            this.pageShift = PackedInts.checkBlockSize(pageSize, 64, 0x100000);
            this.pageMask = pageSize - 1;
            this.acceptableOverheadRatio = acceptableOverheadRatio;
            this.values = new PackedInts.Reader[16];
            this.pending = new long[pageSize];
            this.valuesOff = 0;
            this.pendingOff = 0;
            this.size = 0L;
            this.ramBytesUsed = this.baseRamBytesUsed() + RamUsageEstimator.sizeOf(this.pending) + RamUsageEstimator.shallowSizeOf(this.values);
        }

        public PackedLongValues build() {
            this.finish();
            this.pending = null;
            Accountable[] values = ArrayUtil.copyOfSubArray(this.values, 0, this.valuesOff);
            long ramBytesUsed = BASE_RAM_BYTES_USED + RamUsageEstimator.sizeOf(values);
            return new PackedLongValues(this.pageShift, this.pageMask, (PackedInts.Reader[])values, this.size, ramBytesUsed);
        }

        long baseRamBytesUsed() {
            return BASE_RAM_BYTES_USED;
        }

        @Override
        public final long ramBytesUsed() {
            return this.ramBytesUsed;
        }

        public final long size() {
            return this.size;
        }

        public Builder add(long l) {
            if (this.pending == null) {
                throw new IllegalStateException("Cannot be reused after build()");
            }
            if (this.pendingOff == this.pending.length) {
                if (this.values.length == this.valuesOff) {
                    int newLength = ArrayUtil.oversize(this.valuesOff + 1, 8);
                    this.grow(newLength);
                }
                this.pack();
            }
            this.pending[this.pendingOff++] = l;
            ++this.size;
            return this;
        }

        final void finish() {
            if (this.pendingOff > 0) {
                if (this.values.length == this.valuesOff) {
                    this.grow(this.valuesOff + 1);
                }
                this.pack();
            }
        }

        private void pack() {
            this.pack(this.pending, this.pendingOff, this.valuesOff, this.acceptableOverheadRatio);
            this.ramBytesUsed += this.values[this.valuesOff].ramBytesUsed();
            ++this.valuesOff;
            this.pendingOff = 0;
        }

        void pack(long[] values, int numValues, int block, float acceptableOverheadRatio) {
            assert (numValues > 0);
            long minValue = values[0];
            long maxValue = values[0];
            for (int i = 1; i < numValues; ++i) {
                minValue = Math.min(minValue, values[i]);
                maxValue = Math.max(maxValue, values[i]);
            }
            if (minValue == 0L && maxValue == 0L) {
                this.values[block] = new PackedInts.NullReader(numValues);
            } else {
                int bitsRequired = minValue < 0L ? 64 : PackedInts.bitsRequired(maxValue);
                PackedInts.Mutable mutable = PackedInts.getMutable(numValues, bitsRequired, acceptableOverheadRatio);
                for (int i = 0; i < numValues; i += mutable.set(i, values, i, numValues - i)) {
                }
                this.values[block] = mutable;
            }
        }

        void grow(int newBlockCount) {
            this.ramBytesUsed -= RamUsageEstimator.shallowSizeOf(this.values);
            this.values = ArrayUtil.growExact(this.values, newBlockCount);
            this.ramBytesUsed += RamUsageEstimator.shallowSizeOf(this.values);
        }
    }

    public final class Iterator {
        final long[] currentValues;
        int vOff;
        int pOff;
        int currentCount;

        Iterator() {
            this.currentValues = new long[PackedLongValues.this.pageMask + 1];
            this.pOff = 0;
            this.vOff = 0;
            this.fillBlock();
        }

        private void fillBlock() {
            if (this.vOff == PackedLongValues.this.values.length) {
                this.currentCount = 0;
            } else {
                this.currentCount = PackedLongValues.this.decodeBlock(this.vOff, this.currentValues);
                assert (this.currentCount > 0);
            }
        }

        public final boolean hasNext() {
            return this.pOff < this.currentCount;
        }

        public final long next() {
            assert (this.hasNext());
            long result2 = this.currentValues[this.pOff++];
            if (this.pOff == this.currentCount) {
                ++this.vOff;
                this.pOff = 0;
                this.fillBlock();
            }
            return result2;
        }
    }
}

