/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.store;

public class MergeInfo {
    public final int totalMaxDoc;
    public final long estimatedMergeBytes;
    public final boolean isExternal;
    public final int mergeMaxNumSegments;

    public MergeInfo(int totalMaxDoc, long estimatedMergeBytes, boolean isExternal, int mergeMaxNumSegments) {
        this.totalMaxDoc = totalMaxDoc;
        this.estimatedMergeBytes = estimatedMergeBytes;
        this.isExternal = isExternal;
        this.mergeMaxNumSegments = mergeMaxNumSegments;
    }

    public int hashCode() {
        int prime = 31;
        int result2 = 1;
        result2 = 31 * result2 + (int)(this.estimatedMergeBytes ^ this.estimatedMergeBytes >>> 32);
        result2 = 31 * result2 + (this.isExternal ? 1231 : 1237);
        result2 = 31 * result2 + this.mergeMaxNumSegments;
        result2 = 31 * result2 + this.totalMaxDoc;
        return result2;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        MergeInfo other = (MergeInfo)obj;
        if (this.estimatedMergeBytes != other.estimatedMergeBytes) {
            return false;
        }
        if (this.isExternal != other.isExternal) {
            return false;
        }
        if (this.mergeMaxNumSegments != other.mergeMaxNumSegments) {
            return false;
        }
        return this.totalMaxDoc == other.totalMaxDoc;
    }

    public String toString() {
        return "MergeInfo [totalMaxDoc=" + this.totalMaxDoc + ", estimatedMergeBytes=" + this.estimatedMergeBytes + ", isExternal=" + this.isExternal + ", mergeMaxNumSegments=" + this.mergeMaxNumSegments + "]";
    }
}

