/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.store;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import java.util.zip.CRC32;
import java.util.zip.Checksum;
import org.apache.lucene.store.AlreadyClosedException;
import org.apache.lucene.store.ByteBuffersDataOutput;
import org.apache.lucene.store.DataInput;
import org.apache.lucene.store.IndexOutput;

public final class ByteBuffersIndexOutput
extends IndexOutput {
    private final Consumer<ByteBuffersDataOutput> onClose;
    private final Checksum checksum;
    private long lastChecksumPosition;
    private long lastChecksum;
    private ByteBuffersDataOutput delegate;

    public ByteBuffersIndexOutput(ByteBuffersDataOutput delegate, String resourceDescription, String name) {
        this(delegate, resourceDescription, name, new CRC32(), null);
    }

    public ByteBuffersIndexOutput(ByteBuffersDataOutput delegate, String resourceDescription, String name, Checksum checksum, Consumer<ByteBuffersDataOutput> onClose) {
        super(resourceDescription, name);
        this.delegate = delegate;
        this.checksum = checksum;
        this.onClose = onClose;
    }

    @Override
    public void close() throws IOException {
        ByteBuffersDataOutput local = this.delegate;
        this.delegate = null;
        if (local != null && this.onClose != null) {
            this.onClose.accept(local);
        }
    }

    @Override
    public long getFilePointer() {
        this.ensureOpen();
        return this.delegate.size();
    }

    @Override
    public long getChecksum() throws IOException {
        this.ensureOpen();
        if (this.checksum == null) {
            throw new IOException("This index output has no checksum computing ability: " + this.toString());
        }
        if (this.lastChecksumPosition != this.delegate.size()) {
            this.lastChecksumPosition = this.delegate.size();
            this.checksum.reset();
            for (ByteBuffer bb : this.delegate.toBufferList()) {
                this.checksum.update(bb);
            }
            this.lastChecksum = this.checksum.getValue();
        }
        return this.lastChecksum;
    }

    @Override
    public void writeByte(byte b) throws IOException {
        this.ensureOpen();
        this.delegate.writeByte(b);
    }

    @Override
    public void writeBytes(byte[] b, int offset, int length) throws IOException {
        this.ensureOpen();
        this.delegate.writeBytes(b, offset, length);
    }

    @Override
    public void writeBytes(byte[] b, int length) throws IOException {
        this.ensureOpen();
        this.delegate.writeBytes(b, length);
    }

    @Override
    public void writeInt(int i) throws IOException {
        this.ensureOpen();
        this.delegate.writeInt(i);
    }

    @Override
    public void writeShort(short i) throws IOException {
        this.ensureOpen();
        this.delegate.writeShort(i);
    }

    @Override
    public void writeLong(long i) throws IOException {
        this.ensureOpen();
        this.delegate.writeLong(i);
    }

    @Override
    public void writeString(String s) throws IOException {
        this.ensureOpen();
        this.delegate.writeString(s);
    }

    @Override
    public void copyBytes(DataInput input, long numBytes) throws IOException {
        this.ensureOpen();
        this.delegate.copyBytes(input, numBytes);
    }

    @Override
    public void writeMapOfStrings(Map<String, String> map2) throws IOException {
        this.ensureOpen();
        this.delegate.writeMapOfStrings(map2);
    }

    @Override
    public void writeSetOfStrings(Set<String> set) throws IOException {
        this.ensureOpen();
        this.delegate.writeSetOfStrings(set);
    }

    private void ensureOpen() {
        if (this.delegate == null) {
            throw new AlreadyClosedException("Already closed.");
        }
    }

    public byte[] toArrayCopy() {
        return this.delegate.toArrayCopy();
    }
}

