/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search;

import java.io.IOException;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.search.Explanation;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.LeafSimScorer;
import org.apache.lucene.search.Matches;
import org.apache.lucene.search.MatchesIterator;
import org.apache.lucene.search.MatchesUtils;
import org.apache.lucene.search.PhraseMatcher;
import org.apache.lucene.search.PhraseScorer;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.ScoreMode;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.Weight;
import org.apache.lucene.search.similarities.Similarity;

public abstract class PhraseWeight
extends Weight {
    final ScoreMode scoreMode;
    final Similarity.SimScorer stats;
    final Similarity similarity;
    final String field;

    protected PhraseWeight(Query query, String field, IndexSearcher searcher, ScoreMode scoreMode) throws IOException {
        super(query);
        this.scoreMode = scoreMode;
        this.field = field;
        this.similarity = searcher.getSimilarity();
        Similarity.SimScorer stats2 = this.getStats(searcher);
        if (stats2 == null) {
            stats2 = new Similarity.SimScorer(){

                @Override
                public float score(float freq, long norm) {
                    return 1.0f;
                }
            };
        }
        this.stats = stats2;
    }

    protected abstract Similarity.SimScorer getStats(IndexSearcher var1) throws IOException;

    protected abstract PhraseMatcher getPhraseMatcher(LeafReaderContext var1, Similarity.SimScorer var2, boolean var3) throws IOException;

    @Override
    public Scorer scorer(LeafReaderContext context) throws IOException {
        PhraseMatcher matcher = this.getPhraseMatcher(context, this.stats, false);
        if (matcher == null) {
            return null;
        }
        LeafSimScorer simScorer = new LeafSimScorer(this.stats, context.reader(), this.field, this.scoreMode.needsScores());
        return new PhraseScorer(this, matcher, this.scoreMode, simScorer);
    }

    @Override
    public Explanation explain(LeafReaderContext context, int doc) throws IOException {
        PhraseMatcher matcher = this.getPhraseMatcher(context, this.stats, false);
        if (matcher == null || matcher.approximation().advance(doc) != doc) {
            return Explanation.noMatch("no matching terms", new Explanation[0]);
        }
        matcher.reset();
        if (!matcher.nextMatch()) {
            return Explanation.noMatch("no matching phrase", new Explanation[0]);
        }
        float freq = matcher.sloppyWeight();
        while (matcher.nextMatch()) {
            freq += matcher.sloppyWeight();
        }
        LeafSimScorer docScorer = new LeafSimScorer(this.stats, context.reader(), this.field, this.scoreMode.needsScores());
        Explanation freqExplanation = Explanation.match((Number)Float.valueOf(freq), "phraseFreq=" + freq, new Explanation[0]);
        Explanation scoreExplanation = docScorer.explain(doc, freqExplanation);
        return Explanation.match(scoreExplanation.getValue(), "weight(" + this.getQuery() + " in " + doc + ") [" + this.similarity.getClass().getSimpleName() + "], result of:", scoreExplanation);
    }

    @Override
    public Matches matches(LeafReaderContext context, int doc) throws IOException {
        return MatchesUtils.forField(this.field, () -> {
            final PhraseMatcher matcher = this.getPhraseMatcher(context, this.stats, true);
            if (matcher == null || matcher.approximation().advance(doc) != doc) {
                return null;
            }
            matcher.reset();
            if (!matcher.nextMatch()) {
                return null;
            }
            return new MatchesIterator(){
                boolean started = false;

                @Override
                public boolean next() throws IOException {
                    if (!this.started) {
                        this.started = true;
                        return true;
                    }
                    return matcher.nextMatch();
                }

                @Override
                public int startPosition() {
                    return matcher.startPosition();
                }

                @Override
                public int endPosition() {
                    return matcher.endPosition();
                }

                @Override
                public int startOffset() throws IOException {
                    return matcher.startOffset();
                }

                @Override
                public int endOffset() throws IOException {
                    return matcher.endOffset();
                }

                @Override
                public MatchesIterator getSubMatches() throws IOException {
                    return null;
                }

                @Override
                public Query getQuery() {
                    return PhraseWeight.this.getQuery();
                }
            };
        });
    }

    @Override
    public boolean isCacheable(LeafReaderContext ctx) {
        return true;
    }
}

