/*
 * Decompiled with CFR 0.152.
 */
package com.vladsch.flexmark.util.sequence.builder;

import com.vladsch.flexmark.util.misc.Utils;
import com.vladsch.flexmark.util.sequence.PositionAnchor;
import com.vladsch.flexmark.util.sequence.Range;
import com.vladsch.flexmark.util.sequence.SequenceUtils;
import com.vladsch.flexmark.util.sequence.builder.SegmentOptimizer;
import org.jetbrains.annotations.NotNull;

public class CharRecoveryOptimizer
implements SegmentOptimizer {
    private final PositionAnchor anchor;
    private int prevEolPos;

    public CharRecoveryOptimizer(PositionAnchor anchor) {
        this.anchor = anchor;
    }

    int prevMatchPos(@NotNull CharSequence base, CharSequence chars, int startIndex, int endIndex) {
        int length = chars.length();
        endIndex = Math.min(base.length(), endIndex);
        int iMax = Math.min(endIndex - startIndex, length);
        for (int i = 0; i < iMax; ++i) {
            char c = base.charAt(i + startIndex);
            char c1 = chars.charAt(i);
            if (c == SequenceUtils.EOL_CHAR) {
                this.prevEolPos = i + 1;
            }
            if (c1 == c) continue;
            return i;
        }
        return iMax;
    }

    int nextMatchPos(@NotNull CharSequence base, CharSequence chars, int startIndex, int fromIndex) {
        startIndex = Math.max(0, startIndex);
        fromIndex = Math.min(base.length(), fromIndex);
        int length = chars.length();
        int iMax = Math.min(fromIndex - startIndex, length);
        int baseOffset = fromIndex - iMax;
        int charsOffset = length - iMax;
        int i = iMax;
        while (i-- > 0) {
            char c = base.charAt(baseOffset + i);
            char c1 = chars.charAt(charsOffset + i);
            if (c1 == c) continue;
            return charsOffset + i + 1;
        }
        return charsOffset;
    }

    @Override
    public Object[] apply(@NotNull CharSequence chars, Object[] parts) {
        int eol;
        int nextPos;
        int prevPos;
        if (!(parts.length == 3 && parts[0] instanceof Range && parts[1] instanceof CharSequence && parts[2] instanceof Range)) {
            return parts;
        }
        @NotNull Range originalPrev = (Range)parts[0];
        @NotNull CharSequence originalText = (CharSequence)parts[1];
        @NotNull Range originalNext = (Range)parts[2];
        int textLength = originalText.length();
        if (originalPrev.isNull() && originalNext.isNull() || textLength == 0) {
            return parts;
        }
        int charsLength = chars.length();
        Range prevRange = originalPrev;
        @NotNull CharSequence text = originalText;
        @NotNull Range nextRange = originalNext;
        this.prevEolPos = -1;
        int n = prevRange.isNull() ? 0 : (prevPos = this.prevMatchPos(chars, text, prevRange.getEnd(), nextRange.isNotNull() ? nextRange.getStart() : charsLength));
        int n2 = nextRange.isNull() ? textLength : (nextPos = this.nextMatchPos(chars, text, prevRange.isNotNull() ? prevRange.getEnd() : 0, nextRange.getStart()));
        if (prevPos == 0 && nextPos == textLength) {
            int eol2;
            if (prevRange.isNotNull() && !SequenceUtils.endsWithEOL(chars.subSequence(prevRange.getStart(), prevRange.getEnd())) && SequenceUtils.startsWith(text, "\n") && (eol2 = SequenceUtils.endOfLine(chars, prevRange.getEnd())) < charsLength && SequenceUtils.isBlank(chars.subSequence(prevRange.getEnd(), eol2))) {
                Range eolRange = Range.ofLength(eol2, 1);
                text = text.subSequence(1, textLength);
                if (nextRange.isEmpty() && nextRange.getStart() < eolRange.getEnd()) {
                    nextRange = Range.NULL;
                }
                if (text.length() == 0) {
                    parts[1] = eolRange;
                    parts[2] = nextRange;
                } else if (prevRange.isNull()) {
                    parts[0] = eolRange;
                    parts[1] = text;
                    parts[2] = nextRange;
                } else if (nextRange.isNull()) {
                    parts[1] = eolRange;
                    parts[2] = text;
                } else {
                    parts = new Object[parts.length + 1];
                    parts[0] = prevRange;
                    parts[1] = eolRange;
                    parts[2] = text;
                    parts[3] = nextRange;
                }
            }
            return parts;
        }
        if (this.prevEolPos != -1 && this.prevEolPos < prevPos && nextPos < (prevPos = this.prevEolPos)) {
            nextPos = prevPos;
        }
        assert (nextPos <= textLength) : "prevRange: " + originalPrev + ", '" + Utils.escapeJavaString(text) + "', nextRange: " + originalNext;
        int matchedPrev = prevPos;
        int matchedNext = textLength - nextPos;
        int maxSpan = Math.min(textLength, (nextRange.isNotNull() ? nextRange.getStart() : charsLength) - (prevRange.isNotNull() ? prevRange.getEnd() : 0));
        int excess = matchedPrev + matchedNext - maxSpan;
        if (excess > 0) {
            assert (matchedNext > 0 && matchedPrev > 0) : "prevRange: " + originalPrev + ", '" + Utils.escapeJavaString(text) + "', nextRange: " + originalNext;
            switch (this.anchor) {
                case PREVIOUS: {
                    int prevDelta = Math.min(matchedPrev, excess);
                    matchedPrev -= prevDelta;
                    matchedNext -= excess - prevDelta;
                    break;
                }
                case NEXT: {
                    int nextDelta = Math.min(matchedNext, excess);
                    matchedNext -= nextDelta;
                    matchedPrev -= excess - nextDelta;
                    break;
                }
                default: {
                    int prevHalf = Math.min(matchedPrev, excess >> 1);
                    matchedPrev -= prevHalf;
                    matchedNext -= excess - prevHalf;
                }
            }
        }
        if (matchedPrev > 0) {
            prevRange = prevRange.endPlus(matchedPrev);
        }
        if (matchedNext > 0) {
            nextRange = nextRange.startMinus(matchedNext);
        }
        text = text.subSequence(matchedPrev, textLength - matchedNext);
        Range eolRange = Range.NULL;
        if (prevRange.isNotNull() && !SequenceUtils.endsWithEOL(chars.subSequence(prevRange.getStart(), prevRange.getEnd())) && SequenceUtils.startsWith(text, "\n") && (eol = SequenceUtils.endOfLine(chars, prevRange.getEnd())) < charsLength && (nextRange.isNull() || eol < nextRange.getStart()) && SequenceUtils.isBlank(chars.subSequence(prevRange.getEnd(), eol))) {
            eolRange = Range.ofLength(eol, 1);
            text = text.subSequence(1, text.length());
        }
        if (prevRange.isNotNull() && nextRange.isNotNull() && text.length() == 0 && prevRange.isAdjacentBefore(nextRange)) {
            parts[0] = prevRange.expandToInclude(nextRange);
            parts[1] = null;
            parts[2] = null;
        } else if (eolRange.isNotNull()) {
            if (nextRange.isEmpty() && nextRange.getStart() < eolRange.getEnd()) {
                nextRange = Range.NULL;
            }
            if (text.length() == 0) {
                parts[0] = prevRange;
                parts[1] = eolRange;
                parts[2] = nextRange;
            } else if (prevRange.isNull()) {
                parts[0] = eolRange;
                parts[1] = text;
                parts[2] = nextRange;
            } else if (nextRange.isNull()) {
                parts[0] = prevRange;
                parts[1] = eolRange;
                parts[2] = text;
            } else {
                parts = new Object[parts.length + 1];
                parts[0] = prevRange;
                parts[1] = eolRange;
                parts[2] = text;
                parts[3] = nextRange;
            }
        } else {
            parts[0] = prevRange;
            parts[1] = text;
            parts[2] = nextRange;
        }
        return parts;
    }
}

