/*
 * Decompiled with CFR 0.152.
 */
package com.vladsch.flexmark.util.ast;

import com.vladsch.flexmark.util.ast.Node;
import com.vladsch.flexmark.util.collection.iteration.ReversiblePeekingIterator;
import java.util.Stack;
import java.util.function.Consumer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DescendantNodeIterator
implements ReversiblePeekingIterator<Node> {
    private final boolean isReversed;
    @NotNull
    private ReversiblePeekingIterator<Node> iterator;
    @Nullable
    private Stack<ReversiblePeekingIterator<Node>> iteratorStack;
    private Node result;

    public DescendantNodeIterator(@NotNull ReversiblePeekingIterator<Node> iterator) {
        this.isReversed = iterator.isReversed();
        this.iterator = iterator instanceof DescendantNodeIterator ? ((DescendantNodeIterator)iterator).iterator : iterator;
        this.iteratorStack = null;
        this.result = null;
    }

    @Override
    public boolean isReversed() {
        return this.isReversed;
    }

    @Override
    public boolean hasNext() {
        return this.iterator.hasNext();
    }

    @Override
    @NotNull
    public Node next() {
        this.result = (Node)this.iterator.next();
        if (this.result.getFirstChild() != null) {
            if (this.iterator.hasNext()) {
                if (this.iteratorStack == null) {
                    this.iteratorStack = new Stack();
                }
                this.iteratorStack.push(this.iterator);
            }
            this.iterator = this.isReversed ? this.result.getReversedChildIterator() : this.result.getChildIterator();
        } else if (this.iteratorStack != null && !this.iteratorStack.isEmpty() && !this.iterator.hasNext()) {
            this.iterator = this.iteratorStack.pop();
        }
        return this.result;
    }

    @Override
    @Nullable
    public Node peek() {
        return this.iterator.peek();
    }

    @Override
    public void remove() {
        if (this.result == null) {
            throw new IllegalStateException("Either next() was not called yet or the node was removed");
        }
        this.result.unlink();
        this.result = null;
    }

    @Override
    public void forEachRemaining(@NotNull Consumer<? super Node> consumer) {
        while (this.hasNext()) {
            consumer.accept(this.next());
        }
    }
}

