/*
 * Decompiled with CFR 0.152.
 */
package com.vladsch.flexmark.html2md.converter;

import com.vladsch.flexmark.util.html.Attributes;
import com.vladsch.flexmark.util.html.MutableAttributes;
import java.util.LinkedList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jsoup.nodes.Node;

public class HtmlConverterState {
    @NotNull
    final Node myParent;
    final List<Node> myElements;
    int myIndex;
    @NotNull
    final MutableAttributes myAttributes;
    @Nullable
    private LinkedList<Runnable> myPrePopActions;

    HtmlConverterState(@NotNull Node parent) {
        this.myParent = parent;
        this.myElements = parent.childNodes();
        this.myIndex = 0;
        this.myAttributes = new MutableAttributes();
        this.myPrePopActions = null;
    }

    public Node getParent() {
        return this.myParent;
    }

    public List<Node> getElements() {
        return this.myElements;
    }

    public int getIndex() {
        return this.myIndex;
    }

    public Attributes getAttributes() {
        return this.myAttributes;
    }

    public LinkedList<Runnable> getPrePopActions() {
        return this.myPrePopActions;
    }

    public void addPrePopAction(Runnable action) {
        if (this.myPrePopActions == null) {
            this.myPrePopActions = new LinkedList();
        }
        this.myPrePopActions.add(action);
    }

    public void runPrePopActions() {
        if (this.myPrePopActions != null) {
            int iMax;
            int i = iMax = this.myPrePopActions.size();
            while (i-- > 0) {
                this.myPrePopActions.get(i).run();
            }
        }
    }

    public String toString() {
        return "State{myParent=" + this.myParent + ", myElements=" + this.myElements + ", myIndex=" + this.myIndex + ", myAttributes=" + this.myAttributes + "}";
    }
}

