/*
 * Decompiled with CFR 0.152.
 */
package com.openhtmltopdf.pdfboxout;

import com.openhtmltopdf.bidi.BidiReorderer;
import com.openhtmltopdf.extend.FontContext;
import com.openhtmltopdf.extend.OutputDevice;
import com.openhtmltopdf.extend.TextRenderer;
import com.openhtmltopdf.pdfboxout.PdfBoxFSFont;
import com.openhtmltopdf.pdfboxout.PdfBoxFSFontMetrics;
import com.openhtmltopdf.pdfboxout.PdfBoxFontResolver;
import com.openhtmltopdf.pdfboxout.PdfBoxOutputDevice;
import com.openhtmltopdf.pdfboxout.PdfBoxRawPDFontMetrics;
import com.openhtmltopdf.pdfboxout.PdfBoxSlowOutputDevice;
import com.openhtmltopdf.pdfboxout.PdfContentStreamAdapter;
import com.openhtmltopdf.render.FSFont;
import com.openhtmltopdf.render.FSFontMetrics;
import com.openhtmltopdf.render.JustificationInfo;
import com.openhtmltopdf.util.LogMessageId;
import com.openhtmltopdf.util.OpenUtil;
import com.openhtmltopdf.util.ThreadCtx;
import com.openhtmltopdf.util.XRLog;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;

public class PdfBoxTextRenderer
implements TextRenderer {
    private static float TEXT_MEASURING_DELTA = 0.01f;
    private BidiReorderer _reorderer;
    private boolean _loggedMissingFont = false;
    private boolean _loggedMissingMetrics = false;

    public void setup(FontContext context, BidiReorderer reorderer) {
        this._reorderer = reorderer;
    }

    @Override
    public void drawString(OutputDevice outputDevice, String string, float x, float y) {
        ((PdfBoxOutputDevice)outputDevice).drawString(string, x, y, null);
    }

    @Override
    public void drawString(OutputDevice outputDevice, String string, float x, float y, JustificationInfo info) {
        ((PdfBoxOutputDevice)outputDevice).drawString(string, x, y, info);
    }

    @Override
    public FSFontMetrics getFSFontMetrics(FontContext context, FSFont font, String string) {
        List<PdfBoxFontResolver.FontDescription> descrs = ((PdfBoxFSFont)font).getFontDescription();
        float size = font.getSize2D();
        PdfBoxFSFontMetrics result2 = new PdfBoxFSFontMetrics();
        float largestAscent = -3.4028235E38f;
        float largestDescent = -3.4028235E38f;
        float largestStrikethroughOffset = -3.4028235E38f;
        float largestStrikethroughThickness = -3.4028235E38f;
        float largestUnderlinePosition = -3.4028235E38f;
        float largestUnderlineThickness = -3.4028235E38f;
        for (PdfBoxFontResolver.FontDescription des : descrs) {
            PdfBoxRawPDFontMetrics metrics = des.getFontMetrics();
            if (metrics == null) {
                if (this._loggedMissingMetrics) continue;
                XRLog.log(Level.WARNING, LogMessageId.LogMessageId1Param.EXCEPTION_FONT_METRICS_NOT_AVAILABLE, des);
                this._loggedMissingMetrics = true;
                continue;
            }
            float loopAscent = metrics._ascent;
            float loopDescent = metrics._descent;
            float loopStrikethroughOffset = metrics._strikethroughOffset;
            float loopStrikethroughThickness = metrics._strikethroughThickness;
            float loopUnderlinePosition = metrics._underlinePosition;
            float loopUnderlineThickness = metrics._underlineThickness;
            if (loopAscent > largestAscent) {
                largestAscent = loopAscent;
            }
            if (loopDescent > largestDescent) {
                largestDescent = loopDescent;
            }
            if (loopStrikethroughOffset > largestStrikethroughOffset) {
                largestStrikethroughOffset = loopStrikethroughOffset;
            }
            if (loopStrikethroughThickness > largestStrikethroughThickness) {
                largestStrikethroughThickness = loopStrikethroughThickness;
            }
            if (loopUnderlinePosition > largestUnderlinePosition) {
                largestUnderlinePosition = loopUnderlinePosition;
            }
            if (!(loopUnderlineThickness > largestUnderlineThickness)) continue;
            largestUnderlineThickness = loopUnderlineThickness;
        }
        result2.setAscent(largestAscent / 1000.0f * size);
        result2.setDescent(largestDescent / 1000.0f * size);
        result2.setStrikethroughOffset(largestStrikethroughOffset / 1000.0f * size);
        if (largestStrikethroughThickness > 0.0f) {
            result2.setStrikethroughThickness(largestStrikethroughThickness / 1000.0f * size);
        } else {
            result2.setStrikethroughThickness(size / 12.0f);
        }
        result2.setUnderlineOffset(largestUnderlinePosition / 1000.0f * size);
        result2.setUnderlineThickness(largestUnderlineThickness / 1000.0f * size);
        return result2;
    }

    public static boolean isJustificationSpace(int c) {
        return c == 32 || c == 160 || c == 12288;
    }

    private static ReplacementChar getReplacementChar(FSFont font) {
        String replaceStr = ThreadCtx.get().sharedContext().getReplacementText();
        List<PdfBoxFontResolver.FontDescription> descriptions = ((PdfBoxFSFont)font).getFontDescription();
        for (PdfBoxFontResolver.FontDescription des : descriptions) {
            try {
                des.getFont().getStringWidth(replaceStr);
                ReplacementChar replace = new ReplacementChar();
                replace.replacement = replaceStr;
                replace.fontDescription = des;
                return replace;
            }
            catch (Exception replace) {
            }
        }
        replaceStr = " ";
        for (PdfBoxFontResolver.FontDescription des : descriptions) {
            try {
                des.getFont().getStringWidth(replaceStr);
                ReplacementChar replace = new ReplacementChar();
                replace.replacement = " ";
                replace.fontDescription = des;
                return replace;
            }
            catch (Exception exception) {
            }
        }
        XRLog.log(Level.INFO, LogMessageId.LogMessageId0Param.GENERAL_PDF_SPECIFIED_FONTS_DONT_CONTAIN_A_SPACE_CHARACTER);
        ReplacementChar replace = new ReplacementChar();
        replace.replacement = "";
        replace.fontDescription = descriptions.get(0);
        return replace;
    }

    public static List<PdfBoxSlowOutputDevice.FontRun> divideIntoFontRuns(FSFont font, String str, BidiReorderer reorderer) {
        StringBuilder sb = new StringBuilder();
        ReplacementChar replace = PdfBoxTextRenderer.getReplacementChar(font);
        List<PdfBoxFontResolver.FontDescription> fonts = ((PdfBoxFSFont)font).getFontDescription();
        ArrayList<PdfBoxSlowOutputDevice.FontRun> runs = new ArrayList<PdfBoxSlowOutputDevice.FontRun>();
        PdfBoxSlowOutputDevice.FontRun current = new PdfBoxSlowOutputDevice.FontRun();
        int i = 0;
        while (i < str.length()) {
            int unicode = str.codePointAt(i);
            i += Character.charCount(unicode);
            String ch = String.valueOf(Character.toChars(unicode));
            if (!OpenUtil.isSafeFontCodePointToPrint(unicode)) continue;
            boolean gotChar = false;
            for (PdfBoxFontResolver.FontDescription des : fonts) {
                try {
                    des.getFont().getStringWidth(ch);
                    if (current.des == null) {
                        current.des = des;
                    } else if (des != current.des) {
                        current.str = sb.toString();
                        runs.add(current);
                        current = new PdfBoxSlowOutputDevice.FontRun();
                        current.des = des;
                        sb = new StringBuilder();
                    }
                    if (PdfBoxTextRenderer.isJustificationSpace(unicode)) {
                        ++current.spaceCharacterCount;
                    } else {
                        ++current.otherCharacterCount;
                    }
                    sb.append(ch);
                    gotChar = true;
                    break;
                }
                catch (Exception e1) {
                    if (!reorderer.isLiveImplementation()) continue;
                    String deshaped = reorderer.deshapeText(ch);
                    try {
                        des.getFont().getStringWidth(deshaped);
                        if (current.des == null) {
                            current.des = des;
                        } else if (des != current.des) {
                            current.str = sb.toString();
                            runs.add(current);
                            current = new PdfBoxSlowOutputDevice.FontRun();
                            current.des = des;
                            sb = new StringBuilder();
                        }
                        if (PdfBoxTextRenderer.isJustificationSpace(unicode)) {
                            ++current.spaceCharacterCount;
                        } else {
                            ++current.otherCharacterCount;
                        }
                        sb.append(deshaped);
                        gotChar = true;
                        break;
                    }
                    catch (Exception exception) {
                    }
                }
            }
            if (gotChar || !OpenUtil.isCodePointPrintable(unicode)) continue;
            if (current.des == null) {
                current.des = replace.fontDescription;
            } else if (replace.fontDescription != current.des) {
                current.str = sb.toString();
                runs.add(current);
                current = new PdfBoxSlowOutputDevice.FontRun();
                current.des = replace.fontDescription;
                sb = new StringBuilder();
            }
            if (Character.isSpaceChar(unicode) || Character.isWhitespace(unicode)) {
                ++current.spaceCharacterCount;
                sb.append(' ');
                continue;
            }
            ++current.otherCharacterCount;
            sb.append(replace.replacement);
        }
        if (sb.length() > 0) {
            current.str = sb.toString();
            runs.add(current);
        }
        return runs;
    }

    private float getStringWidthSlow(FSFont bf, String str) {
        List<PdfBoxSlowOutputDevice.FontRun> runs = PdfBoxTextRenderer.divideIntoFontRuns(bf, str, this._reorderer);
        float strWidth = 0.0f;
        for (PdfBoxSlowOutputDevice.FontRun run : runs) {
            try {
                strWidth += run.des.getFont().getStringWidth(run.str);
            }
            catch (Exception e) {
                XRLog.log(Level.WARNING, LogMessageId.LogMessageId0Param.RENDER_BUG_FONT_DIDNT_CONTAIN_EXPECTED_CHARACTER, e);
            }
        }
        return strWidth;
    }

    @Override
    public int getWidth(FontContext context, FSFont font, String string) {
        float result2;
        block7: {
            result2 = 0.0f;
            String effectiveString = TextRenderer.getEffectivePrintableString(string);
            try {
                if (((PdfBoxFSFont)font).getFontDescription() == null || ((PdfBoxFSFont)font).getFontDescription().isEmpty()) {
                    XRLog.log(Level.WARNING, LogMessageId.LogMessageId0Param.RENDER_FONT_LIST_IS_EMPTY);
                    break block7;
                }
                for (PdfBoxFontResolver.FontDescription fd : ((PdfBoxFSFont)font).getFontDescription()) {
                    if (fd.getFont() != null) {
                        result2 = fd.getFont().getStringWidth(effectiveString) / 1000.0f * font.getSize2D();
                        break;
                    }
                    if (this._loggedMissingFont) continue;
                    XRLog.log(Level.WARNING, LogMessageId.LogMessageId1Param.RENDER_FONT_IS_NULL, fd);
                    this._loggedMissingFont = true;
                }
            }
            catch (IllegalArgumentException e2) {
                result2 = this.getStringWidthSlow(font, effectiveString) / 1000.0f * font.getSize2D();
            }
            catch (IOException e) {
                throw new PdfContentStreamAdapter.PdfException("getWidth", e);
            }
        }
        if ((double)result2 - Math.floor(result2) < (double)TEXT_MEASURING_DELTA) {
            return (int)result2;
        }
        return (int)Math.ceil(result2);
    }

    @Override
    public void setFontScale(float scale) {
        throw new UnsupportedOperationException();
    }

    @Override
    public float getFontScale() {
        return 1.0f;
    }

    @Override
    public void setSmoothingThreshold(float fontsize) {
    }

    @Override
    public int getSmoothingLevel() {
        return 0;
    }

    @Override
    @Deprecated
    public void setSmoothingLevel(int level) {
    }

    @Override
    public void setup(FontContext context) {
    }

    private static class ReplacementChar {
        String replacement;
        PdfBoxFontResolver.FontDescription fontDescription;

        private ReplacementChar() {
        }
    }
}

