/*
 * Decompiled with CFR 0.152.
 */
package com.openhtmltopdf.pdfboxout;

import com.openhtmltopdf.extend.FSImage;
import com.openhtmltopdf.util.LogMessageId;
import com.openhtmltopdf.util.XRLog;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.Iterator;
import java.util.logging.Level;
import javax.imageio.ImageIO;
import javax.imageio.ImageReader;
import javax.imageio.stream.ImageInputStream;
import org.apache.pdfbox.pdmodel.graphics.image.PDImageXObject;

public class PdfBoxImage
implements FSImage {
    private byte[] _bytes;
    private final String _uri;
    private float _intrinsicWidth;
    private float _intrinsicHeight;
    private PDImageXObject _xobject;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PdfBoxImage(byte[] image, String uri) throws IOException {
        block11: {
            this._bytes = image;
            this._uri = uri;
            ImageReader reader = null;
            try (ImageInputStream in = ImageIO.createImageInputStream(new ByteArrayInputStream(this._bytes));){
                Iterator<ImageReader> readers = ImageIO.getImageReaders(in);
                if (readers.hasNext()) {
                    reader = readers.next();
                    reader.setInput(in);
                    this._intrinsicWidth = reader.getWidth(0);
                    this._intrinsicHeight = reader.getHeight(0);
                    break block11;
                }
                XRLog.log(Level.WARNING, LogMessageId.LogMessageId1Param.LOAD_UNRECOGNIZED_IMAGE_FORMAT_FOR_URI, uri);
                throw new IOException("Unrecognized Image format");
            }
            finally {
                if (reader != null) {
                    reader.dispose();
                }
            }
        }
    }

    public PdfBoxImage(byte[] bytes, String uri, float width, float height, PDImageXObject xobject) {
        this._bytes = bytes;
        this._uri = uri;
        this._intrinsicWidth = width;
        this._intrinsicHeight = height;
        this._xobject = xobject;
    }

    public FSImage scaleToOutputResolution(float dotsPerPixel) {
        float factor = dotsPerPixel;
        float width = this._intrinsicWidth;
        float height = this._intrinsicHeight;
        if (factor != 1.0f) {
            width *= factor;
            height *= factor;
        }
        return new PdfBoxImage(this._bytes, this._uri, width, height, this._xobject);
    }

    @Override
    public int getWidth() {
        return (int)this._intrinsicWidth;
    }

    @Override
    public int getHeight() {
        return (int)this._intrinsicHeight;
    }

    @Override
    public void scale(int width, int height) {
        float setHeight;
        float setWidth;
        if (width != -1) {
            setWidth = width;
            setHeight = height == -1 && this._intrinsicWidth != 0.0f ? (float)((int)(setWidth / this._intrinsicWidth * this._intrinsicHeight)) : (float)height;
        } else if (height != -1) {
            setHeight = height;
            setWidth = this._intrinsicHeight != 0.0f ? (float)((int)(setHeight / this._intrinsicHeight * this._intrinsicWidth)) : 0.0f;
        } else {
            setWidth = this._intrinsicWidth;
            setHeight = this._intrinsicHeight;
        }
        this._intrinsicWidth = setWidth;
        this._intrinsicHeight = setHeight;
    }

    public byte[] getBytes() {
        return this._bytes;
    }

    public void clearBytes() {
        this._bytes = null;
    }

    public PDImageXObject getXObject() {
        return this._xobject;
    }

    public void setXObject(PDImageXObject xobject) {
        this._xobject = xobject;
    }

    public String getUri() {
        return this._uri;
    }
}

