/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.byteCodeViewer;

import com.intellij.byteCodeViewer.ByteCodeViewerComponent;
import com.intellij.byteCodeViewer.ByteCodeViewerManager;
import com.intellij.byteCodeViewer.JavaByteCodeViewerBundle;
import com.intellij.codeInsight.lookup.LookupManager;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.compiler.CompilerManager;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.colors.EditorColors;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiClassOwner;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.impl.source.tree.injected.InjectedLanguageUtil;
import com.intellij.psi.util.PsiUtilBase;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.util.Processor;
import com.intellij.util.ui.JBEmptyBorder;
import java.awt.Color;
import java.awt.Component;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.border.Border;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class ShowByteCodeAction
extends AnAction {
    ShowByteCodeAction() {
    }

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        ActionUpdateThread actionUpdateThread = ActionUpdateThread.BGT;
        if (actionUpdateThread == null) {
            ShowByteCodeAction.$$$reportNull$$$0(0);
        }
        return actionUpdateThread;
    }

    public void update(@NotNull AnActionEvent e) {
        PsiElement psiElement;
        if (e == null) {
            ShowByteCodeAction.$$$reportNull$$$0(1);
        }
        e.getPresentation().setEnabled(false);
        e.getPresentation().setIcon(AllIcons.Actions.Preview);
        Project project = (Project)e.getData(CommonDataKeys.PROJECT);
        if (project != null && (psiElement = ShowByteCodeAction.getPsiElement(e.getDataContext(), project, (Editor)e.getData(CommonDataKeys.EDITOR))) != null && psiElement.getContainingFile() instanceof PsiClassOwner) {
            e.getPresentation().setEnabled(true);
        }
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        int lineNumber;
        if (e == null) {
            ShowByteCodeAction.$$$reportNull$$$0(2);
        }
        DataContext dataContext = e.getDataContext();
        final Project project = e.getProject();
        if (project == null) {
            return;
        }
        final Editor editor = (Editor)e.getData(CommonDataKeys.EDITOR);
        PsiElement psiElement = ShowByteCodeAction.getPsiElement(dataContext, project, editor);
        if (psiElement == null) {
            return;
        }
        int n = lineNumber = editor != null ? editor.getCaretModel().getLogicalPosition().line : -1;
        if (ByteCodeViewerManager.getContainingClass(psiElement) == null) {
            Messages.showWarningDialog((Project)project, (String)JavaByteCodeViewerBundle.message("bytecode.class.in.selection.message", new Object[0]), (String)JavaByteCodeViewerBundle.message("bytecode.not.found.message", new Object[0]));
            return;
        }
        final String psiElementTitle = ByteCodeViewerManager.getInstance(project).getTitle(psiElement);
        final VirtualFile virtualFile = PsiUtilCore.getVirtualFile((PsiElement)psiElement);
        if (virtualFile == null) {
            return;
        }
        final RelativePoint bestPopupLocation = JBPopupFactory.getInstance().guessBestPopupLocation(dataContext);
        final SmartPsiElementPointer element = SmartPointerManager.getInstance((Project)project).createSmartPsiElementPointer(psiElement);
        ProgressManager.getInstance().run((Task)new Task.Backgroundable(project, JavaByteCodeViewerBundle.message("looking.for.bytecode.progress", new Object[0])){
            private String myByteCode;
            @Nls
            private String myErrorTitle;

            public void run(@NotNull ProgressIndicator indicator) {
                if (indicator == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (((Boolean)ReadAction.compute(() -> ProjectRootManager.getInstance((Project)project).getFileIndex().isInContent(virtualFile))).booleanValue() && ShowByteCodeAction.isMarkedForCompilation(project, virtualFile)) {
                    this.myErrorTitle = JavaByteCodeViewerBundle.message("class.file.may.be.out.of.date", new Object[0]);
                }
                this.myByteCode = (String)ReadAction.compute(() -> {
                    PsiElement targetElement = element.getElement();
                    return targetElement != null ? ByteCodeViewerManager.getByteCode(targetElement) : null;
                });
            }

            public void onSuccess() {
                if (project.isDisposed()) {
                    return;
                }
                PsiElement targetElement = element.getElement();
                if (targetElement == null) {
                    return;
                }
                ByteCodeViewerManager codeViewerManager = ByteCodeViewerManager.getInstance(project);
                if (codeViewerManager.hasActiveDockedDocWindow()) {
                    codeViewerManager.doUpdateComponent(targetElement, lineNumber, this.myByteCode);
                } else {
                    if (this.myByteCode == null) {
                        Messages.showErrorDialog((Project)project, (String)JavaByteCodeViewerBundle.message("bytecode.parser.failure.message", psiElementTitle), (String)JavaByteCodeViewerBundle.message("bytecode.not.found.title", new Object[0]));
                        return;
                    }
                    ByteCodeViewerComponent component = new ByteCodeViewerComponent(project);
                    component.setText(this.myByteCode, targetElement, lineNumber);
                    Processor pinCallback = popup -> {
                        codeViewerManager.recreateToolWindow(targetElement, targetElement);
                        popup.cancel();
                        return false;
                    };
                    if (this.myErrorTitle != null) {
                        JLabel errorLabel = new JLabel(this.myErrorTitle);
                        Color color = EditorColorsManager.getInstance().getGlobalScheme().getColor(EditorColors.NOTIFICATION_BACKGROUND);
                        if (color != null) {
                            errorLabel.setBorder((Border)new JBEmptyBorder(2));
                            errorLabel.setBackground(color);
                            errorLabel.setOpaque(true);
                        }
                        component.add((Component)errorLabel, "North");
                    }
                    JBPopup popup2 = JBPopupFactory.getInstance().createComponentPopupBuilder((JComponent)component, component.getEditorComponent()).setProject(project).setDimensionServiceKey(project, ShowByteCodeAction.class.getName(), false).setResizable(true).setMovable(true).setRequestFocus(LookupManager.getActiveLookup((Editor)editor) == null).setTitle(JavaByteCodeViewerBundle.message("popup.title.element.bytecode", psiElementTitle)).setCouldPin(pinCallback).createPopup();
                    Disposer.register((Disposable)popup2, (Disposable)component);
                    if (editor != null) {
                        popup2.showInBestPositionFor(editor);
                    } else {
                        popup2.show(bestPopupLocation);
                    }
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/byteCodeViewer/ShowByteCodeAction$1", "run"));
            }
        });
    }

    private static boolean isMarkedForCompilation(Project project, VirtualFile virtualFile) {
        CompilerManager compilerManager = CompilerManager.getInstance((Project)project);
        return !compilerManager.isUpToDate(compilerManager.createFilesCompileScope(new VirtualFile[]{virtualFile}));
    }

    @Nullable
    private static PsiElement getPsiElement(DataContext dataContext, Project project, @Nullable Editor editor) {
        PsiElement psiElement;
        if (editor == null) {
            psiElement = (PsiElement)dataContext.getData(CommonDataKeys.PSI_ELEMENT);
        } else {
            PsiFile file = PsiUtilBase.getPsiFileInEditor((Editor)editor, (Project)project);
            Editor injectedEditor = InjectedLanguageUtil.getEditorForInjectedLanguageNoCommit((Editor)editor, (PsiFile)file);
            psiElement = ShowByteCodeAction.findElementInFile(PsiUtilBase.getPsiFileInEditor((Editor)injectedEditor, (Project)project), injectedEditor);
            if (file != null && psiElement == null) {
                psiElement = ShowByteCodeAction.findElementInFile(file, editor);
            }
        }
        return psiElement;
    }

    private static PsiElement findElementInFile(@Nullable PsiFile psiFile, @NotNull Editor editor) {
        if (editor == null) {
            ShowByteCodeAction.$$$reportNull$$$0(3);
        }
        return psiFile != null ? psiFile.findElementAt(editor.getCaretModel().getOffset()) : null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 2, 3 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/byteCodeViewer/ShowByteCodeAction";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getActionUpdateThread";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/byteCodeViewer/ShowByteCodeAction";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "update";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "actionPerformed";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "findElementInFile";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1, 2, 3 -> new IllegalArgumentException(string);
        };
    }
}

