/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gitlab.mergerequest.file;

import com.intellij.diff.editor.DiffVirtualFile;
import com.intellij.diff.impl.DiffRequestProcessor;
import com.intellij.ide.actions.SplitAction;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypes;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFilePathWrapper;
import com.intellij.openapi.vfs.VirtualFileSystem;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.gitlab.api.GitLabProjectCoordinates;
import org.jetbrains.plugins.gitlab.mergerequest.file.GitLabMergeRequestDiffFileKt;
import org.jetbrains.plugins.gitlab.mergerequest.file.GitLabMergeRequestDiffService;
import org.jetbrains.plugins.gitlab.mergerequest.file.GitLabVirtualFile;
import org.jetbrains.plugins.gitlab.mergerequest.file.GitLabVirtualFileSystem;
import org.jetbrains.plugins.gitlab.mergerequest.ui.toolwindow.model.GitLabToolWindowProjectViewModel;
import org.jetbrains.plugins.gitlab.util.GitLabBundle;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0001\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0007\n\u0002\u0010\b\n\u0002\b\u0003\u0018\u00002\u00020\u00012\u00020\u00022\u00020\u0003B%\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u000bJ\b\u0010\u000f\u001a\u00020\u0010H\u0016J\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\b\u0010\u0013\u001a\u00020\u0014H\u0016J\u0013\u0010\u0015\u001a\u00020\u00142\b\u0010\u0016\u001a\u0004\u0018\u00010\u0017H\u0096\u0002J\b\u0010\u0018\u001a\u00020\u0019H\u0016J\b\u0010\u001a\u001a\u00020\u001bH\u0016J\b\u0010\u001c\u001a\u00020\u0010H\u0016J\b\u0010\u001d\u001a\u00020\u001eH\u0016J\"\u0010\u001f\u001a\u00020\u00102\b\u0010 \u001a\u0004\u0018\u00010\u00172\u0006\u0010!\u001a\u00020\u001e2\u0006\u0010\"\u001a\u00020\u001eH\u0016J\b\u0010#\u001a\u00020\u0005H\u0016J\b\u0010$\u001a\u00020\u0005H\u0016J\b\u0010%\u001a\u00020&H\u0016J\b\u0010'\u001a\u00020\u0014H\u0016J\b\u0010(\u001a\u00020\u0005H\u0016R\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\n\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\rR\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006)"}, d2={"Lorg/jetbrains/plugins/gitlab/mergerequest/file/GitLabMergeRequestDiffFile;", "Lcom/intellij/diff/editor/DiffVirtualFile;", "Lcom/intellij/openapi/vfs/VirtualFilePathWrapper;", "Lorg/jetbrains/plugins/gitlab/mergerequest/file/GitLabVirtualFile;", "connectionId", "", "project", "Lcom/intellij/openapi/project/Project;", "glProject", "Lorg/jetbrains/plugins/gitlab/api/GitLabProjectCoordinates;", "mergeRequestIid", "(Ljava/lang/String;Lcom/intellij/openapi/project/Project;Lorg/jetbrains/plugins/gitlab/api/GitLabProjectCoordinates;Ljava/lang/String;)V", "getConnectionId", "()Ljava/lang/String;", "getMergeRequestIid", "contentsToByteArray", "", "createProcessor", "Lcom/intellij/diff/impl/DiffRequestProcessor;", "enforcePresentableName", "", "equals", "other", "", "getFileSystem", "Lcom/intellij/openapi/vfs/VirtualFileSystem;", "getFileType", "Lcom/intellij/openapi/fileTypes/FileType;", "getInputStream", "getLength", "", "getOutputStream", "requestor", "newModificationStamp", "newTimeStamp", "getPath", "getPresentablePath", "hashCode", "", "isValid", "toString", "intellij.vcs.gitlab"})
@SourceDebugExtension(value={"SMAP\nGitLabMergeRequestDiffFile.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GitLabMergeRequestDiffFile.kt\norg/jetbrains/plugins/gitlab/mergerequest/file/GitLabMergeRequestDiffFile\n+ 2 services.kt\ncom/intellij/openapi/components/ServicesKt\n*L\n1#1,80:1\n30#2,3:81\n*S KotlinDebug\n*F\n+ 1 GitLabMergeRequestDiffFile.kt\norg/jetbrains/plugins/gitlab/mergerequest/file/GitLabMergeRequestDiffFile\n*L\n42#1:81,3\n*E\n"})
public final class GitLabMergeRequestDiffFile
extends DiffVirtualFile
implements VirtualFilePathWrapper,
GitLabVirtualFile {
    @NotNull
    private final String connectionId;
    @NotNull
    private final Project project;
    @NotNull
    private final GitLabProjectCoordinates glProject;
    @NotNull
    private final String mergeRequestIid;

    public GitLabMergeRequestDiffFile(@NotNull String connectionId, @NotNull Project project, @NotNull GitLabProjectCoordinates glProject, @NotNull String mergeRequestIid) {
        Intrinsics.checkNotNullParameter((Object)connectionId, (String)"connectionId");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)glProject, (String)"glProject");
        Intrinsics.checkNotNullParameter((Object)mergeRequestIid, (String)"mergeRequestIid");
        Object[] objectArray = new Object[]{mergeRequestIid};
        super(GitLabBundle.message("merge.request.diff.file.name", objectArray));
        this.connectionId = connectionId;
        this.project = project;
        this.glProject = glProject;
        this.mergeRequestIid = mergeRequestIid;
        this.putUserData(SplitAction.FORBID_TAB_SPLIT, true);
    }

    @Override
    @NotNull
    public String getConnectionId() {
        return this.connectionId;
    }

    @NotNull
    public final String getMergeRequestIid() {
        return this.mergeRequestIid;
    }

    public boolean enforcePresentableName() {
        return true;
    }

    public boolean isValid() {
        return GitLabMergeRequestDiffFileKt.findProjectVm(this.project, this.getConnectionId()) != null;
    }

    @NotNull
    public String getPath() {
        VirtualFileSystem virtualFileSystem = this.getFileSystem();
        Intrinsics.checkNotNull((Object)virtualFileSystem, (String)"null cannot be cast to non-null type org.jetbrains.plugins.gitlab.mergerequest.file.GitLabVirtualFileSystem");
        return ((GitLabVirtualFileSystem)virtualFileSystem).getPath(this.getConnectionId(), this.project, this.glProject, this.mergeRequestIid, true);
    }

    @NotNull
    public String getPresentablePath() {
        return GitLabMergeRequestDiffFileKt.presentablePath(this.glProject, this.mergeRequestIid);
    }

    @NotNull
    public DiffRequestProcessor createProcessor(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        GitLabToolWindowProjectViewModel gitLabToolWindowProjectViewModel = GitLabMergeRequestDiffFileKt.findProjectVm(project, this.getConnectionId());
        if (gitLabToolWindowProjectViewModel == null) {
            throw new IllegalStateException(("Missing project view model for " + this).toString());
        }
        GitLabToolWindowProjectViewModel projectVm2 = gitLabToolWindowProjectViewModel;
        ComponentManager $this$service$iv = (ComponentManager)project;
        boolean $i$f$service = false;
        Class<GitLabMergeRequestDiffService> serviceClass$iv = GitLabMergeRequestDiffService.class;
        Object object = $this$service$iv.getService(serviceClass$iv);
        if (object == null) {
            throw new IllegalStateException(("Cannot find service " + serviceClass$iv.getName() + " in " + $this$service$iv + " (classloader=" + serviceClass$iv.getClassLoader()).toString());
        }
        return ((GitLabMergeRequestDiffService)object).createDiffRequestProcessor(projectVm2, this.mergeRequestIid);
    }

    @NotNull
    public VirtualFileSystem getFileSystem() {
        return (VirtualFileSystem)GitLabVirtualFileSystem.Companion.getInstance();
    }

    @NotNull
    public FileType getFileType() {
        FileType fileType = FileTypes.UNKNOWN;
        Intrinsics.checkNotNullExpressionValue((Object)fileType, (String)"UNKNOWN");
        return fileType;
    }

    public long getLength() {
        return 0L;
    }

    @NotNull
    public Void contentsToByteArray() {
        throw new UnsupportedOperationException();
    }

    @NotNull
    public Void getInputStream() {
        throw new UnsupportedOperationException();
    }

    @NotNull
    public Void getOutputStream(@Nullable Object requestor, long newModificationStamp, long newTimeStamp) {
        throw new UnsupportedOperationException();
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof GitLabMergeRequestDiffFile)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.getConnectionId(), (Object)((GitLabMergeRequestDiffFile)other).getConnectionId())) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.project, (Object)((GitLabMergeRequestDiffFile)other).project)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.glProject, (Object)((GitLabMergeRequestDiffFile)other).glProject)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.mergeRequestIid, (Object)((GitLabMergeRequestDiffFile)other).mergeRequestIid);
    }

    public int hashCode() {
        int result2 = this.getConnectionId().hashCode();
        result2 = 31 * result2 + this.project.hashCode();
        result2 = 31 * result2 + this.glProject.hashCode();
        result2 = 31 * result2 + this.mergeRequestIid.hashCode();
        return result2;
    }

    @NotNull
    public String toString() {
        return "GitLabMergeRequestDiffFile(connectionId='" + this.getConnectionId() + "', project=" + this.project + ", glProject=" + this.glProject + ", mergeRequestId=" + this.mergeRequestIid + ")";
    }
}

