/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gitlab.authentication.ui;

import com.intellij.codeWithMe.ClientId;
import com.intellij.collaboration.auth.ui.login.LoginPanelModelBase;
import com.intellij.collaboration.auth.ui.login.LoginTokenGenerator;
import com.intellij.collaboration.util.URIUtil;
import com.intellij.ide.BrowserUtil;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.ComponentManagerEx;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.Dispatchers;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.gitlab.GitLabServersManager;
import org.jetbrains.plugins.gitlab.api.GitLabApi;
import org.jetbrains.plugins.gitlab.api.GitLabApiKt;
import org.jetbrains.plugins.gitlab.api.GitLabApiManager;
import org.jetbrains.plugins.gitlab.api.GitLabServerMetadata;
import org.jetbrains.plugins.gitlab.api.GitLabServerPath;
import org.jetbrains.plugins.gitlab.api.GitLabVersion;
import org.jetbrains.plugins.gitlab.api.dto.GitLabUserDetailedDTO;
import org.jetbrains.plugins.gitlab.api.request.GitLabUsersApiKt;
import org.jetbrains.plugins.gitlab.authentication.GitLabSecurityUtil;
import org.jetbrains.plugins.gitlab.authentication.ui.GitLabTokenLoginPanelModel;
import org.jetbrains.plugins.gitlab.util.GitLabBundle;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0010\n\u0002\u0010\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u00012\u00020\u0002B+\u0012\n\b\u0002\u0010\u0003\u001a\u0004\u0018\u00010\u0004\u0012\u0018\u0010\u0005\u001a\u0014\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\b0\u0006\u00a2\u0006\u0002\u0010\tJ\u0010\u0010\u0012\u001a\u00020\b2\u0006\u0010\u0013\u001a\u00020\u0004H\u0016J\u0011\u0010\u0014\u001a\u00020\u0004H\u0096@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u0015J\u0010\u0010\u0016\u001a\u00020\u00072\u0006\u0010\u0017\u001a\u00020\u0004H\u0002J\u0010\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u0013\u001a\u00020\u0004H\u0016J\u0006\u0010\u001a\u001a\u00020\u0007R\u001c\u0010\u0003\u001a\u0004\u0018\u00010\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\rR,\u0010\u0005\u001a\u0014\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\b0\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\u000f\"\u0004\b\u0010\u0010\u0011\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006\u001b"}, d2={"Lorg/jetbrains/plugins/gitlab/authentication/ui/GitLabTokenLoginPanelModel;", "Lcom/intellij/collaboration/auth/ui/login/LoginPanelModelBase;", "Lcom/intellij/collaboration/auth/ui/login/LoginTokenGenerator;", "requiredUsername", "", "uniqueAccountPredicate", "Lkotlin/Function2;", "Lorg/jetbrains/plugins/gitlab/api/GitLabServerPath;", "", "(Ljava/lang/String;Lkotlin/jvm/functions/Function2;)V", "getRequiredUsername", "()Ljava/lang/String;", "setRequiredUsername", "(Ljava/lang/String;)V", "getUniqueAccountPredicate", "()Lkotlin/jvm/functions/Function2;", "setUniqueAccountPredicate", "(Lkotlin/jvm/functions/Function2;)V", "canGenerateToken", "serverUri", "checkToken", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "createServerPath", "uri", "generateToken", "", "getServerPath", "intellij.vcs.gitlab"})
@SourceDebugExtension(value={"SMAP\nGitLabTokenLoginPanelModel.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GitLabTokenLoginPanelModel.kt\norg/jetbrains/plugins/gitlab/authentication/ui/GitLabTokenLoginPanelModel\n+ 2 service.kt\ncom/intellij/openapi/components/ServiceKt\n+ 3 services.kt\ncom/intellij/openapi/components/ServicesKt\n*L\n1#1,65:1\n43#2,3:66\n68#3:69\n*S KotlinDebug\n*F\n+ 1 GitLabTokenLoginPanelModel.kt\norg/jetbrains/plugins/gitlab/authentication/ui/GitLabTokenLoginPanelModel\n*L\n26#1:66,3\n32#1:69\n*E\n"})
public final class GitLabTokenLoginPanelModel
extends LoginPanelModelBase
implements LoginTokenGenerator {
    @Nullable
    private String requiredUsername;
    @NotNull
    private Function2<? super GitLabServerPath, ? super String, Boolean> uniqueAccountPredicate;

    public GitLabTokenLoginPanelModel(@Nullable String requiredUsername, @NotNull Function2<? super GitLabServerPath, ? super String, Boolean> uniqueAccountPredicate) {
        Intrinsics.checkNotNullParameter(uniqueAccountPredicate, (String)"uniqueAccountPredicate");
        this.requiredUsername = requiredUsername;
        this.uniqueAccountPredicate = uniqueAccountPredicate;
    }

    public /* synthetic */ GitLabTokenLoginPanelModel(String string, Function2 function2, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            string = null;
        }
        this(string, (Function2<? super GitLabServerPath, ? super String, Boolean>)function2);
    }

    @Nullable
    public final String getRequiredUsername() {
        return this.requiredUsername;
    }

    public final void setRequiredUsername(@Nullable String string) {
        this.requiredUsername = string;
    }

    @NotNull
    public final Function2<GitLabServerPath, String, Boolean> getUniqueAccountPredicate() {
        return this.uniqueAccountPredicate;
    }

    public final void setUniqueAccountPredicate(@NotNull Function2<? super GitLabServerPath, ? super String, Boolean> function2) {
        Intrinsics.checkNotNullParameter(function2, (String)"<set-?>");
        this.uniqueAccountPredicate = function2;
    }

    /*
     * Unable to fully structure code
     */
    @Nullable
    public Object checkToken(@NotNull Continuation<? super String> var1_1) {
        if (!(var1_1 instanceof checkToken.1)) ** GOTO lbl-1000
        var12_2 = var1_1;
        if ((var12_2.label & -2147483648) != 0) {
            var12_2.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, var1_1){
                Object L$0;
                Object L$1;
                Object L$2;
                Object L$3;
                /* synthetic */ Object result;
                final /* synthetic */ GitLabTokenLoginPanelModel this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return this.this$0.checkToken((Continuation<? super String>)((Continuation)this));
                }
            };
        }
        $result = $continuation.result;
        var13_4 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                server = this.createServerPath(this.getServerUri());
                $i$f$service = false;
                serviceClass$iv = GitLabApiManager.class;
                var6_9 = ApplicationManager.getApplication().getService(serviceClass$iv);
                if (var6_9 == null) {
                    throw new RuntimeException("Cannot find service " + serviceClass$iv.getName() + " (classloader=" + serviceClass$iv.getClassLoader() + ", client=" + ClientId.Companion.getCurrentOrNull() + ")");
                }
                api = ((GitLabApiManager)var6_9).getClient(server, this.getToken());
                $continuation.L$0 = this;
                $continuation.L$1 = server;
                $continuation.L$2 = api;
                $continuation.label = 1;
                v0 = BuildersKt.withContext((CoroutineContext)((CoroutineContext)Dispatchers.getIO()), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super GitLabUserDetailedDTO>, Object>(api, null){
                    int label;
                    final /* synthetic */ GitLabApi $api;
                    {
                        this.$api = $api;
                        super(2, $completion);
                    }

                    /*
                     * WARNING - void declaration
                     * Enabled force condition propagation
                     * Lifted jumps to return sites
                     */
                    @Nullable
                    public final Object invokeSuspend(@NotNull Object object) {
                        Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                        switch (this.label) {
                            case 0: {
                                ResultKt.throwOnFailure((Object)object);
                                this.label = 1;
                                Object object3 = GitLabUsersApiKt.getCurrentUser(this.$api.getGraphQL(), (Continuation<? super GitLabUserDetailedDTO>)((Continuation)this));
                                if (object3 != object2) return object3;
                                return object2;
                            }
                            case 1: {
                                void $result;
                                ResultKt.throwOnFailure((Object)$result);
                                Object object3 = $result;
                                return object3;
                            }
                        }
                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                    }

                    @NotNull
                    public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                        return (Continuation)new /* invalid duplicate definition of identical inner class */;
                    }

                    @Nullable
                    public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super GitLabUserDetailedDTO> p2) {
                        return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                    }
                }), (Continuation)$continuation);
                if (v0 == var13_4) {
                    return var13_4;
                }
                ** GOTO lbl33
            }
            case 1: {
                api = (GitLabApi)$continuation.L$2;
                server = (GitLabServerPath)$continuation.L$1;
                this = (GitLabTokenLoginPanelModel)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v0 = $result;
lbl33:
                // 2 sources

                user = (GitLabUserDetailedDTO)v0;
                $continuation.L$0 = this;
                $continuation.L$1 = server;
                $continuation.L$2 = user;
                $continuation.label = 2;
                v1 = GitLabApiKt.getMetadataOrNull(api, (Continuation<? super GitLabServerMetadata>)$continuation);
                if (v1 == var13_4) {
                    return var13_4;
                }
                ** GOTO lbl48
            }
            case 2: {
                user = (GitLabUserDetailedDTO)$continuation.L$2;
                server = (GitLabServerPath)$continuation.L$1;
                this = (GitLabTokenLoginPanelModel)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v1 = $result;
lbl48:
                // 2 sources

                v2 = (GitLabServerMetadata)v1;
                version = v2 != null ? v2.getVersion() : null;
                $i$f$serviceAsync = false;
                v3 = ApplicationManager.getApplication();
                Intrinsics.checkNotNull((Object)v3, (String)"null cannot be cast to non-null type com.intellij.openapi.components.ComponentManagerEx");
                $continuation.L$0 = this;
                $continuation.L$1 = server;
                $continuation.L$2 = user;
                $continuation.L$3 = version;
                $continuation.label = 3;
                v4 = ((ComponentManagerEx)v3).getServiceAsync(GitLabServersManager.class, (Continuation)$continuation);
                if (v4 == var13_4) {
                    return var13_4;
                }
                ** GOTO lbl71
            }
            case 3: {
                $i$f$serviceAsync = false;
                version = (GitLabVersion)$continuation.L$3;
                user = (GitLabUserDetailedDTO)$continuation.L$2;
                server = (GitLabServerPath)$continuation.L$1;
                this = (GitLabTokenLoginPanelModel)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v4 = $result;
lbl71:
                // 2 sources

                earliestSupportedVersion = ((GitLabServersManager)v4).getEarliestSupportedVersion();
                if (!(version != null && earliestSupportedVersion.compareTo(version) <= 0)) {
                    $i$a$-require-GitLabTokenLoginPanelModel$checkToken$2 = false;
                    var9_15 = new Object[]{String.valueOf(version), earliestSupportedVersion};
                    var8_14 = GitLabBundle.message("server.version.unsupported", var9_15);
                    throw new IllegalArgumentException(var8_14.toString());
                }
                username = user.getUsername();
                if (this.requiredUsername != null && !Intrinsics.areEqual((Object)username, (Object)this.requiredUsername)) {
                    $i$a$-require-GitLabTokenLoginPanelModel$checkToken$3 = false;
                    var10_20 = new Object[2];
                    Intrinsics.checkNotNull((Object)this.requiredUsername);
                    var10_20[1] = username;
                    $i$a$-require-GitLabTokenLoginPanelModel$checkToken$3 = GitLabBundle.message("account.username.mismatch", var10_20);
                    throw new IllegalArgumentException($i$a$-require-GitLabTokenLoginPanelModel$checkToken$3.toString());
                }
                if (!((Boolean)this.uniqueAccountPredicate.invoke((Object)server, (Object)username)).booleanValue()) {
                    $i$a$-require-GitLabTokenLoginPanelModel$checkToken$4 = false;
                    var10_21 = new Object[]{username};
                    var9_19 = GitLabBundle.message("account.not.unique", var10_21);
                    throw new IllegalArgumentException(var9_19.toString());
                }
                return username;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    @NotNull
    public final GitLabServerPath getServerPath() {
        return this.createServerPath(this.getServerUri());
    }

    private final GitLabServerPath createServerPath(String uri2) {
        String normalized = URIUtil.INSTANCE.normalizeAndValidateHttpUri(uri2);
        return new GitLabServerPath(normalized);
    }

    public boolean canGenerateToken(@NotNull String serverUri) {
        Intrinsics.checkNotNullParameter((Object)serverUri, (String)"serverUri");
        return URIUtil.INSTANCE.isValidHttpUri(serverUri);
    }

    public void generateToken(@NotNull String serverUri) {
        Intrinsics.checkNotNullParameter((Object)serverUri, (String)"serverUri");
        String string = GitLabSecurityUtil.INSTANCE.buildNewTokenUrl$intellij_vcs_gitlab(serverUri);
        if (string == null) {
            return;
        }
        String newTokenUrl = string;
        BrowserUtil.browse((String)newTokenUrl);
    }
}

