/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.sa.jdwp;

import com.jetbrains.sa.jdi.ArrayReferenceImpl;
import com.jetbrains.sa.jdi.ClassLoaderReferenceImpl;
import com.jetbrains.sa.jdi.ClassObjectReferenceImpl;
import com.jetbrains.sa.jdi.ClassTypeImpl;
import com.jetbrains.sa.jdi.FieldImpl;
import com.jetbrains.sa.jdi.InterfaceTypeImpl;
import com.jetbrains.sa.jdi.LocalVariableImpl;
import com.jetbrains.sa.jdi.LocationImpl;
import com.jetbrains.sa.jdi.MethodImpl;
import com.jetbrains.sa.jdi.MonitorInfoImpl;
import com.jetbrains.sa.jdi.ObjectReferenceImpl;
import com.jetbrains.sa.jdi.PrimitiveTypeImpl;
import com.jetbrains.sa.jdi.ReferenceTypeImpl;
import com.jetbrains.sa.jdi.StackFrameImpl;
import com.jetbrains.sa.jdi.StringReferenceImpl;
import com.jetbrains.sa.jdi.ThreadGroupReferenceImpl;
import com.jetbrains.sa.jdi.ThreadReferenceImpl;
import com.jetbrains.sa.jdi.TypeImpl;
import com.jetbrains.sa.jdi.ValueImpl;
import com.jetbrains.sa.jdwp.Command;
import com.jetbrains.sa.jdwp.PacketStream;
import com.jetbrains.sa.jdwp.VirtualMachineImpl;
import com.sun.jdi.AbsentInformationException;
import com.sun.jdi.ClassNotLoadedException;
import com.sun.jdi.IncompatibleThreadStateException;
import com.sun.jdi.VMDisconnectedException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class JDWP {
    private static void notImplemented(PacketStream answer) {
        answer.pkt.errorCode = (short)99;
    }

    static interface InvokeOptions {
        public static final int INVOKE_SINGLE_THREADED = 1;
        public static final int INVOKE_NONVIRTUAL = 2;
    }

    static interface SuspendPolicy {
        public static final int NONE = 0;
        public static final int EVENT_THREAD = 1;
        public static final int ALL = 2;
    }

    static interface StepSize {
        public static final int MIN = 0;
        public static final int LINE = 1;
    }

    static interface StepDepth {
        public static final int INTO = 0;
        public static final int OVER = 1;
        public static final int OUT = 2;
    }

    public static interface Tag {
        public static final byte ARRAY = 91;
        public static final byte BYTE = 66;
        public static final byte CHAR = 67;
        public static final byte OBJECT = 76;
        public static final byte FLOAT = 70;
        public static final byte DOUBLE = 68;
        public static final byte INT = 73;
        public static final byte LONG = 74;
        public static final byte SHORT = 83;
        public static final byte VOID = 86;
        public static final byte BOOLEAN = 90;
        public static final byte STRING = 115;
        public static final byte THREAD = 116;
        public static final byte THREAD_GROUP = 103;
        public static final byte CLASS_LOADER = 108;
        public static final byte CLASS_OBJECT = 99;
    }

    public static interface TypeTag {
        public static final byte CLASS = 1;
        public static final byte INTERFACE = 2;
        public static final byte ARRAY = 3;
    }

    static interface ClassStatus {
        public static final int VERIFIED = 1;
        public static final int PREPARED = 2;
        public static final int INITIALIZED = 4;
        public static final int ERROR = 8;
    }

    static interface SuspendStatus {
        public static final int SUSPEND_STATUS_SUSPENDED = 1;
    }

    static interface ThreadStatus {
        public static final int ZOMBIE = 0;
        public static final int RUNNING = 1;
        public static final int SLEEPING = 2;
        public static final int MONITOR = 3;
        public static final int WAIT = 4;
    }

    static interface EventKind {
        public static final int SINGLE_STEP = 1;
        public static final int BREAKPOINT = 2;
        public static final int FRAME_POP = 3;
        public static final int EXCEPTION = 4;
        public static final int USER_DEFINED = 5;
        public static final int THREAD_START = 6;
        public static final int THREAD_DEATH = 7;
        public static final int THREAD_END = 7;
        public static final int CLASS_PREPARE = 8;
        public static final int CLASS_UNLOAD = 9;
        public static final int CLASS_LOAD = 10;
        public static final int FIELD_ACCESS = 20;
        public static final int FIELD_MODIFICATION = 21;
        public static final int EXCEPTION_CATCH = 30;
        public static final int METHOD_ENTRY = 40;
        public static final int METHOD_EXIT = 41;
        public static final int METHOD_EXIT_WITH_RETURN_VALUE = 42;
        public static final int MONITOR_CONTENDED_ENTER = 43;
        public static final int MONITOR_CONTENDED_ENTERED = 44;
        public static final int MONITOR_WAIT = 45;
        public static final int MONITOR_WAITED = 46;
        public static final int VM_START = 90;
        public static final int VM_INIT = 90;
        public static final int VM_DEATH = 99;
        public static final int VM_DISCONNECTED = 100;
    }

    static interface Error {
        public static final int NONE = 0;
        public static final int INVALID_THREAD = 10;
        public static final int INVALID_THREAD_GROUP = 11;
        public static final int INVALID_PRIORITY = 12;
        public static final int THREAD_NOT_SUSPENDED = 13;
        public static final int THREAD_SUSPENDED = 14;
        public static final int THREAD_NOT_ALIVE = 15;
        public static final int INVALID_OBJECT = 20;
        public static final int INVALID_CLASS = 21;
        public static final int CLASS_NOT_PREPARED = 22;
        public static final int INVALID_METHODID = 23;
        public static final int INVALID_LOCATION = 24;
        public static final int INVALID_FIELDID = 25;
        public static final int INVALID_FRAMEID = 30;
        public static final int NO_MORE_FRAMES = 31;
        public static final int OPAQUE_FRAME = 32;
        public static final int NOT_CURRENT_FRAME = 33;
        public static final int TYPE_MISMATCH = 34;
        public static final int INVALID_SLOT = 35;
        public static final int DUPLICATE = 40;
        public static final int NOT_FOUND = 41;
        public static final int INVALID_MODULE = 42;
        public static final int INVALID_MONITOR = 50;
        public static final int NOT_MONITOR_OWNER = 51;
        public static final int INTERRUPT = 52;
        public static final int INVALID_CLASS_FORMAT = 60;
        public static final int CIRCULAR_CLASS_DEFINITION = 61;
        public static final int FAILS_VERIFICATION = 62;
        public static final int ADD_METHOD_NOT_IMPLEMENTED = 63;
        public static final int SCHEMA_CHANGE_NOT_IMPLEMENTED = 64;
        public static final int INVALID_TYPESTATE = 65;
        public static final int HIERARCHY_CHANGE_NOT_IMPLEMENTED = 66;
        public static final int DELETE_METHOD_NOT_IMPLEMENTED = 67;
        public static final int UNSUPPORTED_VERSION = 68;
        public static final int NAMES_DONT_MATCH = 69;
        public static final int CLASS_MODIFIERS_CHANGE_NOT_IMPLEMENTED = 70;
        public static final int METHOD_MODIFIERS_CHANGE_NOT_IMPLEMENTED = 71;
        public static final int NOT_IMPLEMENTED = 99;
        public static final int NULL_POINTER = 100;
        public static final int ABSENT_INFORMATION = 101;
        public static final int INVALID_EVENT_TYPE = 102;
        public static final int ILLEGAL_ARGUMENT = 103;
        public static final int OUT_OF_MEMORY = 110;
        public static final int ACCESS_DENIED = 111;
        public static final int VM_DEAD = 112;
        public static final int INTERNAL = 113;
        public static final int UNATTACHED_THREAD = 115;
        public static final int INVALID_TAG = 500;
        public static final int ALREADY_INVOKING = 502;
        public static final int INVALID_INDEX = 503;
        public static final int INVALID_LENGTH = 504;
        public static final int INVALID_STRING = 506;
        public static final int INVALID_CLASS_LOADER = 507;
        public static final int INVALID_ARRAY = 508;
        public static final int TRANSPORT_LOAD = 509;
        public static final int TRANSPORT_INIT = 510;
        public static final int NATIVE_METHOD = 511;
        public static final int INVALID_COUNT = 512;
    }

    static class Event {
        static final int COMMAND_SET = 64;

        private Event() {
        }

        static class Composite
        implements Command {
            static final int COMMAND = 100;

            Composite() {
            }

            @Override
            public void reply(VirtualMachineImpl vm, PacketStream answer, PacketStream command) {
            }

            static class Events {
                EventsCommon aEventsCommon;

                Events() {
                }

                public void reply(VirtualMachineImpl vm, PacketStream answer, PacketStream command) {
                }

                static class VMDeath
                extends EventsCommon {
                    static final byte ALT_ID = 99;

                    VMDeath() {
                    }

                    @Override
                    byte eventKind() {
                        return 99;
                    }

                    public void reply(VirtualMachineImpl vm, PacketStream answer, PacketStream command) {
                    }
                }

                static class FieldModification
                extends EventsCommon {
                    static final byte ALT_ID = 21;

                    FieldModification() {
                    }

                    @Override
                    byte eventKind() {
                        return 21;
                    }

                    public void reply(VirtualMachineImpl vm, PacketStream answer, PacketStream command) {
                    }
                }

                static class FieldAccess
                extends EventsCommon {
                    static final byte ALT_ID = 20;

                    FieldAccess() {
                    }

                    @Override
                    byte eventKind() {
                        return 20;
                    }

                    public void reply(VirtualMachineImpl vm, PacketStream answer, PacketStream command) {
                    }
                }

                static class ClassUnload
                extends EventsCommon {
                    static final byte ALT_ID = 9;

                    ClassUnload() {
                    }

                    @Override
                    byte eventKind() {
                        return 9;
                    }

                    public void reply(VirtualMachineImpl vm, PacketStream answer, PacketStream command) {
                    }
                }

                static class ClassPrepare
                extends EventsCommon {
                    static final byte ALT_ID = 8;

                    ClassPrepare() {
                    }

                    @Override
                    byte eventKind() {
                        return 8;
                    }

                    public void reply(VirtualMachineImpl vm, PacketStream answer, PacketStream command) {
                    }
                }

                static class ThreadDeath
                extends EventsCommon {
                    static final byte ALT_ID = 7;

                    ThreadDeath() {
                    }

                    @Override
                    byte eventKind() {
                        return 7;
                    }

                    public void reply(VirtualMachineImpl vm, PacketStream answer, PacketStream command) {
                    }
                }

                static class ThreadStart
                extends EventsCommon {
                    static final byte ALT_ID = 6;

                    ThreadStart() {
                    }

                    @Override
                    byte eventKind() {
                        return 6;
                    }

                    public void reply(VirtualMachineImpl vm, PacketStream answer, PacketStream command) {
                    }
                }

                static class Exception
                extends EventsCommon {
                    static final byte ALT_ID = 4;

                    Exception() {
                    }

                    @Override
                    byte eventKind() {
                        return 4;
                    }

                    public void reply(VirtualMachineImpl vm, PacketStream answer, PacketStream command) {
                    }
                }

                static class MonitorWaited
                extends EventsCommon {
                    static final byte ALT_ID = 46;

                    MonitorWaited() {
                    }

                    @Override
                    byte eventKind() {
                        return 46;
                    }

                    public void reply(VirtualMachineImpl vm, PacketStream answer, PacketStream command) {
                    }
                }

                static class MonitorWait
                extends EventsCommon {
                    static final byte ALT_ID = 45;

                    MonitorWait() {
                    }

                    @Override
                    byte eventKind() {
                        return 45;
                    }

                    public void reply(VirtualMachineImpl vm, PacketStream answer, PacketStream command) {
                    }
                }

                static class MonitorContendedEntered
                extends EventsCommon {
                    static final byte ALT_ID = 44;

                    MonitorContendedEntered() {
                    }

                    @Override
                    byte eventKind() {
                        return 44;
                    }

                    public void reply(VirtualMachineImpl vm, PacketStream answer, PacketStream command) {
                    }
                }

                static class MonitorContendedEnter
                extends EventsCommon {
                    static final byte ALT_ID = 43;

                    MonitorContendedEnter() {
                    }

                    @Override
                    byte eventKind() {
                        return 43;
                    }

                    public void reply(VirtualMachineImpl vm, PacketStream answer, PacketStream command) {
                    }
                }

                static class MethodExitWithReturnValue
                extends EventsCommon {
                    static final byte ALT_ID = 42;

                    MethodExitWithReturnValue() {
                    }

                    @Override
                    byte eventKind() {
                        return 42;
                    }

                    public void reply(VirtualMachineImpl vm, PacketStream answer, PacketStream command) {
                    }
                }

                static class MethodExit
                extends EventsCommon {
                    static final byte ALT_ID = 41;

                    MethodExit() {
                    }

                    @Override
                    byte eventKind() {
                        return 41;
                    }

                    public void reply(VirtualMachineImpl vm, PacketStream answer, PacketStream command) {
                    }
                }

                static class MethodEntry
                extends EventsCommon {
                    static final byte ALT_ID = 40;

                    MethodEntry() {
                    }

                    @Override
                    byte eventKind() {
                        return 40;
                    }

                    public void reply(VirtualMachineImpl vm, PacketStream answer, PacketStream command) {
                    }
                }

                static class Breakpoint
                extends EventsCommon {
                    static final byte ALT_ID = 2;

                    Breakpoint() {
                    }

                    @Override
                    byte eventKind() {
                        return 2;
                    }

                    public void reply(VirtualMachineImpl vm, PacketStream answer, PacketStream command) {
                    }
                }

                static class SingleStep
                extends EventsCommon {
                    static final byte ALT_ID = 1;

                    SingleStep() {
                    }

                    @Override
                    byte eventKind() {
                        return 1;
                    }

                    public void reply(VirtualMachineImpl vm, PacketStream answer, PacketStream command) {
                    }
                }

                static class VMStart
                extends EventsCommon {
                    static final byte ALT_ID = 90;

                    VMStart() {
                    }

                    @Override
                    byte eventKind() {
                        return 90;
                    }

                    public void reply(VirtualMachineImpl vm, PacketStream answer, PacketStream command) {
                    }
                }

                static abstract class EventsCommon {
                    EventsCommon() {
                    }

                    abstract byte eventKind();
                }
            }
        }
    }

    static class ModuleReference {
        static final int COMMAND_SET = 18;

        private ModuleReference() {
        }

        static class ClassLoader
        implements Command {
            static final int COMMAND = 2;

            ClassLoader() {
            }

            @Override
            public void reply(VirtualMachineImpl vm, PacketStream answer, PacketStream command) {
            }
        }

        static class Name
        implements Command {
            static final int COMMAND = 1;

            Name() {
            }

            @Override
            public void reply(VirtualMachineImpl vm, PacketStream answer, PacketStream command) {
            }
        }
    }

    static class ClassObjectReference {
        static final int COMMAND_SET = 17;

        private ClassObjectReference() {
        }

        static class ReflectedType
        implements Command {
            static final int COMMAND = 1;

            ReflectedType() {
            }

            @Override
            public void reply(VirtualMachineImpl vm, PacketStream answer, PacketStream command) {
                ClassObjectReferenceImpl reference = command.readClassObjectReference();
                ReferenceTypeImpl type = reference.reflectedType();
                if (type == null) {
                    answer.writeByte((byte)1);
                    answer.writeClassRef(0L);
                } else {
                    answer.writeByte(type.tag());
                    answer.writeClassRef(type.uniqueID());
                }
            }
        }
    }

    static class StackFrame {
        static final int COMMAND_SET = 16;

        private StackFrame() {
        }

        static class PopFrames
        implements Command {
            static final int COMMAND = 4;

            PopFrames() {
            }

            @Override
            public void reply(VirtualMachineImpl vm, PacketStream answer, PacketStream command) {
                JDWP.notImplemented(answer);
            }
        }

        static class ThisObject
        implements Command {
            static final int COMMAND = 3;

            ThisObject() {
            }

            @Override
            public void reply(VirtualMachineImpl vm, PacketStream answer, PacketStream command) {
                ThreadReferenceImpl thread = command.readThreadReference();
                try {
                    StackFrameImpl frame = thread.frame((int)command.readFrameRef());
                    answer.writeTaggedObjectReference(frame.thisObject());
                }
                catch (IncompatibleThreadStateException e) {
                    e.printStackTrace();
                }
            }
        }

        static class SetValues
        implements Command {
            static final int COMMAND = 2;

            SetValues() {
            }

            @Override
            public void reply(VirtualMachineImpl vm, PacketStream answer, PacketStream command) {
                JDWP.notImplemented(answer);
            }
        }

        static class GetValues
        implements Command {
            static final int COMMAND = 1;

            GetValues() {
            }

            @Override
            public void reply(VirtualMachineImpl vm, PacketStream answer, PacketStream command) {
                ThreadReferenceImpl thread = command.readThreadReference();
                try {
                    StackFrameImpl frame = thread.frame((int)command.readFrameRef());
                    int slots = command.readInt();
                    int available = frame.getAvailableSlots();
                    answer.writeInt(slots);
                    for (int i = 0; i < slots; ++i) {
                        int slot = command.readInt();
                        if (slot >= available) {
                            answer.pkt.errorCode = (short)35;
                            return;
                        }
                        ValueImpl slotValue = frame.getSlotValue(slot, command.readByte());
                        answer.writeValue(slotValue);
                    }
                }
                catch (IncompatibleThreadStateException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    static class EventRequest {
        static final int COMMAND_SET = 15;

        private EventRequest() {
        }

        static class ClearAllBreakpoints
        implements Command {
            static final int COMMAND = 3;

            ClearAllBreakpoints() {
            }

            @Override
            public void reply(VirtualMachineImpl vm, PacketStream answer, PacketStream command) {
                JDWP.notImplemented(answer);
            }
        }

        static class Clear
        implements Command {
            static final int COMMAND = 2;

            Clear() {
            }

            @Override
            public void reply(VirtualMachineImpl vm, PacketStream answer, PacketStream command) {
            }
        }

        static class Set
        implements Command {
            static final int COMMAND = 1;

            Set() {
            }

            @Override
            public void reply(VirtualMachineImpl vm, PacketStream answer, PacketStream command) {
                answer.writeInt(0);
            }
        }
    }

    static class ClassLoaderReference {
        static final int COMMAND_SET = 14;

        private ClassLoaderReference() {
        }

        static class VisibleClasses
        implements Command {
            static final int COMMAND = 1;

            VisibleClasses() {
            }

            @Override
            public void reply(VirtualMachineImpl vm, PacketStream answer, PacketStream command) {
                ClassLoaderReferenceImpl classLoaderReference = command.readClassLoaderReference();
                List<ReferenceTypeImpl> visibleClasses = classLoaderReference.visibleClasses();
                answer.writeInt(visibleClasses.size());
                for (ReferenceTypeImpl visibleClass : visibleClasses) {
                    answer.writeByte(visibleClass.tag());
                    answer.writeClassRef(visibleClass.uniqueID());
                }
            }

            static class ClassInfo {
                ClassInfo() {
                }

                public void reply(VirtualMachineImpl vm, PacketStream answer, PacketStream command) {
                }
            }
        }
    }

    static class ArrayReference {
        static final int COMMAND_SET = 13;

        private ArrayReference() {
        }

        static class SetValues
        implements Command {
            static final int COMMAND = 3;

            SetValues() {
            }

            @Override
            public void reply(VirtualMachineImpl vm, PacketStream answer, PacketStream command) {
                JDWP.notImplemented(answer);
            }
        }

        static class GetValues
        implements Command {
            static final int COMMAND = 2;

            GetValues() {
            }

            @Override
            public void reply(VirtualMachineImpl vm, PacketStream answer, PacketStream command) {
                byte tag;
                ArrayReferenceImpl arrayReference = command.readArrayReference();
                int start = command.readInt();
                int length = command.readInt();
                try {
                    TypeImpl type = arrayReference.arrayType().componentType();
                    tag = type instanceof PrimitiveTypeImpl ? (byte)((PrimitiveTypeImpl)type).tag() : (byte)76;
                }
                catch (ClassNotLoadedException e) {
                    tag = ValueImpl.typeValueKey(arrayReference.getValue(0));
                }
                answer.writeArrayRegion(arrayReference.getValues(start, length), tag);
            }
        }

        static class Length
        implements Command {
            static final int COMMAND = 1;

            Length() {
            }

            @Override
            public void reply(VirtualMachineImpl vm, PacketStream answer, PacketStream command) {
                ArrayReferenceImpl arrayReference = command.readArrayReference();
                answer.writeInt(arrayReference.length());
            }
        }
    }

    static class ThreadGroupReference {
        static final int COMMAND_SET = 12;

        private ThreadGroupReference() {
        }

        static class Children
        implements Command {
            static final int COMMAND = 3;

            Children() {
            }

            @Override
            public void reply(VirtualMachineImpl vm, PacketStream answer, PacketStream command) {
                ThreadGroupReferenceImpl group = command.readThreadGroupReference();
                List<ThreadReferenceImpl> threads = group.threads();
                answer.writeInt(threads.size());
                for (ThreadReferenceImpl thread : threads) {
                    answer.writeThreadReference(thread);
                }
                List<ThreadGroupReferenceImpl> threadGroups = group.threadGroups();
                answer.writeInt(threadGroups.size());
                for (ThreadGroupReferenceImpl threadGroup : threadGroups) {
                    answer.writeThreadGroupReference(threadGroup);
                }
            }
        }

        static class Parent
        implements Command {
            static final int COMMAND = 2;

            Parent() {
            }

            @Override
            public void reply(VirtualMachineImpl vm, PacketStream answer, PacketStream command) {
                ThreadGroupReferenceImpl group = command.readThreadGroupReference();
                answer.writeThreadGroupReference(group.parent());
            }
        }

        static class Name
        implements Command {
            static final int COMMAND = 1;

            Name() {
            }

            @Override
            public void reply(VirtualMachineImpl vm, PacketStream answer, PacketStream command) {
                ThreadGroupReferenceImpl group = command.readThreadGroupReference();
                answer.writeString(group.name());
            }
        }
    }

    static class ThreadReference {
        static final int COMMAND_SET = 11;

        private ThreadReference() {
        }

        static class ForceEarlyReturn
        implements Command {
            static final int COMMAND = 14;

            ForceEarlyReturn() {
            }

            @Override
            public void reply(VirtualMachineImpl vm, PacketStream answer, PacketStream command) {
                JDWP.notImplemented(answer);
            }
        }

        static class OwnedMonitorsStackDepthInfo
        implements Command {
            static final int COMMAND = 13;

            OwnedMonitorsStackDepthInfo() {
            }

            @Override
            public void reply(VirtualMachineImpl vm, PacketStream answer, PacketStream command) {
                List<MonitorInfoImpl> list;
                ThreadReferenceImpl thread = command.readThreadReference();
                try {
                    list = thread.ownedMonitorsAndFrames();
                }
                catch (IncompatibleThreadStateException e) {
                    answer.pkt.errorCode = (short)10;
                    return;
                }
                answer.writeInt(list.size());
                for (MonitorInfoImpl o : list) {
                    answer.writeTaggedObjectReference(o.monitor());
                    answer.writeInt(o.stackDepth());
                }
            }

            static class monitor {
                monitor() {
                }

                public void reply(VirtualMachineImpl vm, PacketStream answer, PacketStream command) {
                }
            }
        }

        static class SuspendCount
        implements Command {
            static final int COMMAND = 12;

            SuspendCount() {
            }

            @Override
            public void reply(VirtualMachineImpl vm, PacketStream answer, PacketStream command) {
                answer.writeInt(1);
            }
        }

        static class Interrupt
        implements Command {
            static final int COMMAND = 11;

            Interrupt() {
            }

            @Override
            public void reply(VirtualMachineImpl vm, PacketStream answer, PacketStream command) {
                JDWP.notImplemented(answer);
            }
        }

        static class Stop
        implements Command {
            static final int COMMAND = 10;

            Stop() {
            }

            @Override
            public void reply(VirtualMachineImpl vm, PacketStream answer, PacketStream command) {
                JDWP.notImplemented(answer);
            }
        }

        static class CurrentContendedMonitor
        implements Command {
            static final int COMMAND = 9;

            CurrentContendedMonitor() {
            }

            @Override
            public void reply(VirtualMachineImpl vm, PacketStream answer, PacketStream command) {
                ThreadReferenceImpl thread = command.readThreadReference();
                try {
                    answer.writeTaggedObjectReference(thread.currentContendedMonitor());
                }
                catch (IncompatibleThreadStateException e) {
                    answer.pkt.errorCode = (short)10;
                }
            }
        }

        static class OwnedMonitors
        implements Command {
            static final int COMMAND = 8;

            OwnedMonitors() {
            }

            @Override
            public void reply(VirtualMachineImpl vm, PacketStream answer, PacketStream command) {
                List<ObjectReferenceImpl> ownedMonitors;
                ThreadReferenceImpl thread = command.readThreadReference();
                try {
                    ownedMonitors = thread.ownedMonitors();
                }
                catch (IncompatibleThreadStateException e) {
                    answer.pkt.errorCode = (short)10;
                    return;
                }
                answer.writeInt(ownedMonitors.size());
                for (ObjectReferenceImpl ownedMonitor : ownedMonitors) {
                    answer.writeTaggedObjectReference(ownedMonitor);
                }
            }
        }

        static class FrameCount
        implements Command {
            static final int COMMAND = 7;

            FrameCount() {
            }

            @Override
            public void reply(VirtualMachineImpl vm, PacketStream answer, PacketStream command) {
                ThreadReferenceImpl thread = command.readThreadReference();
                try {
                    answer.writeInt(thread.frameCount());
                }
                catch (IncompatibleThreadStateException e) {
                    answer.pkt.errorCode = (short)10;
                }
            }
        }

        static class Frames
        implements Command {
            static final int COMMAND = 6;

            Frames() {
            }

            @Override
            public void reply(VirtualMachineImpl vm, PacketStream answer, PacketStream command) {
                ThreadReferenceImpl thread = command.readThreadReference();
                int start = command.readInt();
                int length = command.readInt();
                try {
                    List<StackFrameImpl> frames = thread.privateFrames(start, length);
                    answer.writeInt(frames.size());
                    for (StackFrameImpl frame : frames) {
                        Frame.write(frame, vm, answer);
                    }
                }
                catch (IncompatibleThreadStateException e) {
                    answer.pkt.errorCode = (short)10;
                }
            }

            static class Frame {
                Frame() {
                }

                public static void write(StackFrameImpl frame, VirtualMachineImpl vm, PacketStream answer) {
                    answer.writeFrameRef(frame.id());
                    answer.writeLocation(frame.location());
                }
            }
        }

        static class ThreadGroup
        implements Command {
            static final int COMMAND = 5;

            ThreadGroup() {
            }

            @Override
            public void reply(VirtualMachineImpl vm, PacketStream answer, PacketStream command) {
                ThreadReferenceImpl thread = command.readThreadReference();
                answer.writeObjectRef(thread.threadGroup().uniqueID());
            }
        }

        static class Status
        implements Command {
            static final int COMMAND = 4;

            Status() {
            }

            @Override
            public void reply(VirtualMachineImpl vm, PacketStream answer, PacketStream command) {
                ThreadReferenceImpl thread = command.readThreadReference();
                answer.writeInt(thread.status());
                answer.writeInt(thread.suspendCount());
            }
        }

        static class Resume
        implements Command {
            static final int COMMAND = 3;

            Resume() {
            }

            @Override
            public void reply(VirtualMachineImpl vm, PacketStream answer, PacketStream command) {
                JDWP.notImplemented(answer);
            }
        }

        static class Suspend
        implements Command {
            static final int COMMAND = 2;

            Suspend() {
            }

            @Override
            public void reply(VirtualMachineImpl vm, PacketStream answer, PacketStream command) {
                JDWP.notImplemented(answer);
            }
        }

        static class Name
        implements Command {
            static final int COMMAND = 1;

            Name() {
            }

            @Override
            public void reply(VirtualMachineImpl vm, PacketStream answer, PacketStream command) {
                answer.writeString(command.readThreadReference().name());
            }
        }
    }

    static class StringReference {
        static final int COMMAND_SET = 10;

        private StringReference() {
        }

        static class Value
        implements Command {
            static final int COMMAND = 1;

            Value() {
            }

            @Override
            public void reply(VirtualMachineImpl vm, PacketStream answer, PacketStream command) {
                ObjectReferenceImpl objectReference = command.readObjectReference();
                if (objectReference instanceof StringReferenceImpl) {
                    answer.writeString(((StringReferenceImpl)objectReference).value());
                } else {
                    answer.pkt.errorCode = (short)506;
                }
            }
        }
    }

    static class ObjectReference {
        static final int COMMAND_SET = 9;

        private ObjectReference() {
        }

        static class ReferringObjects
        implements Command {
            static final int COMMAND = 10;

            ReferringObjects() {
            }

            @Override
            public void reply(VirtualMachineImpl vm, PacketStream answer, PacketStream command) {
                ObjectReferenceImpl objectReference = vm.vm.objectMirror(command.readObjectRef());
                List<ObjectReferenceImpl> refs = objectReference.referringObjects(command.readInt());
                answer.writeInt(refs.size());
                for (ObjectReferenceImpl ref : refs) {
                    answer.writeTaggedObjectReference(ref);
                }
            }
        }

        static class IsCollected
        implements Command {
            static final int COMMAND = 9;

            IsCollected() {
            }

            @Override
            public void reply(VirtualMachineImpl vm, PacketStream answer, PacketStream command) {
                answer.writeBoolean(false);
            }
        }

        static class EnableCollection
        implements Command {
            static final int COMMAND = 8;

            EnableCollection() {
            }

            @Override
            public void reply(VirtualMachineImpl vm, PacketStream answer, PacketStream command) {
                JDWP.notImplemented(answer);
            }
        }

        static class DisableCollection
        implements Command {
            static final int COMMAND = 7;

            DisableCollection() {
            }

            @Override
            public void reply(VirtualMachineImpl vm, PacketStream answer, PacketStream command) {
                JDWP.notImplemented(answer);
            }
        }

        static class InvokeMethod
        implements Command {
            static final int COMMAND = 6;

            InvokeMethod() {
            }

            @Override
            public void reply(VirtualMachineImpl vm, PacketStream answer, PacketStream command) {
                JDWP.notImplemented(answer);
            }
        }

        static class MonitorInfo
        implements Command {
            static final int COMMAND = 5;

            MonitorInfo() {
            }

            @Override
            public void reply(VirtualMachineImpl vm, PacketStream answer, PacketStream command) {
                ObjectReferenceImpl objectReference = vm.vm.objectMirror(command.readObjectRef());
                answer.writeThreadReference(objectReference.owningThread());
                answer.writeInt(objectReference.entryCount());
                List<ThreadReferenceImpl> waiting = objectReference.waitingThreads();
                answer.writeInt(waiting.size());
                for (ThreadReferenceImpl threadReference : waiting) {
                    answer.writeThreadReference(threadReference);
                }
            }
        }

        static class SetValues
        implements Command {
            static final int COMMAND = 3;

            SetValues() {
            }

            @Override
            public void reply(VirtualMachineImpl vm, PacketStream answer, PacketStream command) {
                JDWP.notImplemented(answer);
            }
        }

        static class GetValues
        implements Command {
            static final int COMMAND = 2;

            GetValues() {
            }

            @Override
            public void reply(VirtualMachineImpl vm, PacketStream answer, PacketStream command) {
                ObjectReferenceImpl objectReference = vm.vm.objectMirror(command.readObjectRef());
                ReferenceTypeImpl referenceType = objectReference.referenceType();
                int count = command.readInt();
                answer.writeInt(count);
                for (int i = 0; i < count; ++i) {
                    long id = command.readFieldRef();
                    answer.writeValue(objectReference.getValue(referenceType.fieldById(id)));
                }
            }
        }

        static class ReferenceType
        implements Command {
            static final int COMMAND = 1;

            ReferenceType() {
            }

            @Override
            public void reply(VirtualMachineImpl vm, PacketStream answer, PacketStream command) {
                ObjectReferenceImpl objectReference = vm.vm.objectMirror(command.readObjectRef());
                ReferenceTypeImpl referenceType = objectReference.referenceType();
                answer.writeByte(referenceType.tag());
                answer.writeClassRef(referenceType.uniqueID());
            }
        }
    }

    static class Field {
        static final int COMMAND_SET = 8;

        private Field() {
        }
    }

    static class Method {
        static final int COMMAND_SET = 6;

        private Method() {
        }

        static class VariableTableWithGeneric
        implements Command {
            static final int COMMAND = 5;

            VariableTableWithGeneric() {
            }

            @Override
            public void reply(VirtualMachineImpl vm, PacketStream answer, PacketStream command) {
                ReferenceTypeImpl referenceType = command.readReferenceType();
                MethodImpl method = referenceType.methodById(command.readMethodRef());
                try {
                    List<LocalVariableImpl> variables = method.variables();
                    answer.writeInt(method.argSlotCount());
                    answer.writeInt(variables.size());
                    for (LocalVariableImpl variable : variables) {
                        SlotInfo.write(variable, vm, answer);
                    }
                }
                catch (AbsentInformationException e) {
                    answer.pkt.errorCode = (short)101;
                }
            }

            static class SlotInfo {
                SlotInfo() {
                }

                public static void write(LocalVariableImpl var, VirtualMachineImpl vm, PacketStream answer) {
                    answer.writeLong(var.getStart());
                    answer.writeString(var.name());
                    answer.writeString(var.signature());
                    answer.writeStringOrEmpty(var.genericSignature());
                    answer.writeInt(var.getLength());
                    answer.writeInt(var.slot());
                }
            }
        }

        static class IsObsolete
        implements Command {
            static final int COMMAND = 4;

            IsObsolete() {
            }

            @Override
            public void reply(VirtualMachineImpl vm, PacketStream answer, PacketStream command) {
                ReferenceTypeImpl referenceType = command.readReferenceType();
                MethodImpl method = referenceType.methodById(command.readMethodRef());
                answer.writeBoolean(method.isObsolete());
            }
        }

        static class Bytecodes
        implements Command {
            static final int COMMAND = 3;

            Bytecodes() {
            }

            @Override
            public void reply(VirtualMachineImpl vm, PacketStream answer, PacketStream command) {
                ReferenceTypeImpl referenceType = command.readReferenceType();
                MethodImpl method = referenceType.methodById(command.readMethodRef());
                byte[] bytecodes = method.bytecodes();
                answer.writeInt(bytecodes.length);
                answer.writeByteArray(bytecodes);
            }
        }

        static class VariableTable
        implements Command {
            static final int COMMAND = 2;

            VariableTable() {
            }

            @Override
            public void reply(VirtualMachineImpl vm, PacketStream answer, PacketStream command) {
                ReferenceTypeImpl referenceType = command.readReferenceType();
                MethodImpl method = referenceType.methodById(command.readMethodRef());
                try {
                    List<LocalVariableImpl> variables = method.variables();
                    answer.writeInt(method.argSlotCount());
                    answer.writeInt(variables.size());
                    for (LocalVariableImpl variable : variables) {
                        SlotInfo.write(variable, vm, answer);
                    }
                }
                catch (AbsentInformationException e) {
                    answer.pkt.errorCode = (short)101;
                }
            }

            static class SlotInfo {
                SlotInfo() {
                }

                public static void write(LocalVariableImpl var, VirtualMachineImpl vm, PacketStream answer) {
                    answer.writeLong(var.getStart());
                    answer.writeString(var.name());
                    answer.writeString(var.signature());
                    answer.writeInt(var.getLength());
                    answer.writeInt(var.slot());
                }
            }
        }

        static class LineTable
        implements Command {
            static final int COMMAND = 1;

            LineTable() {
            }

            @Override
            public void reply(VirtualMachineImpl vm, PacketStream answer, PacketStream command) {
                ReferenceTypeImpl referenceType = command.readReferenceType();
                MethodImpl method = referenceType.methodById(command.readMethodRef());
                if (method.isNative()) {
                    answer.pkt.errorCode = (short)511;
                    return;
                }
                List<Object> locations = Collections.emptyList();
                try {
                    locations = method.allLineLocations();
                }
                catch (AbsentInformationException ignored) {
                    // empty catch block
                }
                sun.jvm.hotspot.oops.Method ref = method.ref();
                long start = 0L;
                long end = ref.getCodeSize();
                if (end == 0L) {
                    start = -1L;
                }
                answer.writeLong(start);
                answer.writeLong(end);
                answer.writeInt(locations.size());
                for (LocationImpl locationImpl : locations) {
                    answer.writeLong(locationImpl.codeIndex());
                    answer.writeInt(locationImpl.lineNumber());
                }
            }

            static class LineInfo {
                LineInfo() {
                }

                public void reply(VirtualMachineImpl vm, PacketStream answer, PacketStream command) {
                }
            }
        }
    }

    static class InterfaceType {
        static final int COMMAND_SET = 5;

        private InterfaceType() {
        }

        static class InvokeMethod
        implements Command {
            static final int COMMAND = 1;

            InvokeMethod() {
            }

            @Override
            public void reply(VirtualMachineImpl vm, PacketStream answer, PacketStream command) {
                JDWP.notImplemented(answer);
            }
        }
    }

    static class ArrayType {
        static final int COMMAND_SET = 4;

        private ArrayType() {
        }

        static class NewInstance
        implements Command {
            static final int COMMAND = 1;

            NewInstance() {
            }

            @Override
            public void reply(VirtualMachineImpl vm, PacketStream answer, PacketStream command) {
                JDWP.notImplemented(answer);
            }
        }
    }

    static class ClassType {
        static final int COMMAND_SET = 3;

        private ClassType() {
        }

        static class NewInstance
        implements Command {
            static final int COMMAND = 4;

            NewInstance() {
            }

            @Override
            public void reply(VirtualMachineImpl vm, PacketStream answer, PacketStream command) {
                JDWP.notImplemented(answer);
            }
        }

        static class InvokeMethod
        implements Command {
            static final int COMMAND = 3;

            InvokeMethod() {
            }

            @Override
            public void reply(VirtualMachineImpl vm, PacketStream answer, PacketStream command) {
                JDWP.notImplemented(answer);
            }
        }

        static class SetValues
        implements Command {
            static final int COMMAND = 2;

            SetValues() {
            }

            @Override
            public void reply(VirtualMachineImpl vm, PacketStream answer, PacketStream command) {
                JDWP.notImplemented(answer);
            }
        }

        static class Superclass
        implements Command {
            static final int COMMAND = 1;

            Superclass() {
            }

            @Override
            public void reply(VirtualMachineImpl vm, PacketStream answer, PacketStream command) {
                ReferenceTypeImpl type = command.readReferenceType();
                if (type instanceof ClassTypeImpl) {
                    ClassTypeImpl superclass = ((ClassTypeImpl)type).superclass();
                    if (superclass != null) {
                        answer.writeClassRef(superclass.uniqueID());
                    } else {
                        answer.writeNullObjectRef();
                    }
                } else {
                    answer.pkt.errorCode = (short)21;
                }
            }
        }
    }

    static class ReferenceType {
        static final int COMMAND_SET = 2;

        private ReferenceType() {
        }

        static class Module
        implements Command {
            static final int COMMAND = 19;

            Module() {
            }

            @Override
            public void reply(VirtualMachineImpl vm, PacketStream answer, PacketStream command) {
            }
        }

        static class ConstantPool
        implements Command {
            static final int COMMAND = 18;

            ConstantPool() {
            }

            @Override
            public void reply(VirtualMachineImpl vm, PacketStream answer, PacketStream command) {
                ReferenceTypeImpl type = command.readReferenceType();
                byte[] bytes = type.constantPool();
                answer.writeInt(type.constantPoolCount());
                answer.writeInt(bytes.length);
                answer.writeByteArray(bytes);
            }
        }

        static class ClassFileVersion
        implements Command {
            static final int COMMAND = 17;

            ClassFileVersion() {
            }

            @Override
            public void reply(VirtualMachineImpl vm, PacketStream answer, PacketStream command) {
                ReferenceTypeImpl type = command.readReferenceType();
                answer.writeInt(type.majorVersion());
                answer.writeInt(type.minorVersion());
            }
        }

        static class Instances
        implements Command {
            static final int COMMAND = 16;

            Instances() {
            }

            @Override
            public void reply(VirtualMachineImpl vm, PacketStream answer, PacketStream command) {
                ReferenceTypeImpl type = command.readReferenceType();
                List<ObjectReferenceImpl> instances = type.instances(command.readInt());
                answer.writeInt(instances.size());
                for (ObjectReferenceImpl instance : instances) {
                    answer.writeTaggedObjectReference(instance);
                }
            }
        }

        static class MethodsWithGeneric
        implements Command {
            static final int COMMAND = 15;

            MethodsWithGeneric() {
            }

            @Override
            public void reply(VirtualMachineImpl vm, PacketStream answer, PacketStream command) {
                ReferenceTypeImpl type = command.readReferenceType();
                List<MethodImpl> methods = type.methods();
                answer.writeInt(methods.size());
                for (MethodImpl method : methods) {
                    MethodInfo.write(method, vm, answer);
                }
            }

            static class MethodInfo {
                MethodInfo() {
                }

                public static void write(MethodImpl method, VirtualMachineImpl vm, PacketStream answer) {
                    answer.writeMethodRef(method.uniqueID());
                    answer.writeString(method.name());
                    answer.writeString(method.signature());
                    answer.writeStringOrEmpty(method.genericSignature());
                    answer.writeInt(method.modifiers());
                }
            }
        }

        static class FieldsWithGeneric
        implements Command {
            static final int COMMAND = 14;

            FieldsWithGeneric() {
            }

            @Override
            public void reply(VirtualMachineImpl vm, PacketStream answer, PacketStream command) {
                ReferenceTypeImpl type = command.readReferenceType();
                List<FieldImpl> fields = type.fields();
                answer.writeInt(fields.size());
                for (FieldImpl field : fields) {
                    FieldInfo.write(field, vm, answer);
                }
            }

            static class FieldInfo {
                FieldInfo() {
                }

                public static void write(FieldImpl field, VirtualMachineImpl vm, PacketStream answer) {
                    answer.writeFieldRef(field.uniqueID());
                    answer.writeString(field.name());
                    answer.writeString(field.signature());
                    answer.writeStringOrEmpty(field.genericSignature());
                    answer.writeInt(field.modifiers());
                }
            }
        }

        static class SignatureWithGeneric
        implements Command {
            static final int COMMAND = 13;

            SignatureWithGeneric() {
            }

            @Override
            public void reply(VirtualMachineImpl vm, PacketStream answer, PacketStream command) {
                ReferenceTypeImpl type = command.readReferenceType();
                answer.writeString(type.signature());
                answer.writeStringOrEmpty(type.genericSignature());
            }
        }

        static class SourceDebugExtension
        implements Command {
            static final int COMMAND = 12;

            SourceDebugExtension() {
            }

            @Override
            public void reply(VirtualMachineImpl vm, PacketStream answer, PacketStream command) {
                ReferenceTypeImpl type = command.readReferenceType();
                try {
                    answer.writeString(type.sourceDebugExtension());
                }
                catch (AbsentInformationException e) {
                    answer.pkt.errorCode = (short)101;
                }
            }
        }

        static class ClassObject
        implements Command {
            static final int COMMAND = 11;

            ClassObject() {
            }

            @Override
            public void reply(VirtualMachineImpl vm, PacketStream answer, PacketStream command) {
                ReferenceTypeImpl type = command.readReferenceType();
                answer.writeClassObjectReference(type.classObject());
            }
        }

        static class Interfaces
        implements Command {
            static final int COMMAND = 10;

            Interfaces() {
            }

            @Override
            public void reply(VirtualMachineImpl vm, PacketStream answer, PacketStream command) {
                List<InterfaceTypeImpl> interfaces;
                ReferenceTypeImpl type = command.readReferenceType();
                if (type instanceof ClassTypeImpl) {
                    interfaces = ((ClassTypeImpl)type).interfaces();
                } else if (type instanceof InterfaceTypeImpl) {
                    interfaces = ((InterfaceTypeImpl)type).superinterfaces();
                } else {
                    answer.pkt.errorCode = (short)21;
                    return;
                }
                answer.writeInt(interfaces.size());
                for (InterfaceTypeImpl iface : interfaces) {
                    answer.writeClassRef(iface.uniqueID());
                }
            }
        }

        static class Status
        implements Command {
            static final int COMMAND = 9;

            Status() {
            }

            @Override
            public void reply(VirtualMachineImpl vm, PacketStream answer, PacketStream command) {
                ReferenceTypeImpl type = command.readReferenceType();
                answer.writeInt(type.ref().getClassStatus());
            }
        }

        static class NestedTypes
        implements Command {
            static final int COMMAND = 8;

            NestedTypes() {
            }

            @Override
            public void reply(VirtualMachineImpl vm, PacketStream answer, PacketStream command) {
                ReferenceTypeImpl type = command.readReferenceType();
                List<ReferenceTypeImpl> nestedTypes = type.nestedTypes();
                answer.writeInt(nestedTypes.size());
                for (ReferenceTypeImpl nestedType : nestedTypes) {
                    TypeInfo.write(nestedType, vm, answer);
                }
            }

            static class TypeInfo {
                TypeInfo() {
                }

                public static void write(ReferenceTypeImpl type, VirtualMachineImpl vm, PacketStream answer) {
                    answer.writeByte(type.tag());
                    answer.writeClassRef(type.uniqueID());
                }
            }
        }

        static class SourceFile
        implements Command {
            static final int COMMAND = 7;

            SourceFile() {
            }

            @Override
            public void reply(VirtualMachineImpl vm, PacketStream answer, PacketStream command) {
                ReferenceTypeImpl type = command.readReferenceType();
                try {
                    answer.writeString(type.baseSourceName());
                }
                catch (AbsentInformationException e) {
                    answer.pkt.errorCode = (short)101;
                }
            }
        }

        static class GetValues
        implements Command {
            static final int COMMAND = 6;

            GetValues() {
            }

            @Override
            public void reply(VirtualMachineImpl vm, PacketStream answer, PacketStream command) {
                ReferenceTypeImpl referenceType = command.readReferenceType();
                int size = command.readInt();
                answer.writeInt(size);
                for (int i = 0; i < size; ++i) {
                    answer.writeValue(referenceType.getValue(referenceType.fieldById(command.readFieldRef())));
                }
            }
        }

        static class Methods
        implements Command {
            static final int COMMAND = 5;

            Methods() {
            }

            @Override
            public void reply(VirtualMachineImpl vm, PacketStream answer, PacketStream command) {
                ReferenceTypeImpl type = command.readReferenceType();
                List<MethodImpl> methods = type.methods();
                answer.writeInt(methods.size());
                for (MethodImpl method : methods) {
                    MethodInfo.write(method, vm, answer);
                }
            }

            static class MethodInfo {
                MethodInfo() {
                }

                public static void write(MethodImpl method, VirtualMachineImpl vm, PacketStream answer) {
                    answer.writeMethodRef(method.uniqueID());
                    answer.writeString(method.name());
                    answer.writeString(method.signature());
                    answer.writeInt(method.modifiers());
                }
            }
        }

        static class Fields
        implements Command {
            static final int COMMAND = 4;

            Fields() {
            }

            @Override
            public void reply(VirtualMachineImpl vm, PacketStream answer, PacketStream command) {
                ReferenceTypeImpl type = command.readReferenceType();
                List<FieldImpl> fields = type.fields();
                answer.writeInt(fields.size());
                for (FieldImpl field : fields) {
                    FieldInfo.write(field, vm, answer);
                }
            }

            static class FieldInfo {
                FieldInfo() {
                }

                public static void write(FieldImpl field, VirtualMachineImpl vm, PacketStream answer) {
                    answer.writeFieldRef(field.uniqueID());
                    answer.writeString(field.name());
                    answer.writeString(field.signature());
                    answer.writeInt(field.modifiers());
                }
            }
        }

        static class Modifiers
        implements Command {
            static final int COMMAND = 3;

            Modifiers() {
            }

            @Override
            public void reply(VirtualMachineImpl vm, PacketStream answer, PacketStream command) {
                ReferenceTypeImpl referenceType = command.readReferenceType();
                answer.writeInt(referenceType.modifiers());
            }
        }

        static class ClassLoader
        implements Command {
            static final int COMMAND = 2;

            ClassLoader() {
            }

            @Override
            public void reply(VirtualMachineImpl vm, PacketStream answer, PacketStream command) {
                ReferenceTypeImpl referenceType = command.readReferenceType();
                answer.writeClassLoaderReference(referenceType.classLoader());
            }
        }

        static class Signature
        implements Command {
            static final int COMMAND = 1;

            Signature() {
            }

            @Override
            public void reply(VirtualMachineImpl vm, PacketStream answer, PacketStream command) {
                ReferenceTypeImpl referenceType = command.readReferenceType();
                answer.writeString(referenceType.signature());
            }
        }
    }

    static class VirtualMachine {
        static final int COMMAND_SET = 1;

        private VirtualMachine() {
        }

        static class AllModules
        implements Command {
            static final int COMMAND = 22;

            AllModules() {
            }

            @Override
            public void reply(VirtualMachineImpl vm, PacketStream answer, PacketStream command) {
            }
        }

        static class InstanceCounts
        implements Command {
            static final int COMMAND = 21;

            InstanceCounts() {
            }

            @Override
            public void reply(VirtualMachineImpl vm, PacketStream answer, PacketStream command) {
                int count = command.readInt();
                ArrayList<ReferenceTypeImpl> refs = new ArrayList<ReferenceTypeImpl>(count);
                for (int i = 0; i < count; ++i) {
                    refs.add(command.readReferenceType());
                }
                long[] counts = vm.vm.instanceCounts(refs);
                answer.writeInt(counts.length);
                for (long l : counts) {
                    answer.writeLong(l);
                }
            }
        }

        static class AllClassesWithGeneric
        implements Command {
            static final int COMMAND = 20;

            AllClassesWithGeneric() {
            }

            @Override
            public void reply(VirtualMachineImpl vm, PacketStream answer, PacketStream command) {
                List<ReferenceTypeImpl> allClasses = vm.vm.allClasses();
                answer.writeInt(allClasses.size());
                for (ReferenceTypeImpl cls : allClasses) {
                    ClassInfo.write(cls, vm, answer);
                }
            }

            static class ClassInfo {
                ClassInfo() {
                }

                public static void write(ReferenceTypeImpl cls, VirtualMachineImpl vm, PacketStream answer) {
                    answer.writeByte(cls.tag());
                    answer.writeClassRef(cls.uniqueID());
                    answer.writeString(cls.signature());
                    answer.writeStringOrEmpty(cls.genericSignature());
                    answer.writeInt(cls.ref().getClassStatus());
                }
            }
        }

        static class SetDefaultStratum
        implements Command {
            static final int COMMAND = 19;

            SetDefaultStratum() {
            }

            @Override
            public void reply(VirtualMachineImpl vm, PacketStream answer, PacketStream command) {
                JDWP.notImplemented(answer);
            }
        }

        static class RedefineClasses
        implements Command {
            static final int COMMAND = 18;

            RedefineClasses() {
            }

            @Override
            public void reply(VirtualMachineImpl vm, PacketStream answer, PacketStream command) {
                JDWP.notImplemented(answer);
            }
        }

        static class CapabilitiesNew
        implements Command {
            static final int COMMAND = 17;

            CapabilitiesNew() {
            }

            @Override
            public void reply(VirtualMachineImpl vm, PacketStream answer, PacketStream command) {
                answer.writeBoolean(vm.vm.canWatchFieldModification());
                answer.writeBoolean(vm.vm.canWatchFieldAccess());
                answer.writeBoolean(vm.vm.canGetBytecodes());
                answer.writeBoolean(vm.vm.canGetSyntheticAttribute());
                answer.writeBoolean(vm.vm.canGetOwnedMonitorInfo());
                answer.writeBoolean(vm.vm.canGetCurrentContendedMonitor());
                answer.writeBoolean(vm.vm.canGetMonitorInfo());
                answer.writeBoolean(vm.vm.canRedefineClasses());
                answer.writeBoolean(vm.vm.canAddMethod());
                answer.writeBoolean(vm.vm.canUnrestrictedlyRedefineClasses());
                answer.writeBoolean(vm.vm.canPopFrames());
                answer.writeBoolean(vm.vm.canUseInstanceFilters());
                answer.writeBoolean(vm.vm.canGetSourceDebugExtension());
                answer.writeBoolean(vm.vm.canRequestVMDeathEvent());
                answer.writeBoolean(false);
                answer.writeBoolean(vm.vm.canGetInstanceInfo());
                answer.writeBoolean(vm.vm.canRequestMonitorEvents());
                answer.writeBoolean(vm.vm.canGetMonitorFrameInfo());
                answer.writeBoolean(vm.vm.canUseSourceNameFilters());
                answer.writeBoolean(vm.vm.canGetConstantPool());
                answer.writeBoolean(vm.vm.canForceEarlyReturn());
                answer.writeBoolean(false);
                answer.writeBoolean(false);
                answer.writeBoolean(false);
                answer.writeBoolean(false);
                answer.writeBoolean(false);
                answer.writeBoolean(false);
                answer.writeBoolean(false);
                answer.writeBoolean(false);
                answer.writeBoolean(false);
                answer.writeBoolean(false);
                answer.writeBoolean(false);
            }
        }

        static class ReleaseEvents
        implements Command {
            static final int COMMAND = 16;

            ReleaseEvents() {
            }

            @Override
            public void reply(VirtualMachineImpl vm, PacketStream answer, PacketStream command) {
            }
        }

        static class HoldEvents
        implements Command {
            static final int COMMAND = 15;

            HoldEvents() {
            }

            @Override
            public void reply(VirtualMachineImpl vm, PacketStream answer, PacketStream command) {
            }
        }

        static class DisposeObjects
        implements Command {
            static final int COMMAND = 14;

            DisposeObjects() {
            }

            @Override
            public void reply(VirtualMachineImpl vm, PacketStream answer, PacketStream command) {
            }
        }

        static class ClassPaths
        implements Command {
            static final int COMMAND = 13;

            ClassPaths() {
            }

            @Override
            public void reply(VirtualMachineImpl vm, PacketStream answer, PacketStream command) {
                answer.writeString(vm.vm.baseDirectory());
                List<String> classPath = vm.vm.classPath();
                answer.writeInt(classPath.size());
                for (String s : classPath) {
                    answer.writeString(s);
                }
                List<String> bootClassPath = vm.vm.bootClassPath();
                answer.writeInt(bootClassPath.size());
                for (String s : bootClassPath) {
                    answer.writeString(s);
                }
            }
        }

        static class Capabilities
        implements Command {
            static final int COMMAND = 12;

            Capabilities() {
            }

            @Override
            public void reply(VirtualMachineImpl vm, PacketStream answer, PacketStream command) {
                answer.writeBoolean(vm.vm.canWatchFieldModification());
                answer.writeBoolean(vm.vm.canWatchFieldAccess());
                answer.writeBoolean(vm.vm.canGetBytecodes());
                answer.writeBoolean(vm.vm.canGetSyntheticAttribute());
                answer.writeBoolean(vm.vm.canGetOwnedMonitorInfo());
                answer.writeBoolean(vm.vm.canGetCurrentContendedMonitor());
                answer.writeBoolean(vm.vm.canGetMonitorInfo());
            }
        }

        static class CreateString
        implements Command {
            static final int COMMAND = 11;

            CreateString() {
            }

            @Override
            public void reply(VirtualMachineImpl vm, PacketStream answer, PacketStream command) {
            }
        }

        static class Exit
        implements Command {
            static final int COMMAND = 10;

            Exit() {
            }

            @Override
            public void reply(VirtualMachineImpl vm, PacketStream answer, PacketStream command) {
            }
        }

        static class Resume
        implements Command {
            static final int COMMAND = 9;

            Resume() {
            }

            @Override
            public void reply(VirtualMachineImpl vm, PacketStream answer, PacketStream command) {
            }
        }

        static class Suspend
        implements Command {
            static final int COMMAND = 8;

            Suspend() {
            }

            @Override
            public void reply(VirtualMachineImpl vm, PacketStream answer, PacketStream command) {
            }
        }

        static class IDSizes
        implements Command {
            static final int COMMAND = 7;

            IDSizes() {
            }

            @Override
            public void reply(VirtualMachineImpl vm, PacketStream answer, PacketStream command) {
                answer.writeInt(vm.sizeofFieldRef);
                answer.writeInt(vm.sizeofMethodRef);
                answer.writeInt(vm.sizeofObjectRef);
                answer.writeInt(vm.sizeofClassRef);
                answer.writeInt(vm.sizeofFrameRef);
            }
        }

        static class Dispose
        implements Command {
            static final int COMMAND = 6;

            Dispose() {
            }

            @Override
            public void reply(VirtualMachineImpl vm, PacketStream answer, PacketStream command) {
                throw new VMDisconnectedException();
            }
        }

        static class TopLevelThreadGroups
        implements Command {
            static final int COMMAND = 5;

            TopLevelThreadGroups() {
            }

            @Override
            public void reply(VirtualMachineImpl vm, PacketStream answer, PacketStream command) {
                List<ThreadGroupReferenceImpl> list = vm.vm.topLevelThreadGroups();
                answer.writeInt(list.size());
                for (ThreadGroupReferenceImpl group : list) {
                    answer.writeObjectRef(group.uniqueID());
                }
            }
        }

        static class AllThreads
        implements Command {
            static final int COMMAND = 4;

            AllThreads() {
            }

            @Override
            public void reply(VirtualMachineImpl vm, PacketStream answer, PacketStream command) {
                List<ThreadReferenceImpl> allThreads = vm.vm.allThreads();
                answer.writeInt(allThreads.size());
                for (ThreadReferenceImpl thread : allThreads) {
                    answer.writeObjectRef(thread.uniqueID());
                }
            }
        }

        static class AllClasses
        implements Command {
            static final int COMMAND = 3;

            AllClasses() {
            }

            @Override
            public void reply(VirtualMachineImpl vm, PacketStream answer, PacketStream command) {
                List<ReferenceTypeImpl> referenceTypes = vm.vm.allClasses();
                answer.writeInt(referenceTypes.size());
                for (ReferenceTypeImpl referenceType : referenceTypes) {
                    ClassInfo.write(referenceType, vm, answer);
                }
            }

            static class ClassInfo {
                ClassInfo() {
                }

                public static void write(ReferenceTypeImpl referenceType, VirtualMachineImpl vm, PacketStream answer) {
                    answer.writeByte(referenceType.tag());
                    answer.writeClassRef(referenceType.uniqueID());
                    answer.writeString(referenceType.signature());
                    answer.writeInt(referenceType.ref().getClassStatus());
                }
            }
        }

        static class ClassesBySignature
        implements Command {
            static final int COMMAND = 2;

            ClassesBySignature() {
            }

            @Override
            public void reply(VirtualMachineImpl vm, PacketStream answer, PacketStream command) {
                String signature = command.readString();
                List<ReferenceTypeImpl> referenceTypes = vm.vm.findReferenceTypes(signature);
                answer.writeInt(referenceTypes.size());
                for (ReferenceTypeImpl referenceType : referenceTypes) {
                    ClassInfo.write(referenceType, vm, answer);
                }
            }

            static class ClassInfo {
                ClassInfo() {
                }

                public static void write(ReferenceTypeImpl referenceType, VirtualMachineImpl vm, PacketStream answer) {
                    answer.writeByte(referenceType.tag());
                    answer.writeClassRef(referenceType.uniqueID());
                    answer.writeInt(referenceType.ref().getClassStatus());
                }
            }
        }

        static class Version
        implements Command {
            static final int COMMAND = 1;

            Version() {
            }

            @Override
            public void reply(VirtualMachineImpl vm, PacketStream answer, PacketStream command) {
                answer.writeString(vm.vm.description());
                answer.writeInt(vm.vm.jdwpMajor());
                answer.writeInt(vm.vm.jdwpMinor());
                answer.writeString(vm.vm.version());
                answer.writeString(vm.vm.name());
            }
        }
    }
}

