/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.sa.jdi;

import com.jetbrains.sa.jdi.LocationImpl;
import com.jetbrains.sa.jdi.MethodImpl;

public class LocalVariableImpl
implements Comparable<LocalVariableImpl> {
    private final MethodImpl method;
    private final int slot;
    private final LocationImpl scopeStart;
    private final LocationImpl scopeEnd;
    private final String name;
    private final String signature;
    private final String genericSignature;

    LocalVariableImpl(MethodImpl method, int slot, LocationImpl scopeStart, LocationImpl scopeEnd, String name, String signature, String genericSignature) {
        this.method = method;
        this.slot = slot;
        this.scopeStart = scopeStart;
        this.scopeEnd = scopeEnd;
        this.name = name;
        this.signature = signature;
        this.genericSignature = genericSignature;
    }

    public boolean equals(Object obj) {
        if (obj instanceof LocalVariableImpl) {
            LocalVariableImpl other = (LocalVariableImpl)obj;
            return this.method.equals(other.method) && this.slot() == other.slot() && super.equals(obj);
        }
        return false;
    }

    public int hashCode() {
        return this.method.hashCode() + this.slot();
    }

    @Override
    public int compareTo(LocalVariableImpl localVar) {
        int rc = this.method.compareTo(localVar.method);
        if (rc == 0) {
            rc = this.slot() - localVar.slot();
        }
        return rc;
    }

    public String name() {
        return this.name;
    }

    public String signature() {
        return this.signature;
    }

    public String genericSignature() {
        return this.genericSignature;
    }

    public int slot() {
        return this.slot;
    }

    public String toString() {
        return this.name() + " in " + this.method.toString() + "@" + this.scopeStart.toString();
    }

    public long getStart() {
        return this.scopeStart.codeIndex();
    }

    public int getLength() {
        return (int)(this.scopeEnd.codeIndex() - this.scopeStart.codeIndex());
    }
}

