/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aether.artifact;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.eclipse.aether.artifact.AbstractArtifact;
import org.eclipse.aether.artifact.ArtifactType;

public final class DefaultArtifactType
implements ArtifactType {
    private final String id;
    private final String extension;
    private final String classifier;
    private final Map<String, String> properties;

    public DefaultArtifactType(String id) {
        this(id, id, "", "none", false, false);
    }

    public DefaultArtifactType(String id, String extension, String classifier2, String language) {
        this(id, extension, classifier2, language, true, false);
    }

    public DefaultArtifactType(String id, String extension, String classifier2, String language, boolean constitutesBuildPath, boolean includesDependencies) {
        this.id = Objects.requireNonNull(id, "type id cannot be null");
        if (id.length() == 0) {
            throw new IllegalArgumentException("type id cannot be empty");
        }
        this.extension = DefaultArtifactType.emptify(extension);
        this.classifier = DefaultArtifactType.emptify(classifier2);
        HashMap<String, String> props = new HashMap<String, String>();
        props.put("type", id);
        props.put("language", language != null && language.length() > 0 ? language : "none");
        props.put("includesDependencies", Boolean.toString(includesDependencies));
        props.put("constitutesBuildPath", Boolean.toString(constitutesBuildPath));
        this.properties = Collections.unmodifiableMap(props);
    }

    public DefaultArtifactType(String id, String extension, String classifier2, Map<String, String> properties2) {
        this.id = Objects.requireNonNull(id, "type id cannot be null");
        if (id.length() == 0) {
            throw new IllegalArgumentException("type id cannot be empty");
        }
        this.extension = DefaultArtifactType.emptify(extension);
        this.classifier = DefaultArtifactType.emptify(classifier2);
        this.properties = AbstractArtifact.copyProperties(properties2);
    }

    private static String emptify(String str) {
        return str == null ? "" : str;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public String getExtension() {
        return this.extension;
    }

    @Override
    public String getClassifier() {
        return this.classifier;
    }

    @Override
    public Map<String, String> getProperties() {
        return this.properties;
    }
}

