/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.text;

import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.text.StringUtilRt;
import com.intellij.openapi.util.text.Strings;
import com.intellij.util.text.CharSequenceSubSequence;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class SemVer
implements Comparable<SemVer> {
    private final String myRawVersion;
    private final int myMajor;
    private final int myMinor;
    private final int myPatch;
    @Nullable
    private final String myPreRelease;

    public SemVer(@NotNull String rawVersion, int major, int minor, int patch) {
        if (rawVersion == null) {
            SemVer.$$$reportNull$$$0(0);
        }
        this(rawVersion, major, minor, patch, null);
    }

    public SemVer(@NotNull String rawVersion, int major, int minor, int patch, @Nullable String preRelease) {
        if (rawVersion == null) {
            SemVer.$$$reportNull$$$0(1);
        }
        this.myRawVersion = rawVersion;
        this.myMajor = major;
        this.myMinor = minor;
        this.myPatch = patch;
        this.myPreRelease = preRelease;
    }

    @NotNull
    @NlsSafe
    public String getRawVersion() {
        String string2 = this.myRawVersion;
        if (string2 == null) {
            SemVer.$$$reportNull$$$0(2);
        }
        return string2;
    }

    public int getMajor() {
        return this.myMajor;
    }

    public int getMinor() {
        return this.myMinor;
    }

    public int getPatch() {
        return this.myPatch;
    }

    @Nullable
    @NlsSafe
    public String getPreRelease() {
        return this.myPreRelease;
    }

    @NotNull
    @NlsSafe
    public String getParsedVersion() {
        String string2 = this.myMajor + "." + this.myMinor + "." + this.myPatch + (this.myPreRelease != null ? "-" + this.myPreRelease : "");
        if (string2 == null) {
            SemVer.$$$reportNull$$$0(3);
        }
        return string2;
    }

    @Override
    public int compareTo(SemVer other) {
        int diff = this.myMajor - other.myMajor;
        if (diff != 0) {
            return diff;
        }
        diff = this.myMinor - other.myMinor;
        if (diff != 0) {
            return diff;
        }
        diff = this.myPatch - other.myPatch;
        if (diff != 0) {
            return diff;
        }
        return SemVer.comparePrerelease(this.myPreRelease, other.myPreRelease);
    }

    public boolean isGreaterOrEqualThan(int major, int minor, int patch) {
        if (this.myMajor != major) {
            return this.myMajor > major;
        }
        if (this.myMinor != minor) {
            return this.myMinor > minor;
        }
        return this.myPatch >= patch;
    }

    public boolean isGreaterOrEqualThan(@NotNull SemVer version) {
        if (version == null) {
            SemVer.$$$reportNull$$$0(4);
        }
        return this.compareTo(version) >= 0;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SemVer semVer = (SemVer)o;
        return this.myMajor == semVer.myMajor && this.myMinor == semVer.myMinor && this.myPatch == semVer.myPatch && Objects.equals(this.myPreRelease, semVer.myPreRelease);
    }

    public int hashCode() {
        int result2 = this.myMajor;
        result2 = 31 * result2 + this.myMinor;
        result2 = 31 * result2 + this.myPatch;
        if (this.myPreRelease != null) {
            result2 = 31 * result2 + this.myPreRelease.hashCode();
        }
        return result2;
    }

    public String toString() {
        return this.myRawVersion;
    }

    private static int comparePrerelease(@Nullable String pre1, @Nullable String pre2) {
        int diff;
        int length2;
        if (pre1 == null) {
            return pre2 == null ? 0 : 1;
        }
        if (pre2 == null) {
            return -1;
        }
        int length1 = pre1.length();
        if (length1 == (length2 = pre2.length()) && pre1.equals(pre2)) {
            return 0;
        }
        int start1 = 0;
        int start2 = 0;
        do {
            int end1 = pre1.indexOf(46, start1);
            int end2 = pre2.indexOf(46, start2);
            if (end1 < 0) {
                end1 = length1;
            }
            if (end2 < 0) {
                end2 = length2;
            }
            CharSequenceSubSequence segment1 = new CharSequenceSubSequence(pre1, start1, end1);
            CharSequenceSubSequence segment2 = new CharSequenceSubSequence(pre2, start2, end2);
            if (Strings.isNotNegativeNumber(segment1)) {
                if (!Strings.isNotNegativeNumber(segment2)) {
                    return -1;
                }
                diff = SemVer.compareNumeric(segment1, segment2);
            } else {
                if (Strings.isNotNegativeNumber(segment2)) {
                    return 1;
                }
                diff = Strings.compare(segment1, segment2, false);
            }
            start1 = end1 + 1;
            start2 = end2 + 1;
        } while (diff == 0 && start1 < length1 && start2 < length2);
        if (diff != 0) {
            return diff;
        }
        return start1 < length1 ? 1 : -1;
    }

    private static int compareNumeric(CharSequence segment1, CharSequence segment2) {
        int length1 = segment1.length();
        int length2 = segment2.length();
        int diff = Integer.compare(length1, length2);
        for (int i = 0; i < length1 && diff == 0; ++i) {
            diff = segment1.charAt(i) - segment2.charAt(i);
        }
        return diff;
    }

    @Nullable
    public static SemVer parseFromText(@Nullable String text) {
        int minorEndIdx;
        int majorEndIdx;
        if (text != null && (majorEndIdx = text.indexOf(46)) >= 0 && (minorEndIdx = text.indexOf(46, majorEndIdx + 1)) >= 0) {
            String preRelease;
            int preReleaseIdx = text.indexOf(45, minorEndIdx + 1);
            int patchEndIdx = preReleaseIdx >= 0 ? preReleaseIdx : text.length();
            int major = StringUtilRt.parseInt((String)text.substring(0, majorEndIdx), (int)-1);
            int minor = StringUtilRt.parseInt((String)text.substring(majorEndIdx + 1, minorEndIdx), (int)-1);
            int patch = StringUtilRt.parseInt((String)text.substring(minorEndIdx + 1, patchEndIdx), (int)-1);
            String string2 = preRelease = preReleaseIdx >= 0 ? text.substring(preReleaseIdx + 1) : null;
            if (major >= 0 && minor >= 0 && patch >= 0) {
                return new SemVer(text, major, minor, patch, preRelease);
            }
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rawVersion";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/util/text/SemVer";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "version";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/util/text/SemVer";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getRawVersion";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getParsedVersion";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "isGreaterOrEqualThan";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 2: 
            case 3: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }
}

