/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.io.pagecache.impl;

import com.intellij.util.io.ByteBufferUtil;
import com.intellij.util.io.IOUtil;
import com.intellij.util.io.pagecache.Page;
import com.intellij.util.io.pagecache.PageUnsafe;
import com.intellij.util.io.pagecache.impl.PageContentLoader;
import com.intellij.util.io.pagecache.impl.PageToStorageHandle;
import java.io.Flushable;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@ApiStatus.Internal
public abstract class PageImpl
implements Page,
Flushable,
PageUnsafe {
    public static final int STATE_NOT_READY_YET = 0;
    public static final int STATE_LOADING = 1;
    public static final int STATE_USABLE = 2;
    public static final int STATE_ABOUT_TO_UNMAP = 3;
    public static final int STATE_PRE_TOMBSTONE = 4;
    public static final int STATE_TOMBSTONE = 5;
    private static final AtomicIntegerFieldUpdater<PageImpl> STATE_UPDATER = AtomicIntegerFieldUpdater.newUpdater(PageImpl.class, "statePacked");
    private static final AtomicIntegerFieldUpdater<PageImpl> TOKENS_UPDATER = AtomicIntegerFieldUpdater.newUpdater(PageImpl.class, "tokensOfUsefulness");
    private static final int USAGE_COUNT_MASK = 0xFFFFFF;
    private final int pageSize;
    private final int pageIndex;
    private final transient long offsetInFile;
    private volatile int statePacked;
    private volatile Object auxDebugData;
    protected ByteBuffer data;
    @NotNull
    protected final PageToStorageHandle storageHandle;
    private volatile int tokensOfUsefulness;
    private int tokensOfUsefulnessLocal;

    /*
     * WARNING - void declaration
     */
    private PageImpl(long offsetInFile, int pageIndex, int pageSize, @NotNull PageToStorageHandle pageToStorageHandle) {
        void storageHandle;
        if (pageToStorageHandle == null) {
            PageImpl.$$$reportNull$$$0(0);
        }
        this.statePacked = PageImpl.packState(0, 0);
        this.auxDebugData = null;
        this.data = null;
        this.tokensOfUsefulness = 16;
        this.tokensOfUsefulnessLocal = 0;
        if (offsetInFile < 0L) {
            throw new IllegalArgumentException("offsetInFile(=" + offsetInFile + ") must be >=0");
        }
        if (pageIndex < 0) {
            throw new IllegalArgumentException("pageIndex(=" + pageIndex + ") must be >=0");
        }
        if (pageSize <= 0) {
            throw new IllegalArgumentException("pageSize(=" + pageSize + ") must be >0");
        }
        this.offsetInFile = offsetInFile;
        this.pageIndex = pageIndex;
        this.pageSize = pageSize;
        this.storageHandle = storageHandle;
    }

    protected PageImpl(int pageIndex, int pageSize, @NotNull PageToStorageHandle storageHandle) {
        if (storageHandle == null) {
            PageImpl.$$$reportNull$$$0(1);
        }
        this((long)pageIndex * (long)pageSize, pageIndex, pageSize, storageHandle);
    }

    @Override
    public int pageSize() {
        return this.pageSize;
    }

    @Override
    public int pageIndex() {
        return this.pageIndex;
    }

    @Override
    public long offsetInFile() {
        return this.offsetInFile;
    }

    @Override
    public long lastOffsetInFile() {
        return ((long)this.pageIndex + 1L) * (long)this.pageSize - 1L;
    }

    public boolean isNotReadyYet() {
        return this.inState(0);
    }

    public boolean isLoading() {
        return this.inState(1);
    }

    @Override
    public boolean isUsable() {
        return this.inState(2);
    }

    public boolean isAboutToUnmap() {
        return this.inState(3);
    }

    public boolean isPreTombstone() {
        return this.inState(4);
    }

    public boolean isTombstone() {
        return this.inState(5);
    }

    public boolean inState(int expectedState) {
        return PageImpl.unpackState(this.statePacked) == expectedState;
    }

    protected int state() {
        return PageImpl.unpackState(this.statePacked);
    }

    public int usageCount() {
        return PageImpl.unpackUsageCount(this.statePacked);
    }

    public boolean tryPrepareForUse(@NotNull PageContentLoader contentLoader) throws IOException {
        int packedState;
        int state;
        if (contentLoader == null) {
            PageImpl.$$$reportNull$$$0(2);
        }
        if ((state = PageImpl.unpackState(packedState = this.statePacked)) == 0) {
            int usageCount = PageImpl.unpackUsageCount(packedState);
            if (usageCount != 0) {
                throw new AssertionError((Object)("Bug: usageCount(=" + usageCount + ") must be 0 in NOT_READ_YET: " + this));
            }
            int newPackedState = PageImpl.packState(1, 0);
            if (STATE_UPDATER.compareAndSet(this, packedState, newPackedState)) {
                this.auxDebugData = Thread.currentThread();
                try {
                    this.data = contentLoader.loadPageContent(this);
                    this.statePacked = PageImpl.packState(2, 0);
                    return true;
                }
                catch (Throwable e) {
                    this.statePacked = PageImpl.packState(0, 0);
                    this.auxDebugData = e;
                    throw e;
                }
            }
        }
        return false;
    }

    public boolean tryAcquireForUse(Object acquirer) throws IOException {
        int newUsageCount;
        int state;
        int newPackedState;
        int packedState;
        do {
            packedState = this.statePacked;
            state = PageImpl.unpackState(packedState);
            int usageCount = PageImpl.unpackUsageCount(packedState);
            if (state < 2) {
                return false;
            }
            if (state > 3) {
                throw new IOException("Page.state[=" + state + "] != USABLE");
            }
            if (state == 3) {
                throw new IOException("Page.state[=" + state + "] != USABLE");
            }
            newUsageCount = usageCount + 1;
            if (newUsageCount > 0xFFFFFF) {
                throw new AssertionError((Object)("Too many usages: " + newUsageCount + " (max: " + 0xFFFFFF + ") -- likely .release() call is missed"));
            }
        } while (!STATE_UPDATER.compareAndSet(this, packedState, newPackedState = PageImpl.packState(state, newUsageCount)));
        return true;
    }

    @Override
    public boolean tryAcquire(Object acquirer) {
        try {
            if (this.tryAcquireForUse(acquirer)) {
                return true;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return false;
    }

    @Override
    public void release() {
        int usageCount;
        int newUsageCount;
        int state;
        int newPackedState;
        int packedState;
        do {
            packedState = this.statePacked;
            state = PageImpl.unpackState(packedState);
            usageCount = PageImpl.unpackUsageCount(packedState);
            if (state != 2 && state != 3) {
                throw new AssertionError((Object)("Bug: .release() must be called on {USABLE|ABOUT_TO_UNMAP} page only, but .state[=" + state + "]"));
            }
            if (usageCount == 0) {
                throw new AssertionError((Object)"Bug: can't .release() page with usageCount=0 -- unpaired .acquire()/.release() calls?");
            }
        } while (!STATE_UPDATER.compareAndSet(this, packedState, newPackedState = PageImpl.packState(state, newUsageCount = usageCount - 1)));
        this.addTokensOfUsefulness(8 * usageCount);
    }

    public boolean tryMoveTowardsPreTombstone(boolean entombYoung) {
        int state;
        block8: while (true) {
            int packedState = this.statePacked;
            state = PageImpl.unpackState(packedState);
            int usageCount = PageImpl.unpackUsageCount(packedState);
            switch (state) {
                case 0: {
                    int newPackedState;
                    return entombYoung && STATE_UPDATER.compareAndSet(this, packedState, newPackedState = PageImpl.packState(4, 0));
                }
                case 1: {
                    return false;
                }
                case 2: {
                    int newPackedState;
                    if (usageCount <= 0) continue block8;
                    return false;
                    if (STATE_UPDATER.compareAndSet(this, packedState, newPackedState = PageImpl.packState(3, 0))) continue block8;
                    return false;
                }
                case 3: {
                    if (usageCount > 0) {
                        throw new AssertionError((Object)("Page[ABOUT_TO_UNMAP].usageCount=" + usageCount + " -- must be 0. " + this));
                    }
                    int newPackedState = PageImpl.packState(4, 0);
                    if (STATE_UPDATER.compareAndSet(this, packedState, newPackedState)) {
                        return true;
                    }
                }
                case 4: {
                    return false;
                }
                case 5: {
                    return false;
                }
            }
            break;
        }
        throw new AssertionError((Object)("Code bug: unknown state " + state + ": " + this));
    }

    public void entomb() {
        if (this.isDirty()) {
            throw new AssertionError((Object)("Bug: page must be !dirty to be TOMBSTONE-ed, but: " + this));
        }
        int packedState = this.statePacked;
        int state = PageImpl.unpackState(packedState);
        int usageCount = PageImpl.unpackUsageCount(packedState);
        if (usageCount > 0) {
            throw new AssertionError((Object)("Bug: page.usageCount(=" + usageCount + ") must be 0. page: " + this));
        }
        if (state != 4) {
            throw new AssertionError((Object)("Bug: page.state(=" + state + ") be PRE_TOMBSTONE. " + this));
        }
        int newPackedState = PageImpl.packState(5, 0);
        if (!STATE_UPDATER.compareAndSet(this, packedState, newPackedState)) {
            throw new AssertionError((Object)("Bug: somebody interferes with PRE_TOMBSTONE->TOMBSTONE transition. " + this));
        }
    }

    public ByteBuffer detachTombstoneBuffer() {
        if (!this.isPreTombstone()) {
            throw new AssertionError((Object)("Bug: only PRE_TOMBSTONES could detach buffer. " + this));
        }
        ByteBuffer buffer = this.data;
        if (buffer == null) {
            throw new AssertionError((Object)("Bug: buffer already detached, .data is null. " + this));
        }
        this.data = null;
        return buffer;
    }

    private static int packState(int state, int newUsageCount) {
        return state << 24 | newUsageCount;
    }

    private static int unpackUsageCount(int packedState) {
        return packedState & 0xFFFFFF;
    }

    private static int unpackState(int packedState) {
        return packedState >> 24;
    }

    public abstract boolean isDirty();

    @Override
    public abstract void flush() throws IOException;

    public abstract boolean tryFlush() throws IOException;

    @Override
    public void close() {
        this.release();
    }

    public int addTokensOfUsefulness(int tokensToAdd) {
        int newTokens;
        int tokens;
        assert (tokensToAdd >= 0) : "tokensToAdd(" + tokensToAdd + ") must be >=0";
        do {
            if ((newTokens = (tokens = this.tokensOfUsefulness) + tokensToAdd) >= 0) continue;
            newTokens = Integer.MAX_VALUE;
        } while (!TOKENS_UPDATER.compareAndSet(this, tokens, newTokens));
        return newTokens;
    }

    public int decayTokensOfUsefulness(int numerator, int denominator) {
        int decayedTokens;
        int tokens;
        assert (numerator >= 0) : "numerator(" + numerator + ") must be >=0";
        assert (denominator > 0) : "denominator(" + denominator + ") must be >0";
        while (!TOKENS_UPDATER.compareAndSet(this, tokens = this.tokensOfUsefulness, decayedTokens = tokens * numerator / denominator)) {
        }
        return decayedTokens;
    }

    public int tokensOfUsefulness() {
        return this.tokensOfUsefulness;
    }

    public int localTokensOfUsefulness() {
        return this.tokensOfUsefulnessLocal;
    }

    public void updateLocalTokensOfUsefulness(int tokensOfUsefulness) {
        this.tokensOfUsefulnessLocal = tokensOfUsefulness;
    }

    @Override
    public byte get(int offsetInPage) {
        this.lockPageForRead();
        try {
            this.checkPageIsValidForAccess();
            byte by = this.data.get(offsetInPage);
            return by;
        }
        finally {
            this.unlockPageForRead();
        }
    }

    @Override
    public int getInt(int offsetInPage) {
        this.lockPageForRead();
        try {
            this.checkPageIsValidForAccess();
            int n = this.data.getInt(offsetInPage);
            return n;
        }
        finally {
            this.unlockPageForRead();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getLong(int offsetInPage) {
        this.lockPageForRead();
        try {
            this.checkPageIsValidForAccess();
            long l = this.data.getLong(offsetInPage);
            return l;
        }
        finally {
            this.unlockPageForRead();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void readToArray(byte[] destination, int offsetInArray, int offsetInPage, int length) {
        this.lockPageForRead();
        try {
            this.checkPageIsValidForAccess();
            ByteBufferUtil.copyMemory(this.data, offsetInPage, destination, offsetInArray, length);
        }
        finally {
            this.unlockPageForRead();
        }
    }

    @Override
    public void put(int offsetInPage, byte value) {
        this.lockPageForWrite();
        try {
            this.checkPageIsValidForAccess();
            this.data.put(offsetInPage, value);
            this.regionModified(offsetInPage, 1);
        }
        finally {
            this.unlockPageForWrite();
        }
    }

    @Override
    public void putInt(int offsetInPage, int value) {
        this.lockPageForWrite();
        try {
            this.checkPageIsValidForAccess();
            this.data.putInt(offsetInPage, value);
            this.regionModified(offsetInPage, 4);
        }
        finally {
            this.unlockPageForWrite();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void putLong(int offsetInPage, long value) {
        this.lockPageForWrite();
        try {
            this.checkPageIsValidForAccess();
            this.data.putLong(offsetInPage, value);
            this.regionModified(offsetInPage, 8);
        }
        finally {
            this.unlockPageForWrite();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void putFromBuffer(ByteBuffer data2, int offsetInPage) {
        this.lockPageForWrite();
        try {
            this.checkPageIsValidForAccess();
            int length = data2.remaining();
            ByteBuffer slice = this.data.duplicate().order(data2.order());
            slice.position(offsetInPage);
            slice.put(data2);
            this.regionModified(offsetInPage, length);
        }
        finally {
            this.unlockPageForWrite();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void putFromArray(byte[] source, int offsetInArray, int offsetInPage, int length) {
        this.lockPageForWrite();
        try {
            this.checkPageIsValidForAccess();
            ByteBuffer buf = this.data.duplicate().order(this.data.order());
            buf.position(offsetInPage);
            buf.put(source, offsetInArray, length);
            this.regionModified(offsetInPage, length);
        }
        finally {
            this.unlockPageForWrite();
        }
    }

    @Override
    public ByteBuffer rawPageBuffer() {
        this.checkPageIsValidForAccess();
        return this.pageBufferUnchecked();
    }

    public ByteBuffer pageBufferUnchecked() {
        return this.data;
    }

    @Override
    @ApiStatus.Obsolete
    public ByteBuffer duplicate() {
        this.checkPageIsValidForAccess();
        return this.data.duplicate().order(this.data.order());
    }

    protected void checkPageIsValidForAccess() {
        if (!this.isUsable() && !this.isAboutToUnmap()) {
            throw new IllegalStateException("Page state must be in { USABLE | ABOUT_TO_UNMAP } for accessing, but: " + this);
        }
        if (this.usageCount() == 0) {
            throw new IllegalStateException("Page must be acquired for use (i.e. usageCount>0) before accessing, but: " + this);
        }
    }

    public String toString() {
        int packedState = this.statePacked;
        return "Page[#" + this.pageIndex + ", size: " + this.pageSize + "b, offsetInFile: " + this.offsetInFile + "b]{state: " + PageImpl.unpackState(packedState) + ", inUse: " + PageImpl.unpackUsageCount(packedState) + "}" + (this.auxDebugData != null ? ", aux: " + this.auxDebugData : "");
    }

    @Override
    public String formatData() {
        ByteBuffer _data = this.data;
        if (_data != null) {
            return IOUtil.toHexString(_data);
        }
        return "null";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "storageHandle";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "contentLoader";
                break;
            }
        }
        objectArray2[1] = "com/intellij/util/io/pagecache/impl/PageImpl";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "tryPrepareForUse";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

