/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.indexing.impl;

import com.intellij.util.SmartList;
import com.intellij.util.indexing.impl.ValueContainerImpl;
import it.unimi.dsi.fastutil.Pair;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import org.jetbrains.annotations.NotNull;

final class FileId2ValueMapping<Value> {
    @NotNull
    private final Int2ObjectMap<Value> id2ValueMap;
    @NotNull
    private final ValueContainerImpl<Value> valueContainer;

    FileId2ValueMapping(@NotNull ValueContainerImpl<Value> valueContainer) {
        if (valueContainer == null) {
            FileId2ValueMapping.$$$reportNull$$$0(0);
        }
        this.id2ValueMap = new Int2ObjectOpenHashMap<Value>();
        this.valueContainer = valueContainer;
        SmartList cleanupDeletions = new SmartList();
        valueContainer.forEach((id, value) -> {
            Object previousValue = this.associateFileIdToValueSkippingContainer(id, value);
            if (previousValue != null) {
                cleanupDeletions.add(Pair.of(previousValue, id));
            }
            return true;
        });
        for (Pair deletion : cleanupDeletions) {
            valueContainer.removeValue((Integer)deletion.second(), ValueContainerImpl.unwrap(deletion.first()));
        }
    }

    void associateFileIdToValue(int fileId, Value value) {
        Value previousValue = this.associateFileIdToValueSkippingContainer(fileId, value);
        if (previousValue != null) {
            this.valueContainer.removeValue(fileId, ValueContainerImpl.unwrap(previousValue));
        }
        this.valueContainer.addValue(fileId, value);
    }

    Value associateFileIdToValueSkippingContainer(int fileId, Value value) {
        return this.id2ValueMap.put(fileId, ValueContainerImpl.wrapValue(value));
    }

    boolean removeFileId(int inputId) {
        Object mapped = this.id2ValueMap.remove(inputId);
        if (mapped != null) {
            this.valueContainer.removeValue(inputId, ValueContainerImpl.unwrap(mapped));
        }
        return mapped != null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "valueContainer", "com/intellij/util/indexing/impl/FileId2ValueMapping", "<init>"));
    }
}

