/*
 * Decompiled with CFR 0.152.
 */
package training.learn.js;

import com.intellij.openapi.editor.CaretModel;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.ui.components.fields.ExtendableTextField;
import java.awt.Component;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import training.dsl.TaskRuntimeContext;
import training.util.UtilsKt;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000$\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0007\u001a\u0006\u0010\u0000\u001a\u00020\u0001\u001a\u0012\u0010\u0002\u001a\u00020\u0003*\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0001\u001a\f\u0010\u0006\u001a\u0004\u0018\u00010\u0007*\u00020\u0004\u001a\f\u0010\b\u001a\u0004\u0018\u00010\u0001*\u00020\u0004\u001a\u001a\u0010\t\u001a\u00020\u0003*\u00020\u00042\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u0001\u001a\u0012\u0010\r\u001a\u00020\u0003*\u00020\u00042\u0006\u0010\f\u001a\u00020\u0001\u001a\u0012\u0010\u000e\u001a\u00020\u0003*\u00020\u00042\u0006\u0010\f\u001a\u00020\u0001\u001a\u001a\u0010\u000f\u001a\u00020\u0003*\u00020\u00042\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u0001\u001a\u001a\u0010\u0010\u001a\u00020\u0003*\u00020\u00042\u0006\u0010\u0011\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u0001\u00a8\u0006\u0012"}, d2={"shiftSymbol", "", "checkWordInSearchEverywhereInput", "", "Ltraining/dsl/TaskRuntimeContext;", "expected", "findElementAtCaret", "Lcom/intellij/psi/PsiElement;", "findTextAtCaret", "textAfterOffset", "offset", "", "text", "textAtCaretEqualsTo", "textBeforeCaret", "textBeforeOffset", "textOnLine", "line", "intellij.featuresTrainer"})
public final class JSCommonLessonUtilsKt {
    public static final boolean textBeforeCaret(@NotNull TaskRuntimeContext $this$textBeforeCaret, @NotNull String text2) {
        Intrinsics.checkNotNullParameter((Object)$this$textBeforeCaret, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)text2, (String)"text");
        int offset = $this$textBeforeCaret.getEditor().getCaretModel().getOffset();
        return JSCommonLessonUtilsKt.textBeforeOffset($this$textBeforeCaret, offset, text2);
    }

    public static final boolean textBeforeOffset(@NotNull TaskRuntimeContext $this$textBeforeOffset, int offset, @NotNull String text2) {
        Intrinsics.checkNotNullParameter((Object)$this$textBeforeOffset, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)text2, (String)"text");
        if (offset < text2.length()) {
            return false;
        }
        CharSequence subSequence = $this$textBeforeOffset.getEditor().getDocument().getCharsSequence().subSequence(offset - text2.length(), offset);
        return Intrinsics.areEqual((Object)((Object)subSequence).toString(), (Object)text2);
    }

    public static final boolean textAfterOffset(@NotNull TaskRuntimeContext $this$textAfterOffset, int offset, @NotNull String text2) {
        Intrinsics.checkNotNullParameter((Object)$this$textAfterOffset, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)text2, (String)"text");
        CharSequence charSequence = $this$textAfterOffset.getEditor().getDocument().getCharsSequence();
        Intrinsics.checkNotNullExpressionValue((Object)charSequence, (String)"getCharsSequence(...)");
        CharSequence charsSequence = charSequence;
        if (offset + text2.length() > charsSequence.length()) {
            return false;
        }
        CharSequence subSequence = charsSequence.subSequence(offset, offset + text2.length());
        return Intrinsics.areEqual((Object)((Object)subSequence).toString(), (Object)text2);
    }

    public static final boolean textOnLine(@NotNull TaskRuntimeContext $this$textOnLine, int line, @NotNull String text2) {
        Intrinsics.checkNotNullParameter((Object)$this$textOnLine, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)text2, (String)"text");
        int lineStartOffset = $this$textOnLine.getEditor().getDocument().getLineStartOffset(line);
        int lineEndOffset = $this$textOnLine.getEditor().getDocument().getLineEndOffset(line);
        CharSequence subSequence = $this$textOnLine.getEditor().getDocument().getCharsSequence().subSequence(lineStartOffset, lineEndOffset);
        return UtilsKt.isToStringContains(subSequence, text2);
    }

    @Nullable
    public static final PsiElement findElementAtCaret(@NotNull TaskRuntimeContext $this$findElementAtCaret) {
        Intrinsics.checkNotNullParameter((Object)$this$findElementAtCaret, (String)"<this>");
        CaretModel caretModel = $this$findElementAtCaret.getEditor().getCaretModel();
        Intrinsics.checkNotNullExpressionValue((Object)caretModel, (String)"getCaretModel(...)");
        CaretModel caret2 = caretModel;
        PsiFile psiFile2 = PsiDocumentManager.getInstance((Project)$this$findElementAtCaret.getProject()).getPsiFile($this$findElementAtCaret.getEditor().getDocument());
        Intrinsics.checkNotNull((Object)psiFile2);
        PsiFile psiFile3 = psiFile2;
        int offset = caret2.getOffset();
        return psiFile3.findElementAt(offset);
    }

    @Nullable
    public static final String findTextAtCaret(@NotNull TaskRuntimeContext $this$findTextAtCaret) {
        PsiElement element;
        Intrinsics.checkNotNullParameter((Object)$this$findTextAtCaret, (String)"<this>");
        PsiElement psiElement = element = JSCommonLessonUtilsKt.findElementAtCaret($this$findTextAtCaret);
        return psiElement != null ? psiElement.getText() : null;
    }

    public static final boolean textAtCaretEqualsTo(@NotNull TaskRuntimeContext $this$textAtCaretEqualsTo, @NotNull String text2) {
        Intrinsics.checkNotNullParameter((Object)$this$textAtCaretEqualsTo, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)text2, (String)"text");
        String foundText = JSCommonLessonUtilsKt.findTextAtCaret($this$textAtCaretEqualsTo);
        return Intrinsics.areEqual((Object)text2, (Object)foundText) || Intrinsics.areEqual((Object)text2, (Object)"(");
    }

    @NotNull
    public static final String shiftSymbol() {
        if (SystemInfo.isMac) {
            return "\u21e7";
        }
        return "Shift";
    }

    public static final boolean checkWordInSearchEverywhereInput(@NotNull TaskRuntimeContext $this$checkWordInSearchEverywhereInput, @NotNull String expected) {
        String string;
        Intrinsics.checkNotNullParameter((Object)$this$checkWordInSearchEverywhereInput, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)expected, (String)"expected");
        Component component2 = $this$checkWordInSearchEverywhereInput.getFocusOwner();
        Object object = component2 instanceof ExtendableTextField ? (ExtendableTextField)component2 : null;
        if (object != null && (object = object.getText()) != null) {
            Object object2 = object;
            Locale locale = Locale.ENGLISH;
            Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"ENGLISH");
            String string2 = ((String)object2).toLowerCase(locale);
            string = string2;
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toLowerCase(...)");
        } else {
            string = null;
        }
        String string3 = expected;
        Locale locale = Locale.ENGLISH;
        Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"ENGLISH");
        String string4 = string3.toLowerCase(locale);
        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"toLowerCase(...)");
        return UtilsKt.isToStringContains(string, string4);
    }
}

