/*
 * Decompiled with CFR 0.152.
 */
package training.featuresSuggester.ui;

import com.intellij.ide.BrowserUtil;
import com.intellij.ide.util.TipAndTrickBean;
import com.intellij.ide.util.TipAndTrickManager;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationGroup;
import com.intellij.notification.NotificationGroupManager;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.application.ApplicationNamesInfo;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.project.Project;
import com.intellij.util.Alarm;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import training.featuresSuggester.DocumentationSuggestion;
import training.featuresSuggester.FeatureSuggesterBundle;
import training.featuresSuggester.PopupSuggestion;
import training.featuresSuggester.TipSuggestion;
import training.featuresSuggester.settings.FeatureSuggesterSettings;
import training.featuresSuggester.statistics.FeatureSuggesterStatistics;
import training.featuresSuggester.ui.SuggestionPresenter;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0002J\u0018\u0010\u000b\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\fH\u0002J\"\u0010\r\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u0010H\u0002J \u0010\u0011\u001a\u00020\u00122\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0013\u001a\u00020\u0014H\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Ltraining/featuresSuggester/ui/NotificationSuggestionPresenter;", "Ltraining/featuresSuggester/ui/SuggestionPresenter;", "()V", "notificationGroup", "Lcom/intellij/notification/NotificationGroup;", "createDontSuggestAction", "Lcom/intellij/openapi/actionSystem/AnAction;", "notification", "Lcom/intellij/notification/Notification;", "suggestion", "Ltraining/featuresSuggester/PopupSuggestion;", "createGoToDocumentationAction", "Ltraining/featuresSuggester/DocumentationSuggestion;", "createShowTipAction", "project", "Lcom/intellij/openapi/project/Project;", "Ltraining/featuresSuggester/TipSuggestion;", "showSuggestion", "", "disposable", "Lcom/intellij/openapi/Disposable;", "intellij.featuresTrainer"})
public final class NotificationSuggestionPresenter
implements SuggestionPresenter {
    @NotNull
    private final NotificationGroup notificationGroup;

    public NotificationSuggestionPresenter() {
        NotificationGroup notificationGroup = NotificationGroupManager.getInstance().getNotificationGroup("IDE Feature Suggester");
        Intrinsics.checkNotNullExpressionValue((Object)notificationGroup, (String)"getNotificationGroup(...)");
        this.notificationGroup = notificationGroup;
    }

    @Override
    public void showSuggestion(@NotNull Project project, @NotNull PopupSuggestion suggestion, @NotNull Disposable disposable) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)suggestion, (String)"suggestion");
        Intrinsics.checkNotNullParameter((Object)disposable, (String)"disposable");
        Notification notification2 = this.notificationGroup.createNotification(FeatureSuggesterBundle.INSTANCE.message("notification.title", new Object[0]), suggestion.getMessage(), NotificationType.INFORMATION);
        PopupSuggestion popupSuggestion = suggestion;
        if (popupSuggestion instanceof TipSuggestion) {
            AnAction action2 = this.createShowTipAction(project, notification2, (TipSuggestion)suggestion);
            if (action2 != null) {
                notification2.addAction(action2);
            }
        } else if (popupSuggestion instanceof DocumentationSuggestion) {
            notification2.addAction(this.createGoToDocumentationAction(notification2, (DocumentationSuggestion)suggestion));
        }
        notification2.addAction(this.createDontSuggestAction(notification2, suggestion));
        notification2.notify(project);
        new Alarm(disposable).addRequest(() -> ((Notification)notification2).expire(), 10000, ModalityState.any());
        FeatureSuggesterStatistics.INSTANCE.logNotificationShowed(suggestion.getSuggesterId());
    }

    private final AnAction createDontSuggestAction(Notification notification2, PopupSuggestion suggestion) {
        String string = FeatureSuggesterBundle.INSTANCE.message("notification.dont.suggest", new Object[0]);
        return new AnAction(suggestion, notification2, string){
            final /* synthetic */ PopupSuggestion $suggestion;
            final /* synthetic */ Notification $notification;
            {
                this.$suggestion = $suggestion;
                this.$notification = $notification;
                super($super_call_param$1);
            }

            public void actionPerformed(@NotNull AnActionEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                FeatureSuggesterSettings settings = FeatureSuggesterSettings.Companion.instance();
                settings.setEnabled(this.$suggestion.getSuggesterId(), false);
                this.$notification.hideBalloon();
                FeatureSuggesterStatistics.INSTANCE.logNotificationDontSuggest(this.$suggestion.getSuggesterId());
            }
        };
    }

    private final AnAction createGoToDocumentationAction(Notification notification2, DocumentationSuggestion suggestion) {
        Object[] objectArray = new Object[1];
        Intrinsics.checkNotNullExpressionValue((Object)ApplicationNamesInfo.getInstance().getProductName(), (String)"getProductName(...)");
        String string = FeatureSuggesterBundle.INSTANCE.message("notification.open.help", objectArray);
        return new AnAction(suggestion, notification2, string){
            final /* synthetic */ DocumentationSuggestion $suggestion;
            final /* synthetic */ Notification $notification;
            {
                this.$suggestion = $suggestion;
                this.$notification = $notification;
                super($super_call_param$1);
            }

            public void actionPerformed(@NotNull AnActionEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                BrowserUtil.open((String)this.$suggestion.getDocumentURL());
                this.$notification.hideBalloon();
                FeatureSuggesterStatistics.INSTANCE.logNotificationLearnMore(this.$suggestion.getSuggesterId());
            }
        };
    }

    private final AnAction createShowTipAction(Project project, Notification notification2, TipSuggestion suggestion) {
        TipAndTrickBean tipAndTrickBean = TipAndTrickBean.findById((String)suggestion.getSuggestingTipId());
        if (tipAndTrickBean == null) {
            return null;
        }
        TipAndTrickBean tip = tipAndTrickBean;
        String string = FeatureSuggesterBundle.INSTANCE.message("notification.learn.more", new Object[0]);
        return new AnAction(project, tip, notification2, suggestion, string){
            final /* synthetic */ Project $project;
            final /* synthetic */ TipAndTrickBean $tip;
            final /* synthetic */ Notification $notification;
            final /* synthetic */ TipSuggestion $suggestion;
            {
                this.$project = $project;
                this.$tip = $tip;
                this.$notification = $notification;
                this.$suggestion = $suggestion;
                super($super_call_param$1);
            }

            public void actionPerformed(@NotNull AnActionEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                CoroutineScope coroutineScope = this.$project.getCoroutineScope();
                Intrinsics.checkNotNullExpressionValue((Object)coroutineScope, (String)"getCoroutineScope(...)");
                BuildersKt.launch$default((CoroutineScope)coroutineScope, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this.$project, this.$tip, this.$notification, this.$suggestion, null){
                    int label;
                    final /* synthetic */ Project $project;
                    final /* synthetic */ TipAndTrickBean $tip;
                    final /* synthetic */ Notification $notification;
                    final /* synthetic */ TipSuggestion $suggestion;
                    {
                        this.$project = $project;
                        this.$tip = $tip;
                        this.$notification = $notification;
                        this.$suggestion = $suggestion;
                        super(2, $completion);
                    }

                    /*
                     * Unable to fully structure code
                     */
                    @Nullable
                    public final Object invokeSuspend(@NotNull Object var1_1) {
                        var2_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                        switch (this.label) {
                            case 0: {
                                ResultKt.throwOnFailure((Object)var1_1);
                                this.label = 1;
                                v0 = TipAndTrickManager.Companion.getInstance().showTipDialog(this.$project, this.$tip, (Continuation)this);
                                if (v0 == var2_2) {
                                    return var2_2;
                                }
                                ** GOTO lbl13
                            }
                            case 1: {
                                ResultKt.throwOnFailure((Object)$result);
                                v0 = $result;
lbl13:
                                // 2 sources

                                this.$notification.hideBalloon();
                                FeatureSuggesterStatistics.INSTANCE.logNotificationLearnMore(this.$suggestion.getSuggesterId());
                                return Unit.INSTANCE;
                            }
                        }
                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                    }

                    @NotNull
                    public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                        return (Continuation)new /* invalid duplicate definition of identical inner class */;
                    }

                    @Nullable
                    public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                        return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                    }
                }), (int)3, null);
            }

            @NotNull
            public ActionUpdateThread getActionUpdateThread() {
                return ActionUpdateThread.BGT;
            }
        };
    }
}

