/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.swing.monitor;

import java.applet.Applet;
import java.awt.AWTEvent;
import java.awt.Component;
import java.awt.FileDialog;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.AWTEventListener;
import java.awt.event.ComponentEvent;
import org.assertj.swing.annotation.RunsInEDT;
import org.assertj.swing.dependency.jsr305.Nonnull;
import org.assertj.swing.listener.WeakEventListener;
import org.assertj.swing.monitor.Context;
import org.assertj.swing.monitor.Windows;
import org.assertj.swing.query.ComponentParentQuery;

final class ContextMonitor
implements AWTEventListener {
    private static final long EVENT_MASK = 65L;
    private final Context context;
    private final Windows windows;

    ContextMonitor(Context context, Windows windows) {
        this.context = context;
        this.windows = windows;
    }

    void attachTo(@Nonnull Toolkit toolkit) {
        WeakEventListener.attachAsWeakEventListener(toolkit, this, 65L);
    }

    @Override
    @RunsInEDT
    public void eventDispatched(AWTEvent e) {
        if (!(e instanceof ComponentEvent)) {
            return;
        }
        ComponentEvent event = (ComponentEvent)e;
        Component component2 = event.getComponent();
        if (!(component2 instanceof Applet) && !(component2 instanceof Window)) {
            return;
        }
        this.processEvent(event);
        if (!component2.getToolkit().getSystemEventQueue().equals(this.context.storedQueueFor(component2))) {
            this.context.addContextFor(component2);
        }
    }

    private void processEvent(@Nonnull ComponentEvent event) {
        Component component2 = event.getComponent();
        if (component2 == null) {
            return;
        }
        int id = event.getID();
        if (id == 200) {
            this.recognizeAsOpenWindow(component2);
            return;
        }
        if (id == 202) {
            this.recognizeAsClosedWindow(component2);
            return;
        }
        if (id == 201) {
            return;
        }
        if ((id >= 200 && id <= 209 || id == 102) && (!this.context.rootWindows().contains(component2) || this.windows.isClosed(component2))) {
            this.recognizeAsOpenWindow(component2);
        }
    }

    private void recognizeAsOpenWindow(@Nonnull Component component2) {
        this.context.addContextFor(component2);
        if (!(component2 instanceof Window)) {
            return;
        }
        this.windows.attachNewWindowVisibilityMonitor((Window)component2);
        this.windows.markAsShowing((Window)component2);
        if (component2 instanceof FileDialog) {
            this.windows.markAsReady((Window)component2);
        }
    }

    private void recognizeAsClosedWindow(@Nonnull Component component2) {
        if (ComponentParentQuery.parentOf(component2) == null) {
            this.context.removeContextFor(component2);
        }
        if (component2 instanceof Window) {
            this.windows.markAsClosed((Window)component2);
        }
    }
}

