/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.swing.finder;

import java.awt.Component;
import java.util.concurrent.TimeUnit;
import org.assertj.core.util.Preconditions;
import org.assertj.core.util.Strings;
import org.assertj.swing.core.ComponentFoundCondition;
import org.assertj.swing.core.ComponentMatcher;
import org.assertj.swing.core.GenericTypeMatcher;
import org.assertj.swing.core.NameMatcher;
import org.assertj.swing.core.Robot;
import org.assertj.swing.core.TypeMatcher;
import org.assertj.swing.dependency.jsr305.Nonnegative;
import org.assertj.swing.dependency.jsr305.Nonnull;
import org.assertj.swing.dependency.jsr305.Nullable;
import org.assertj.swing.fixture.AbstractComponentFixture;
import org.assertj.swing.timing.Condition;
import org.assertj.swing.timing.Pause;

public abstract class ComponentFinderTemplate<T extends Component> {
    static final long TIMEOUT = 5000L;
    private long timeout = 5000L;
    private final ComponentMatcher matcher;
    private final String searchDescription;

    protected ComponentFinderTemplate(@Nullable String componentName, @Nonnull Class<? extends T> componentType) {
        this(new NameMatcher(componentName, componentType, true));
    }

    protected ComponentFinderTemplate(@Nonnull GenericTypeMatcher<? extends T> matcher2) {
        this((ComponentMatcher)matcher2);
    }

    protected ComponentFinderTemplate(@Nonnull Class<? extends T> componentType) {
        this(new TypeMatcher(componentType, true));
    }

    private ComponentFinderTemplate(@Nonnull ComponentMatcher matcher2) {
        this.matcher = Preconditions.checkNotNull(matcher2);
        this.searchDescription = Strings.concat("component to be found using matcher ", matcher2);
    }

    protected ComponentFinderTemplate<T> withTimeout(@Nonnegative long newTimeout, @Nonnull TimeUnit unit) {
        Preconditions.checkNotNull(unit);
        return this.withTimeout(unit.toMillis(newTimeout));
    }

    @Nonnull
    protected ComponentFinderTemplate<T> withTimeout(@Nonnegative long newTimeout) {
        if (newTimeout < 0L) {
            throw new IllegalArgumentException("Timeout cannot be a negative number");
        }
        this.timeout = newTimeout;
        return this;
    }

    @Nonnull
    public abstract AbstractComponentFixture<?, T, ?> using(@Nonnull Robot var1);

    @Nonnull
    protected final T findComponentWith(@Nonnull Robot robot) {
        ComponentFoundCondition condition = new ComponentFoundCondition(this.searchDescription, robot.finder(), this.matcher);
        Pause.pause((Condition)condition, this.timeout);
        return (T)((Component)Preconditions.checkNotNull(this.cast(condition.found())));
    }

    @Nullable
    protected abstract T cast(@Nullable Component var1);
}

