/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.swing.driver;

import java.awt.Point;
import java.awt.Rectangle;
import javax.swing.JTree;
import javax.swing.tree.TreePath;
import org.assertj.swing.annotation.RunsInCurrentThread;
import org.assertj.swing.dependency.jsr305.Nonnull;
import org.assertj.swing.exception.LocationUnavailableException;
import org.assertj.swing.util.Arrays;
import org.assertj.swing.util.Pair;

public final class JTreeLocation {
    @Nonnull
    @RunsInCurrentThread
    public Pair<Rectangle, Point> rowBoundsAndCoordinates(@Nonnull JTree tree2, int row2) {
        Rectangle rowBounds = tree2.getRowBounds(this.checkRowInBounds(tree2, row2));
        if (rowBounds != null) {
            return Pair.of(rowBounds, this.pointAt(rowBounds));
        }
        throw new LocationUnavailableException(String.format("The tree row <%d> is not visible", row2));
    }

    @Nonnull
    @RunsInCurrentThread
    public TreePath pathFor(@Nonnull JTree tree2, int row2) {
        TreePath path = tree2.getPathForRow(this.checkRowInBounds(tree2, row2));
        if (path != null) {
            return path;
        }
        throw new LocationUnavailableException(String.format("Unable to find tree path for row <%d>", row2));
    }

    @RunsInCurrentThread
    public int checkRowInBounds(@Nonnull JTree tree2, int row2) {
        int rowCount = tree2.getRowCount();
        if (row2 >= 0 && row2 < rowCount) {
            return row2;
        }
        String msg = String.format("The given row <%d> should be between <0> and <%d>", row2, rowCount);
        throw new IndexOutOfBoundsException(msg);
    }

    @Nonnull
    @RunsInCurrentThread
    public Pair<Rectangle, Point> pathBoundsAndCoordinates(@Nonnull JTree tree2, @Nonnull TreePath path) {
        Rectangle pathBounds = tree2.getPathBounds(path);
        if (pathBounds != null) {
            return Pair.of(pathBounds, this.pointAt(pathBounds));
        }
        throw new LocationUnavailableException(String.format("The tree path %s is not visible", Arrays.format(path.getPath())));
    }

    @Nonnull
    private Point pointAt(@Nonnull Rectangle cellBounds) {
        return new Point(cellBounds.x + cellBounds.width / 2, cellBounds.y + cellBounds.height / 2);
    }
}

