/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.swing.driver;

import java.awt.Component;
import javax.swing.JTree;
import javax.swing.tree.TreeCellRenderer;
import org.assertj.core.util.Preconditions;
import org.assertj.swing.annotation.RunsInCurrentThread;
import org.assertj.swing.cell.JTreeCellReader;
import org.assertj.swing.dependency.jsr305.Nonnull;
import org.assertj.swing.dependency.jsr305.Nullable;
import org.assertj.swing.driver.BasicCellRendererReader;
import org.assertj.swing.driver.CellRendererReader;
import org.assertj.swing.util.Strings;

public class BasicJTreeCellReader
implements JTreeCellReader {
    private final CellRendererReader rendererReader;

    public BasicJTreeCellReader() {
        this(new BasicCellRendererReader());
    }

    public BasicJTreeCellReader(@Nonnull CellRendererReader reader) {
        this.rendererReader = Preconditions.checkNotNull(reader);
    }

    @Override
    @Nullable
    @RunsInCurrentThread
    public String valueAt(@Nonnull JTree tree2, @Nullable Object modelValue) {
        String value;
        TreeCellRenderer r = tree2.getCellRenderer();
        Component c = r.getTreeCellRendererComponent(tree2, modelValue, false, false, false, 0, false);
        String string = value = c != null ? this.rendererReader.valueFrom(c) : null;
        if (value != null) {
            return value;
        }
        value = tree2.convertValueToText(modelValue, false, false, false, 0, false);
        if (Strings.isDefaultToString(value)) {
            return null;
        }
        return value;
    }
}

