/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.rsa;

import java.math.BigInteger;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.interfaces.RSAPrivateKey;
import java.security.interfaces.RSAPublicKey;
import java.security.spec.RSAKeyGenParameterSpec;

public class RSAKeysGenerator {
    private static final int KEYSIZE = 512;

    public static void main(String[] args) throws Exception {
        KeyPairGenerator generator = KeyPairGenerator.getInstance("RSA");
        generator.initialize(new RSAKeyGenParameterSpec(512, RSAKeyGenParameterSpec.F4));
        KeyPair pair = generator.generateKeyPair();
        BigInteger privateModulus = ((RSAPrivateKey)pair.getPrivate()).getModulus();
        BigInteger privateExponent = ((RSAPrivateKey)pair.getPrivate()).getPrivateExponent();
        BigInteger publicModulus = ((RSAPublicKey)pair.getPublic()).getModulus();
        BigInteger publicExponent = ((RSAPublicKey)pair.getPublic()).getPublicExponent();
        System.out.println("private static BigInteger PRIVATE_MOD = new BigInteger(\"" + privateModulus.toString(16) + "\", 16);");
        System.out.println("private static BigInteger PRIVATE_EXP = new BigInteger(\"" + privateExponent.toString(16) + "\", 16);");
        System.out.println("private static BigInteger PUBLIC_MOD = new BigInteger(\"" + publicModulus.toString(16) + "\", 16);");
        System.out.println("private static BigInteger PUBLIC_EXP = new BigInteger(\"" + publicExponent.toString(16) + "\", 16);");
    }
}

