/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.java.decompiler.modules.code;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.jetbrains.java.decompiler.code.Instruction;
import org.jetbrains.java.decompiler.code.InstructionSequence;
import org.jetbrains.java.decompiler.code.SimpleInstructionSequence;
import org.jetbrains.java.decompiler.code.cfg.BasicBlock;
import org.jetbrains.java.decompiler.code.cfg.ControlFlowGraph;
import org.jetbrains.java.decompiler.code.cfg.ExceptionRangeCFG;
import org.jetbrains.java.decompiler.main.DecompilerContext;
import org.jetbrains.java.decompiler.modules.decompiler.FinallyProcessor;
import org.jetbrains.java.decompiler.util.VBStyleCollection;

public final class DeadCodeHelper {
    public static void removeDeadBlocks(ControlFlowGraph graph) {
        LinkedList<BasicBlock> stack = new LinkedList<BasicBlock>();
        HashSet<BasicBlock> setStacked = new HashSet<BasicBlock>();
        stack.add(graph.getFirst());
        setStacked.add(graph.getFirst());
        while (!stack.isEmpty()) {
            BasicBlock block = (BasicBlock)stack.removeFirst();
            ArrayList<BasicBlock> successors = new ArrayList<BasicBlock>(block.getSuccessors());
            successors.addAll(block.getSuccessorExceptions());
            for (BasicBlock successor : successors) {
                if (setStacked.contains(successor)) continue;
                stack.add(successor);
                setStacked.add(successor);
            }
        }
        HashSet setAllBlocks = new HashSet(graph.getBlocks());
        setAllBlocks.removeAll(setStacked);
        for (BasicBlock block : setAllBlocks) {
            graph.removeBlock(block);
        }
    }

    public static void removeEmptyBlocks(ControlFlowGraph graph) {
        boolean cont;
        VBStyleCollection<BasicBlock, Integer> blocks = graph.getBlocks();
        block0: do {
            cont = false;
            for (int i = blocks.size() - 1; i >= 0; --i) {
                BasicBlock block = (BasicBlock)blocks.get(i);
                if (!DeadCodeHelper.removeEmptyBlock(graph, block, false)) continue;
                cont = true;
                continue block0;
            }
        } while (cont);
    }

    private static boolean removeEmptyBlock(ControlFlowGraph graph, BasicBlock block, boolean merging) {
        boolean deletedRanges = false;
        if (block.getSeq().isEmpty()) {
            if (block.getSuccessors().size() > 1) {
                if (block.getPredecessors().size() > 1) {
                    throw new RuntimeException("ERROR: empty block with multiple predecessors and successors found");
                }
                if (!merging) {
                    throw new RuntimeException("ERROR: empty block with multiple successors found");
                }
            }
            HashSet<BasicBlock> setExits = new HashSet<BasicBlock>(graph.getLast().getPredecessors());
            if (block.getPredecessorExceptions().isEmpty() && (!setExits.contains(block) || block.getPredecessors().size() == 1)) {
                Set<BasicBlock> setFinallyExits;
                BasicBlock predecessor;
                if (setExits.contains(block) && ((predecessor = block.getPredecessors().get(0)).getSuccessors().size() != 1 || !predecessor.getSeq().isEmpty() && predecessor.getSeq().getLastInstr().group == 3)) {
                    return false;
                }
                HashSet<BasicBlock> predecessors = new HashSet<BasicBlock>(block.getPredecessors());
                HashSet<BasicBlock> successors = new HashSet<BasicBlock>(block.getSuccessors());
                HashSet<BasicBlock> setCommonExceptionHandlers = null;
                for (int i = 0; i < 2; ++i) {
                    for (BasicBlock adjacent : i == 0 ? predecessors : successors) {
                        if (setCommonExceptionHandlers == null) {
                            setCommonExceptionHandlers = new HashSet<BasicBlock>(adjacent.getSuccessorExceptions());
                            continue;
                        }
                        setCommonExceptionHandlers.retainAll(adjacent.getSuccessorExceptions());
                    }
                }
                if (setCommonExceptionHandlers != null && !setCommonExceptionHandlers.isEmpty()) {
                    for (BasicBlock handler : setCommonExceptionHandlers) {
                        if (block.getSuccessorExceptions().contains(handler)) continue;
                        return false;
                    }
                }
                List<ExceptionRangeCFG> lstRanges = graph.getExceptions();
                for (int i = lstRanges.size() - 1; i >= 0; --i) {
                    ExceptionRangeCFG range = lstRanges.get(i);
                    List<BasicBlock> lst = range.getProtectedRange();
                    if (lst.size() != 1 || lst.get(0) != block) continue;
                    if (DecompilerContext.getOption("rer")) {
                        block.removeSuccessorException(range.getHandler());
                        lstRanges.remove(i);
                        deletedRanges = true;
                        continue;
                    }
                    return false;
                }
                if (merging) {
                    BasicBlock predecessor2 = block.getPredecessors().get(0);
                    predecessor2.removeSuccessor(block);
                    ArrayList<BasicBlock> successorList = new ArrayList<BasicBlock>(block.getSuccessors());
                    for (BasicBlock successor : successorList) {
                        block.removeSuccessor(successor);
                        predecessor2.addSuccessor(successor);
                    }
                } else {
                    for (BasicBlock predecessor3 : predecessors) {
                        for (BasicBlock successor : successors) {
                            predecessor3.replaceSuccessor(block, successor);
                        }
                    }
                }
                if ((setFinallyExits = graph.getFinallyExits()).contains(block)) {
                    setFinallyExits.remove(block);
                    setFinallyExits.add((BasicBlock)predecessors.iterator().next());
                }
                if (graph.getFirst() == block) {
                    if (successors.size() != 1) {
                        throw new RuntimeException("multiple or no entry blocks!");
                    }
                    graph.setFirst((BasicBlock)successors.iterator().next());
                }
                graph.removeBlock(block);
                if (deletedRanges) {
                    DeadCodeHelper.removeDeadBlocks(graph);
                }
            }
        }
        return deletedRanges;
    }

    public static boolean isDominator(ControlFlowGraph graph, BasicBlock block, BasicBlock dom) {
        if (block == dom) {
            return true;
        }
        HashSet<BasicBlock> marked = new HashSet<BasicBlock>();
        LinkedList<BasicBlock> lstNodes = new LinkedList<BasicBlock>();
        lstNodes.add(block);
        while (!lstNodes.isEmpty()) {
            BasicBlock predecessor;
            int i;
            BasicBlock node = (BasicBlock)lstNodes.remove(0);
            if (marked.contains(node)) continue;
            marked.add(node);
            if (node == graph.getFirst()) {
                return false;
            }
            for (i = 0; i < node.getPredecessors().size(); ++i) {
                predecessor = node.getPredecessors().get(i);
                if (predecessor == dom || marked.contains(predecessor)) continue;
                lstNodes.add(predecessor);
            }
            for (i = 0; i < node.getPredecessorExceptions().size(); ++i) {
                predecessor = node.getPredecessorExceptions().get(i);
                if (predecessor == dom || marked.contains(predecessor)) continue;
                lstNodes.add(predecessor);
            }
        }
        return true;
    }

    public static void removeGoTos(ControlFlowGraph graph) {
        for (BasicBlock block : graph.getBlocks()) {
            Instruction instr = block.getLastInstruction();
            if (instr == null || instr.opcode != 167) continue;
            block.getSeq().removeLast();
        }
        DeadCodeHelper.removeEmptyBlocks(graph);
    }

    public static void connectDummyExitBlock(ControlFlowGraph graph) {
        BasicBlock exit = graph.getLast();
        for (BasicBlock block : new HashSet<BasicBlock>(exit.getPredecessors())) {
            exit.removePredecessor(block);
            block.addSuccessor(exit);
        }
    }

    /*
     * WARNING - void declaration
     */
    public static void extendSynchronizedRangeToMonitorExit(ControlFlowGraph graph) {
        boolean rangeExtended;
        block0: do {
            rangeExtended = false;
            for (ExceptionRangeCFG range : graph.getExceptions()) {
                void var10_16;
                int handlerMonitorExitIndex;
                BasicBlock successorHandler;
                InstructionSequence successorHandlerSeq;
                BasicBlock handlerBlock;
                BasicBlock basicBlock;
                InstructionSequence successorSeq;
                int successorMonitorExitIndex;
                BasicBlock predecessor;
                InstructionSequence predecessorSeq;
                HashSet<BasicBlock> predecessors = new HashSet<BasicBlock>();
                for (BasicBlock block2 : range.getProtectedRange()) {
                    predecessors.addAll(block2.getPredecessors());
                }
                for (BasicBlock basicBlock2 : range.getProtectedRange()) {
                    predecessors.remove(basicBlock2);
                }
                if (predecessors.size() != 1 || (predecessorSeq = (predecessor = (BasicBlock)predecessors.iterator().next()).getSeq()).isEmpty() || predecessorSeq.getLastInstr().opcode != 194) continue;
                boolean monitorExitInRange = false;
                HashSet<BasicBlock> setProtectedBlocks = new HashSet<BasicBlock>(range.getProtectedRange());
                setProtectedBlocks.add(range.getHandler());
                for (BasicBlock basicBlock3 : setProtectedBlocks) {
                    InstructionSequence blockSeq = basicBlock3.getSeq();
                    for (int i = 0; i < blockSeq.length(); ++i) {
                        if (blockSeq.getInstr((int)i).opcode != 195) continue;
                        monitorExitInRange = true;
                        break;
                    }
                    if (!monitorExitInRange) continue;
                    break;
                }
                if (monitorExitInRange) continue;
                HashSet<BasicBlock> successors = new HashSet<BasicBlock>();
                for (BasicBlock block4 : range.getProtectedRange()) {
                    successors.addAll(block4.getSuccessors());
                }
                for (BasicBlock basicBlock4 : range.getProtectedRange()) {
                    successors.remove(basicBlock4);
                }
                if (successors.size() != 1 || (successorMonitorExitIndex = DeadCodeHelper.findMonitorExitIndex(successorSeq = (basicBlock = (BasicBlock)successors.iterator().next()).getSeq())) < 0 || (handlerBlock = range.getHandler()).getSuccessors().size() != 1 || (successorHandlerSeq = (successorHandler = handlerBlock.getSuccessors().get(0)).getSeq()).isEmpty() || successorHandlerSeq.getLastInstr().opcode != 191 || (handlerMonitorExitIndex = DeadCodeHelper.findMonitorExitIndex(successorHandlerSeq)) < 0) continue;
                if (successorMonitorExitIndex < successorSeq.length() - 1) {
                    SimpleInstructionSequence seq = new SimpleInstructionSequence();
                    for (int counter = 0; counter < successorMonitorExitIndex; ++counter) {
                        seq.addInstruction(successorSeq.getInstr(0), -1);
                        successorSeq.removeInstruction(0);
                    }
                    BasicBlock newBlock = new BasicBlock(++graph.last_id, seq);
                    for (BasicBlock block5 : basicBlock.getPredecessors()) {
                        block5.replaceSuccessor(basicBlock, newBlock);
                    }
                    newBlock.addSuccessor(basicBlock);
                    graph.getBlocks().addWithKey(newBlock, newBlock.id);
                    BasicBlock basicBlock5 = newBlock;
                }
                BasicBlock rangeExitBlock = var10_16.getPredecessors().get(0);
                FinallyProcessor.copyExceptionEdges(graph, rangeExitBlock, (BasicBlock)var10_16);
                InstructionSequence handlerSeq = handlerBlock.getSeq();
                for (int counter = 0; counter < handlerMonitorExitIndex; ++counter) {
                    handlerSeq.addInstruction(successorHandlerSeq.getInstr(0), -1);
                    successorHandlerSeq.removeInstruction(0);
                }
                rangeExtended = true;
                continue block0;
            }
        } while (rangeExtended);
    }

    private static int findMonitorExitIndex(InstructionSequence sequence) {
        int index = -1;
        for (int i = 0; i < sequence.length(); ++i) {
            if (sequence.getInstr((int)i).opcode != 195) continue;
            index = i;
            break;
        }
        return index;
    }

    public static void incorporateValueReturns(ControlFlowGraph graph) {
        for (BasicBlock block : graph.getBlocks()) {
            ExceptionRangeCFG range;
            BasicBlock predecessor;
            InstructionSequence seq = block.getSeq();
            int len = seq.length();
            if (len <= 0 || len >= 3) continue;
            boolean ok = false;
            if (seq.getLastInstr().opcode >= 172 && seq.getLastInstr().opcode <= 177) {
                if (len == 1) {
                    ok = true;
                } else if (seq.getLastInstr().opcode != 177) {
                    switch (seq.getInstr((int)0).opcode) {
                        case 1: 
                        case 9: 
                        case 10: 
                        case 11: 
                        case 12: 
                        case 13: 
                        case 14: 
                        case 15: 
                        case 16: 
                        case 17: 
                        case 18: 
                        case 19: 
                        case 20: 
                        case 21: 
                        case 22: 
                        case 23: 
                        case 24: 
                        case 25: {
                            boolean bl = true;
                            break;
                        }
                        default: {
                            boolean bl = ok = false;
                        }
                    }
                }
            }
            if (!ok) continue;
            if (!block.getPredecessors().isEmpty()) {
                HashSet<BasicBlock> predecessorHandlersUnion = new HashSet<BasicBlock>();
                HashSet<BasicBlock> predecessorHandlersIntersection = new HashSet<BasicBlock>();
                boolean firstPredecessor = true;
                for (BasicBlock basicBlock : block.getPredecessors()) {
                    if (firstPredecessor) {
                        predecessorHandlersIntersection.addAll(basicBlock.getSuccessorExceptions());
                        firstPredecessor = false;
                    } else {
                        predecessorHandlersIntersection.retainAll(basicBlock.getSuccessorExceptions());
                    }
                    predecessorHandlersUnion.addAll(basicBlock.getSuccessorExceptions());
                }
                for (BasicBlock basicBlock : block.getSuccessorExceptions()) {
                    predecessorHandlersIntersection.remove(basicBlock);
                }
                BasicBlock predecessor3 = block.getPredecessors().get(0);
                for (BasicBlock handler : predecessorHandlersIntersection) {
                    ExceptionRangeCFG range2 = graph.getExceptionRange(handler, predecessor3);
                    range2.getProtectedRange().add(block);
                    block.addSuccessorException(handler);
                }
                HashSet<BasicBlock> hashSet = new HashSet<BasicBlock>(block.getSuccessorExceptions());
                hashSet.removeAll(predecessorHandlersUnion);
                for (BasicBlock handler : hashSet) {
                    ExceptionRangeCFG range3 = graph.getExceptionRange(handler, block);
                    if (range3.getProtectedRange().size() <= 1) continue;
                    range3.getProtectedRange().remove(block);
                    block.removeSuccessorException(handler);
                }
            }
            if (block.getPredecessors().size() != 1 || !block.getPredecessorExceptions().isEmpty() || (predecessor = block.getPredecessors().get(0)).getSuccessors().size() != 1) continue;
            for (BasicBlock successor : predecessor.getSuccessorExceptions()) {
                if (block.getSuccessorExceptions().contains(successor)) continue;
                range = graph.getExceptionRange(successor, predecessor);
                range.getProtectedRange().add(block);
                block.addSuccessorException(successor);
            }
            for (BasicBlock successor : new HashSet<BasicBlock>(block.getSuccessorExceptions())) {
                if (predecessor.getSuccessorExceptions().contains(successor) || (range = graph.getExceptionRange(successor, block)).getProtectedRange().size() <= 1) continue;
                range.getProtectedRange().remove(block);
                block.removeSuccessorException(successor);
            }
        }
    }

    public static void mergeBasicBlocks(ControlFlowGraph graph) {
        int originBlocksCount;
        boolean merged;
        block0: do {
            merged = false;
            originBlocksCount = graph.getBlocks().size();
            for (BasicBlock block : graph.getBlocks()) {
                BasicBlock next;
                InstructionSequence seq = block.getSeq();
                if (block.getSuccessors().size() != 1 || (next = block.getSuccessors().get(0)) == graph.getLast() || !seq.isEmpty() && seq.getLastInstr().group == 3 || next.getPredecessors().size() != 1 || !next.getPredecessorExceptions().isEmpty() || next == graph.getFirst()) continue;
                boolean sameRanges = true;
                for (ExceptionRangeCFG range : graph.getExceptions()) {
                    if (!(range.getProtectedRange().contains(block) ^ range.getProtectedRange().contains(next))) continue;
                    sameRanges = false;
                    break;
                }
                if (!sameRanges) continue;
                seq.addSequence(next.getSeq());
                block.getOriginalOffsets().addAll(next.getOriginalOffsets());
                next.getSeq().clear();
                DeadCodeHelper.removeEmptyBlock(graph, next, true);
                merged = true;
                continue block0;
            }
        } while (merged && graph.getBlocks().size() != originBlocksCount);
    }
}

