/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.classrealm;

import java.io.File;
import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Random;
import java.util.Set;
import org.apache.maven.artifact.ArtifactUtils;
import org.apache.maven.classrealm.ArtifactClassRealmConstituent;
import org.apache.maven.classrealm.ClassRealmConstituent;
import org.apache.maven.classrealm.ClassRealmManager;
import org.apache.maven.classrealm.ClassRealmManagerDelegate;
import org.apache.maven.classrealm.ClassRealmRequest;
import org.apache.maven.classrealm.DefaultClassRealmRequest;
import org.apache.maven.model.Model;
import org.apache.maven.model.Plugin;
import org.codehaus.plexus.MutablePlexusContainer;
import org.codehaus.plexus.PlexusContainer;
import org.codehaus.plexus.classworlds.ClassWorld;
import org.codehaus.plexus.classworlds.realm.ClassRealm;
import org.codehaus.plexus.classworlds.realm.DuplicateRealmException;
import org.codehaus.plexus.component.annotations.Component;
import org.codehaus.plexus.component.annotations.Requirement;
import org.codehaus.plexus.component.repository.exception.ComponentLookupException;
import org.codehaus.plexus.logging.Logger;
import org.codehaus.plexus.util.StringUtils;
import org.sonatype.aether.artifact.Artifact;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Component(role=ClassRealmManager.class)
public class DefaultClassRealmManager
implements ClassRealmManager {
    @Requirement
    private Logger logger;
    @Requirement
    protected PlexusContainer container;
    private ClassRealm mavenRealm;

    private ClassWorld getClassWorld() {
        return ((MutablePlexusContainer)this.container).getClassWorld();
    }

    private ClassRealm newRealm(String id) {
        ClassWorld world;
        ClassWorld classWorld = world = this.getClassWorld();
        synchronized (classWorld) {
            String realmId = id;
            Random random = new Random();
            while (true) {
                try {
                    ClassRealm classRealm = world.newRealm(realmId, null);
                    if (this.logger.isDebugEnabled()) {
                        this.logger.debug("Created new class realm " + realmId);
                    }
                    return classRealm;
                }
                catch (DuplicateRealmException e) {
                    realmId = id + '-' + random.nextInt();
                    continue;
                }
                break;
            }
        }
    }

    private synchronized ClassRealm getMavenRealm() {
        if (this.mavenRealm == null) {
            this.mavenRealm = this.newRealm("maven.api");
            this.importMavenApi(this.mavenRealm);
            this.mavenRealm.setParentClassLoader(ClassLoader.getSystemClassLoader());
            List<ClassRealmManagerDelegate> delegates = this.getDelegates();
            if (!delegates.isEmpty()) {
                ArrayList<ClassRealmConstituent> constituents = new ArrayList<ClassRealmConstituent>();
                DefaultClassRealmRequest request = new DefaultClassRealmRequest(ClassRealmRequest.RealmType.Core, null, new ArrayList<String>(), constituents);
                for (ClassRealmManagerDelegate delegate : delegates) {
                    delegate.setupRealm(this.mavenRealm, request);
                }
                this.populateRealm(this.mavenRealm, constituents);
            }
        }
        return this.mavenRealm;
    }

    private ClassRealm createRealm(String baseRealmId, ClassRealmRequest.RealmType type, ClassLoader parent, List<String> imports, boolean importXpp3Dom, List<Artifact> artifacts) {
        LinkedHashSet<String> artifactIds = new LinkedHashSet<String>();
        ArrayList<ClassRealmConstituent> constituents = new ArrayList<ClassRealmConstituent>();
        if (artifacts != null) {
            for (Artifact artifact : artifacts) {
                artifactIds.add(DefaultClassRealmManager.getId(artifact));
                if (artifact.getFile() == null) continue;
                constituents.add(new ArtifactClassRealmConstituent(artifact));
            }
        }
        imports = imports != null ? new ArrayList<String>(imports) : new ArrayList<String>();
        ClassRealm classRealm = this.newRealm(baseRealmId);
        if (parent != null) {
            classRealm.setParentClassLoader(parent);
        } else {
            classRealm.setParentRealm(this.getMavenRealm());
        }
        List<ClassRealmManagerDelegate> delegates = this.getDelegates();
        if (!delegates.isEmpty()) {
            DefaultClassRealmRequest request = new DefaultClassRealmRequest(type, parent, imports, constituents);
            for (ClassRealmManagerDelegate delegate : delegates) {
                delegate.setupRealm(classRealm, request);
            }
        }
        if (importXpp3Dom) {
            this.importXpp3Dom(classRealm);
        }
        if (!imports.isEmpty()) {
            ClassLoader importedRealm = classRealm.getParentClassLoader();
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Importing packages into class realm " + classRealm.getId());
            }
            for (String imp : imports) {
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug("  Imported: " + imp);
                }
                classRealm.importFrom(importedRealm, imp);
            }
        }
        Set<String> includedIds = this.populateRealm(classRealm, constituents);
        if (this.logger.isDebugEnabled()) {
            artifactIds.removeAll(includedIds);
            for (String id : artifactIds) {
                this.logger.debug("  Excluded: " + id);
            }
        }
        return classRealm;
    }

    private void importXpp3Dom(ClassRealm importingRealm) {
        ClassRealm coreRealm = this.getCoreRealm();
        importingRealm.importFrom(coreRealm, "org.codehaus.plexus.util.xml.Xpp3Dom");
        importingRealm.importFrom(coreRealm, "org.codehaus.plexus.util.xml.pull.XmlPullParser");
        importingRealm.importFrom(coreRealm, "org.codehaus.plexus.util.xml.pull.XmlPullParserException");
        importingRealm.importFrom(coreRealm, "org.codehaus.plexus.util.xml.pull.XmlSerializer");
    }

    private void importMavenApi(ClassRealm importingRealm) {
        ClassRealm coreRealm = this.getCoreRealm();
        importingRealm.importFrom(coreRealm, "org.apache.maven");
        importingRealm.importFrom(coreRealm, "org.sonatype.aether");
        importingRealm.importFrom(coreRealm, "org.codehaus.plexus.classworlds");
        importingRealm.importFrom(coreRealm, "org.codehaus.classworlds");
        importingRealm.importFrom(coreRealm, "org.codehaus.plexus.component");
        importingRealm.importFrom(coreRealm, "org.codehaus.plexus.configuration");
        importingRealm.importFrom(coreRealm, "org.codehaus.plexus.container");
        importingRealm.importFrom(coreRealm, "org.codehaus.plexus.context");
        importingRealm.importFrom(coreRealm, "org.codehaus.plexus.lifecycle");
        importingRealm.importFrom(coreRealm, "org.codehaus.plexus.logging");
        importingRealm.importFrom(coreRealm, "org.codehaus.plexus.personality");
        importingRealm.importFrom(coreRealm, "org.codehaus.plexus.ComponentRegistry");
        importingRealm.importFrom(coreRealm, "org.codehaus.plexus.ContainerConfiguration");
        importingRealm.importFrom(coreRealm, "org.codehaus.plexus.DefaultComponentRegistry");
        importingRealm.importFrom(coreRealm, "org.codehaus.plexus.DefaultContainerConfiguration");
        importingRealm.importFrom(coreRealm, "org.codehaus.plexus.DefaultPlexusContainer");
        importingRealm.importFrom(coreRealm, "org.codehaus.plexus.DuplicateChildContainerException");
        importingRealm.importFrom(coreRealm, "org.codehaus.plexus.MutablePlexusContainer");
        importingRealm.importFrom(coreRealm, "org.codehaus.plexus.PlexusConstants");
        importingRealm.importFrom(coreRealm, "org.codehaus.plexus.PlexusContainer");
        importingRealm.importFrom(coreRealm, "org.codehaus.plexus.PlexusContainerException");
    }

    @Override
    public ClassRealm getCoreRealm() {
        return this.container.getContainerRealm();
    }

    @Override
    public ClassRealm createProjectRealm(Model model, List<Artifact> artifacts) {
        if (model == null) {
            throw new IllegalArgumentException("model missing");
        }
        return this.createRealm(DefaultClassRealmManager.getKey(model), ClassRealmRequest.RealmType.Project, null, null, false, artifacts);
    }

    private static String getKey(Model model) {
        return "project>" + model.getGroupId() + ":" + model.getArtifactId() + ":" + model.getVersion();
    }

    @Override
    public ClassRealm createExtensionRealm(Plugin plugin, List<Artifact> artifacts) {
        if (plugin == null) {
            throw new IllegalArgumentException("extension plugin missing");
        }
        return this.createRealm(DefaultClassRealmManager.getKey(plugin, true), ClassRealmRequest.RealmType.Extension, null, null, true, artifacts);
    }

    @Override
    public ClassRealm createPluginRealm(Plugin plugin, ClassLoader parent, List<String> imports, List<Artifact> artifacts) {
        if (plugin == null) {
            throw new IllegalArgumentException("plugin missing");
        }
        return this.createRealm(DefaultClassRealmManager.getKey(plugin, false), ClassRealmRequest.RealmType.Plugin, parent, imports, true, artifacts);
    }

    private static String getKey(Plugin plugin, boolean extension) {
        String version = ArtifactUtils.toSnapshotVersion(plugin.getVersion());
        return (extension ? "extension>" : "plugin>") + plugin.getGroupId() + ":" + plugin.getArtifactId() + ":" + version;
    }

    private static String getId(Artifact artifact) {
        return DefaultClassRealmManager.getId(artifact.getGroupId(), artifact.getArtifactId(), artifact.getExtension(), artifact.getClassifier(), artifact.getBaseVersion());
    }

    private static String getId(ClassRealmConstituent constituent) {
        return DefaultClassRealmManager.getId(constituent.getGroupId(), constituent.getArtifactId(), constituent.getType(), constituent.getClassifier(), constituent.getVersion());
    }

    private static String getId(String gid, String aid, String type, String cls, String ver) {
        return gid + ':' + aid + ':' + type + (StringUtils.isNotEmpty((String)cls) ? ':' + cls : "") + ':' + ver;
    }

    private List<ClassRealmManagerDelegate> getDelegates() {
        try {
            return this.container.lookupList(ClassRealmManagerDelegate.class);
        }
        catch (ComponentLookupException e) {
            this.logger.error("Failed to lookup class realm delegates: " + e.getMessage(), e);
            return Collections.emptyList();
        }
    }

    private Set<String> populateRealm(ClassRealm classRealm, List<ClassRealmConstituent> constituents) {
        LinkedHashSet<String> includedIds = new LinkedHashSet<String>();
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Populating class realm " + classRealm.getId());
        }
        for (ClassRealmConstituent constituent : constituents) {
            File file = constituent.getFile();
            String id = DefaultClassRealmManager.getId(constituent);
            includedIds.add(id);
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("  Included: " + id);
            }
            try {
                classRealm.addURL(file.toURI().toURL());
            }
            catch (MalformedURLException e) {
                this.logger.error(e.getMessage(), e);
            }
        }
        return includedIds;
    }
}

