/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.archetype.old;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.HashMap;
import java.util.Map;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;
import org.apache.maven.archetype.ArchetypeGenerationRequest;
import org.apache.maven.archetype.common.ArchetypeArtifactManager;
import org.apache.maven.archetype.common.util.PomUtils;
import org.apache.maven.archetype.exception.InvalidPackaging;
import org.apache.maven.archetype.exception.UnknownArchetype;
import org.apache.maven.archetype.old.ArchetypeDescriptorException;
import org.apache.maven.archetype.old.ArchetypeTemplateProcessingException;
import org.apache.maven.archetype.old.OldArchetype;
import org.apache.maven.archetype.old.descriptor.ArchetypeDescriptor;
import org.apache.maven.archetype.old.descriptor.ArchetypeDescriptorBuilder;
import org.apache.maven.archetype.old.descriptor.TemplateDescriptor;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.model.Build;
import org.apache.maven.model.Model;
import org.apache.maven.model.Parent;
import org.apache.maven.model.Resource;
import org.apache.maven.model.io.xpp3.MavenXpp3Reader;
import org.apache.maven.model.io.xpp3.MavenXpp3Writer;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.context.Context;
import org.codehaus.plexus.component.annotations.Component;
import org.codehaus.plexus.component.annotations.Requirement;
import org.codehaus.plexus.logging.AbstractLogEnabled;
import org.codehaus.plexus.util.FileUtils;
import org.codehaus.plexus.util.IOUtil;
import org.codehaus.plexus.util.ReaderFactory;
import org.codehaus.plexus.util.StringUtils;
import org.codehaus.plexus.util.WriterFactory;
import org.codehaus.plexus.util.xml.XmlStreamReader;
import org.codehaus.plexus.util.xml.XmlStreamWriter;
import org.codehaus.plexus.util.xml.pull.XmlPullParserException;
import org.codehaus.plexus.velocity.VelocityComponent;
import org.xml.sax.SAXException;

@Component(role=OldArchetype.class)
public class DefaultOldArchetype
extends AbstractLogEnabled
implements OldArchetype {
    private static final String DEFAULT_TEST_RESOURCE_DIR = "/src/test/resources";
    private static final String DEFAULT_TEST_SOURCE_DIR = "/src/test/java";
    private static final String DEFAULT_RESOURCE_DIR = "/src/main/resources";
    private static final String DEFAULT_SOURCE_DIR = "/src/main/java";
    @Requirement
    private VelocityComponent velocity;
    @Requirement
    private ArchetypeArtifactManager archetypeArtifactManager;

    @Override
    public void createArchetype(ArchetypeGenerationRequest request, ArtifactRepository archetypeRepository) throws UnknownArchetype, ArchetypeDescriptorException, ArchetypeTemplateProcessingException, InvalidPackaging {
        File archetypeFile = this.archetypeArtifactManager.getArchetypeFile(request.getArchetypeGroupId(), request.getArchetypeArtifactId(), request.getArchetypeVersion(), archetypeRepository, request.getLocalRepository(), request.getRemoteArtifactRepositories(), request.getProjectBuildingRequest());
        this.createArchetype(request, archetypeFile);
    }

    @Override
    public void createArchetype(ArchetypeGenerationRequest request, File archetypeFile) throws ArchetypeDescriptorException, ArchetypeTemplateProcessingException, InvalidPackaging {
        File pomFile;
        boolean creating;
        File outputDirectoryFile;
        ArchetypeDescriptor descriptor;
        URL[] urls;
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("basedir", request.getOutputDirectory());
        parameters.put("package", request.getPackage());
        parameters.put("packageName", request.getPackage());
        parameters.put("groupId", request.getGroupId());
        parameters.put("artifactId", request.getArtifactId());
        parameters.put("version", request.getVersion());
        if (this.getLogger().isInfoEnabled()) {
            this.getLogger().info("----------------------------------------------------------------------------");
            this.getLogger().info("Using following parameters for creating project from Old (1.x) Archetype: " + request.getArchetypeArtifactId() + ":" + request.getArchetypeVersion());
            this.getLogger().info("----------------------------------------------------------------------------");
            for (Map.Entry entry : parameters.entrySet()) {
                String parameterName = (String)entry.getKey();
                String parameterValue = (String)entry.getValue();
                this.getLogger().info("Parameter: " + parameterName + ", Value: " + parameterValue);
            }
        }
        ArchetypeDescriptorBuilder builder = new ArchetypeDescriptorBuilder();
        try {
            urls = new URL[]{archetypeFile.toURI().toURL()};
        }
        catch (MalformedURLException e) {
            throw new ArchetypeDescriptorException(e.getMessage());
        }
        URLClassLoader archetypeJarLoader = new URLClassLoader(urls);
        try (InputStream is = this.getDescriptorInputStream(archetypeJarLoader);){
            descriptor = builder.build((Reader)new org.apache.commons.io.input.XmlStreamReader(is));
        }
        catch (IOException | XmlPullParserException e) {
            throw new ArchetypeDescriptorException("Error reading the META-INF/maven/archetype.xml descriptor.", e);
        }
        String artifactId = request.getArtifactId();
        File parentPomFile = new File(request.getOutputDirectory(), "pom.xml");
        if (parentPomFile.exists() && descriptor.isAllowPartial() && artifactId == null) {
            outputDirectoryFile = new File(request.getOutputDirectory());
            creating = false;
            pomFile = parentPomFile;
        } else {
            if (artifactId == null) {
                throw new ArchetypeTemplateProcessingException("Artifact ID must be specified when creating a new project from an archetype.");
            }
            outputDirectoryFile = new File(request.getOutputDirectory(), artifactId);
            creating = true;
            if (outputDirectoryFile.exists()) {
                if (descriptor.isAllowPartial()) {
                    creating = false;
                } else {
                    throw new ArchetypeTemplateProcessingException("Directory " + outputDirectoryFile.getName() + " already exists - please run from a clean directory");
                }
            }
            pomFile = new File(outputDirectoryFile, "pom.xml");
        }
        if (creating) {
            if (request.getGroupId() == null) {
                throw new ArchetypeTemplateProcessingException("Group ID must be specified when creating a new project from an archetype.");
            }
            if (request.getVersion() == null) {
                throw new ArchetypeTemplateProcessingException("Version must be specified when creating a new project from an archetype.");
            }
        }
        String outputDirectory = outputDirectoryFile.getAbsolutePath();
        String packageName = request.getPackage();
        VelocityContext context = new VelocityContext();
        context.put("package", packageName);
        for (Map.Entry entry : parameters.entrySet()) {
            context.put((String)entry.getKey(), entry.getValue());
        }
        ClassLoader old = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(archetypeJarLoader);
        Model parentModel = null;
        if (creating && parentPomFile.exists()) {
            try (XmlStreamReader fileReader = ReaderFactory.newXmlReader((File)parentPomFile);){
                MavenXpp3Reader reader = new MavenXpp3Reader();
                parentModel = reader.read((Reader)fileReader);
                if (!"pom".equals(parentModel.getPackaging())) {
                    throw new ArchetypeTemplateProcessingException("Unable to add module to the current project as it is not of packaging type 'pom'");
                }
            }
            catch (IOException | XmlPullParserException e) {
                throw new ArchetypeTemplateProcessingException("Unable to read parent POM", e);
            }
            parentModel.getModules().add(artifactId);
        }
        try {
            this.processTemplates(pomFile, outputDirectory, context, descriptor, packageName, parentModel);
        }
        catch (IOException e) {
            throw new ArchetypeTemplateProcessingException("Unable to process template", e);
        }
        finally {
            Thread.currentThread().setContextClassLoader(old);
        }
        if (parentModel != null) {
            boolean added;
            Throwable throwable;
            StringWriter w = new StringWriter();
            try {
                throwable = null;
                try (XmlStreamReader fileReader = ReaderFactory.newXmlReader((File)parentPomFile);){
                    added = DefaultOldArchetype.addModuleToParentPom(artifactId, (Reader)fileReader, w);
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
            }
            catch (IOException | ParserConfigurationException | TransformerException | SAXException e) {
                throw new ArchetypeTemplateProcessingException("Unable to rewrite parent POM", e);
            }
            if (added) {
                try {
                    throwable = null;
                    try (XmlStreamWriter out = WriterFactory.newXmlWriter((File)parentPomFile);){
                        IOUtil.copy((String)w.toString(), (Writer)out);
                    }
                    catch (Throwable throwable3) {
                        throwable = throwable3;
                        throw throwable3;
                    }
                }
                catch (IOException e) {
                    throw new ArchetypeTemplateProcessingException("Unable to rewrite parent POM", e);
                }
            }
        }
        if (this.getLogger().isInfoEnabled()) {
            this.getLogger().info("project created from Old (1.x) Archetype in dir: " + outputDirectory);
        }
    }

    private InputStream getDescriptorInputStream(ClassLoader archetypeJarLoader) throws ArchetypeDescriptorException {
        InputStream is = this.getStream("META-INF/maven/archetype.xml", archetypeJarLoader);
        if (is == null) {
            is = this.getStream("META-INF/archetype.xml", archetypeJarLoader);
        }
        if (is == null) {
            throw new ArchetypeDescriptorException("The META-INF/maven/archetype.xml descriptor cannot be found.");
        }
        return is;
    }

    static boolean addModuleToParentPom(String artifactId, Reader fileReader, Writer fileWriter) throws ArchetypeTemplateProcessingException, InvalidPackaging, IOException, ParserConfigurationException, SAXException, TransformerException {
        return PomUtils.addNewModule(artifactId, fileReader, fileWriter);
    }

    private void processTemplates(File pomFile, String outputDirectory, Context context, ArchetypeDescriptor descriptor, String packageName, Model parentModel) throws ArchetypeTemplateProcessingException, IOException {
        boolean foundBuildElement;
        Model generatedModel;
        Object reader;
        if (!pomFile.exists()) {
            this.processTemplate(outputDirectory, context, "pom.xml", new TemplateDescriptor(), false, null);
        }
        try (XmlStreamReader pomReader = ReaderFactory.newXmlReader((File)pomFile);){
            reader = new MavenXpp3Reader();
            generatedModel = ((MavenXpp3Reader)reader).read((Reader)pomReader);
        }
        catch (IOException | XmlPullParserException e) {
            throw new ArchetypeTemplateProcessingException("Error reading POM", e);
        }
        if (parentModel != null) {
            Parent parent = new Parent();
            parent.setGroupId(parentModel.getGroupId());
            if (parent.getGroupId() == null) {
                parent.setGroupId(parentModel.getParent().getGroupId());
            }
            parent.setArtifactId(parentModel.getArtifactId());
            parent.setVersion(parentModel.getVersion());
            if (parent.getVersion() == null) {
                parent.setVersion(parentModel.getParent().getVersion());
            }
            generatedModel.setParent(parent);
            try {
                XmlStreamWriter pomWriter = WriterFactory.newXmlWriter((File)pomFile);
                reader = null;
                try {
                    MavenXpp3Writer writer = new MavenXpp3Writer();
                    writer.write((Writer)pomWriter, generatedModel);
                }
                catch (Throwable writer) {
                    reader = writer;
                    throw writer;
                }
                finally {
                    if (pomWriter != null) {
                        if (reader != null) {
                            try {
                                pomWriter.close();
                            }
                            catch (Throwable writer) {
                                ((Throwable)reader).addSuppressed(writer);
                            }
                        } else {
                            pomWriter.close();
                        }
                    }
                }
            }
            catch (IOException e) {
                throw new ArchetypeTemplateProcessingException("Error rewriting POM", e);
            }
        }
        Build build = generatedModel.getBuild();
        boolean overrideSrcDir = false;
        boolean overrideResourceDir = false;
        boolean overrideTestSrcDir = false;
        boolean overrideTestResourceDir = false;
        boolean bl = foundBuildElement = build != null;
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("********************* Debug info for resources created from generated Model ***********************");
            this.getLogger().debug("Was build element found in generated POM?: " + foundBuildElement);
        }
        if (foundBuildElement && null != build.getSourceDirectory()) {
            this.getLogger().debug("Overriding default source directory ");
            overrideSrcDir = true;
            String srcDirectory = build.getSourceDirectory();
            srcDirectory = StringUtils.replace((String)srcDirectory, (String)"\\", (String)"/");
            FileUtils.mkdir((String)this.getOutputDirectory(outputDirectory, srcDirectory));
        }
        if (foundBuildElement && null != build.getScriptSourceDirectory()) {
            this.getLogger().debug("Overriding default script source directory ");
            String scriptSourceDirectory = build.getScriptSourceDirectory();
            scriptSourceDirectory = StringUtils.replace((String)scriptSourceDirectory, (String)"\\", (String)"/");
            FileUtils.mkdir((String)this.getOutputDirectory(outputDirectory, scriptSourceDirectory));
        }
        if (foundBuildElement && build.getResources().size() > 0) {
            this.getLogger().debug("Overriding default resource directory ");
            overrideResourceDir = true;
            for (Resource resource : build.getResources()) {
                String resourceDirectory = resource.getDirectory();
                resourceDirectory = StringUtils.replace((String)resourceDirectory, (String)"\\", (String)"/");
                FileUtils.mkdir((String)this.getOutputDirectory(outputDirectory, resourceDirectory));
            }
        }
        if (foundBuildElement && null != build.getTestSourceDirectory()) {
            this.getLogger().debug("Overriding default test directory ");
            overrideTestSrcDir = true;
            String testDirectory = build.getTestSourceDirectory();
            testDirectory = StringUtils.replace((String)testDirectory, (String)"\\", (String)"/");
            FileUtils.mkdir((String)this.getOutputDirectory(outputDirectory, testDirectory));
        }
        if (foundBuildElement && build.getTestResources().size() > 0) {
            this.getLogger().debug("Overriding default test resource directory ");
            overrideTestResourceDir = true;
            for (Resource resource : build.getTestResources()) {
                String testResourceDirectory = resource.getDirectory();
                testResourceDirectory = StringUtils.replace((String)testResourceDirectory, (String)"\\", (String)"/");
                FileUtils.mkdir((String)this.getOutputDirectory(outputDirectory, testResourceDirectory));
            }
        }
        this.getLogger().debug("********************* End of debug info from resources from generated POM ***********************");
        if (descriptor.getSources().size() > 0) {
            if (!overrideSrcDir) {
                FileUtils.mkdir((String)(outputDirectory + DEFAULT_SOURCE_DIR));
                this.processSources(outputDirectory, context, descriptor, packageName, DEFAULT_SOURCE_DIR);
            } else {
                this.processSources(outputDirectory, context, descriptor, packageName, build.getSourceDirectory());
            }
        }
        if (descriptor.getResources().size() > 0) {
            if (!overrideResourceDir) {
                FileUtils.mkdir((String)(outputDirectory + DEFAULT_RESOURCE_DIR));
            }
            this.processResources(outputDirectory, context, descriptor, packageName);
        }
        if (descriptor.getTestSources().size() > 0) {
            if (!overrideTestSrcDir) {
                FileUtils.mkdir((String)(outputDirectory + DEFAULT_TEST_SOURCE_DIR));
                this.processTestSources(outputDirectory, context, descriptor, packageName, DEFAULT_TEST_SOURCE_DIR);
            } else {
                this.processTestSources(outputDirectory, context, descriptor, packageName, build.getTestSourceDirectory());
            }
        }
        if (descriptor.getTestResources().size() > 0) {
            if (!overrideTestResourceDir) {
                FileUtils.mkdir((String)(outputDirectory + DEFAULT_TEST_RESOURCE_DIR));
            }
            this.processTestResources(outputDirectory, context, descriptor, packageName);
        }
        if (descriptor.getSiteResources().size() > 0) {
            this.processSiteResources(outputDirectory, context, descriptor, packageName);
        }
    }

    private void processTemplate(String outputDirectory, Context context, String template, TemplateDescriptor descriptor, boolean packageInFileName, String packageName) throws ArchetypeTemplateProcessingException, IOException {
        this.processTemplate(outputDirectory, context, template, descriptor, packageInFileName, packageName, null);
    }

    private String getOutputDirectory(String outputDirectory, String testResourceDirectory) {
        return outputDirectory + (testResourceDirectory.startsWith("/") ? testResourceDirectory : "/" + testResourceDirectory);
    }

    protected void processSources(String outputDirectory, Context context, ArchetypeDescriptor descriptor, String packageName, String sourceDirectory) throws ArchetypeTemplateProcessingException, IOException {
        for (String template : descriptor.getSources()) {
            this.processTemplate(outputDirectory, context, template, descriptor.getSourceDescriptor(template), true, packageName, sourceDirectory);
        }
    }

    protected void processTestSources(String outputDirectory, Context context, ArchetypeDescriptor descriptor, String packageName, String testSourceDirectory) throws ArchetypeTemplateProcessingException, IOException {
        for (String template : descriptor.getTestSources()) {
            this.processTemplate(outputDirectory, context, template, descriptor.getTestSourceDescriptor(template), true, packageName, testSourceDirectory);
        }
    }

    protected void processResources(String outputDirectory, Context context, ArchetypeDescriptor descriptor, String packageName) throws IOException, ArchetypeTemplateProcessingException {
        for (String template : descriptor.getResources()) {
            this.processTemplate(outputDirectory, context, template, descriptor.getResourceDescriptor(template), false, packageName);
        }
    }

    protected void processTestResources(String outputDirectory, Context context, ArchetypeDescriptor descriptor, String packageName) throws IOException, ArchetypeTemplateProcessingException {
        for (String template : descriptor.getTestResources()) {
            this.processTemplate(outputDirectory, context, template, descriptor.getTestResourceDescriptor(template), false, packageName);
        }
    }

    protected void processSiteResources(String outputDirectory, Context context, ArchetypeDescriptor descriptor, String packageName) throws IOException, ArchetypeTemplateProcessingException {
        for (String template : descriptor.getSiteResources()) {
            this.processTemplate(outputDirectory, context, template, descriptor.getSiteResourceDescriptor(template), false, packageName);
        }
    }

    protected void processTemplate(String outputDirectory, Context context, String template, TemplateDescriptor descriptor, boolean packageInFileName, String packageName, String sourceDirectory) throws IOException, ArchetypeTemplateProcessingException {
        block49: {
            Throwable throwable;
            File f;
            template = StringUtils.replace((String)template, (String)"\\", (String)"/");
            if (packageInFileName && packageName != null) {
                String templateFileName = StringUtils.replace((String)template, (String)"/", (String)File.separator);
                String path = packageName.replace('.', '/');
                String filename = FileUtils.filename((String)templateFileName);
                String dirname = FileUtils.dirname((String)templateFileName).replace('\\', '/');
                if ((sourceDirectory = sourceDirectory.replace('\\', '/')).startsWith("/")) {
                    sourceDirectory = sourceDirectory.substring(1);
                }
                if (!dirname.startsWith(sourceDirectory)) {
                    throw new ArchetypeTemplateProcessingException("Template '" + template + "' not in directory '" + sourceDirectory + "'");
                }
                String extraPackages = dirname.substring(sourceDirectory.length());
                if (extraPackages.startsWith("/")) {
                    extraPackages = extraPackages.substring(1);
                }
                if (extraPackages.length() > 0) {
                    path = path + "/" + extraPackages;
                }
                f = new File(new File(new File(outputDirectory, sourceDirectory), path), filename);
            } else {
                f = new File(outputDirectory, template);
            }
            if (!f.getParentFile().exists()) {
                f.getParentFile().mkdirs();
            }
            if (!f.exists() && !f.createNewFile()) {
                this.getLogger().warn("Could not create new file \"" + f.getPath() + "\" or the file already exists.");
            }
            if (descriptor.isFiltered()) {
                try {
                    throwable = null;
                    try (OutputStreamWriter writer = new OutputStreamWriter((OutputStream)new FileOutputStream(f), descriptor.getEncoding());){
                        StringWriter stringWriter = new StringWriter();
                        template = "archetype-resources/" + template;
                        this.velocity.getEngine().mergeTemplate(template, descriptor.getEncoding(), context, stringWriter);
                        writer.write(StringUtils.unifyLineSeparators((String)stringWriter.toString()));
                        break block49;
                    }
                    catch (Throwable stringWriter) {
                        throwable = stringWriter;
                        throw stringWriter;
                    }
                }
                catch (Exception e) {
                    throw new ArchetypeTemplateProcessingException("Error merging velocity templates", e);
                }
            }
            try {
                throwable = null;
                try (InputStream is = this.getStream("archetype-resources/" + template, null);
                     FileOutputStream fos = new FileOutputStream(f);){
                    IOUtil.copy((InputStream)is, (OutputStream)fos);
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
            }
            catch (Exception e) {
                throw new ArchetypeTemplateProcessingException("Error copying file", e);
            }
        }
    }

    protected void createProjectDirectoryStructure(String outputDirectory) {
    }

    private InputStream getStream(String name, ClassLoader loader) {
        if (loader == null) {
            return Thread.currentThread().getContextClassLoader().getResourceAsStream(name);
        }
        return loader.getResourceAsStream(name);
    }
}

