/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.tooling.internal.provider.runner;

import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.Nullable;
import org.gradle.internal.Cast;
import org.gradle.internal.build.event.BuildEventSubscriptions;
import org.gradle.internal.impldep.com.google.common.collect.ImmutableList;
import org.gradle.internal.operations.BuildOperationDescriptor;
import org.gradle.internal.operations.BuildOperationListener;
import org.gradle.internal.operations.OperationFinishEvent;
import org.gradle.internal.operations.OperationIdentifier;
import org.gradle.internal.operations.OperationProgressEvent;
import org.gradle.internal.operations.OperationStartEvent;
import org.gradle.tooling.internal.protocol.events.InternalOperationDescriptor;
import org.gradle.tooling.internal.protocol.events.InternalProgressEvent;
import org.gradle.tooling.internal.provider.runner.BuildOperationMapper;
import org.gradle.tooling.internal.provider.runner.BuildOperationTracker;
import org.gradle.tooling.internal.provider.runner.ProgressEventConsumer;

public class ClientBuildEventGenerator
implements BuildOperationListener {
    private final BuildOperationListener fallback;
    private final List<Mapper> mappers;
    private final List<BuildOperationTracker> trackers;
    private final Map<OperationIdentifier, Operation> running = new ConcurrentHashMap<OperationIdentifier, Operation>();
    private static final Operation DISABLED_OPERATION = new Operation(){

        @Override
        public void generateStartEvent(BuildOperationDescriptor buildOperation, OperationStartEvent startEvent) {
        }

        @Override
        public void progress(OperationProgressEvent progressEvent) {
        }

        @Override
        public void generateFinishEvent(BuildOperationDescriptor buildOperation, OperationFinishEvent finishEvent) {
        }
    };

    public ClientBuildEventGenerator(ProgressEventConsumer progressEventConsumer, BuildEventSubscriptions subscriptions, List<? extends BuildOperationMapper<?, ?>> mappers, BuildOperationListener fallback) {
        this.fallback = fallback;
        ArrayList<Mapper> mapperBuilder = new ArrayList<Mapper>(mappers.size());
        LinkedHashSet<BuildOperationTracker> trackers = new LinkedHashSet<BuildOperationTracker>();
        for (BuildOperationMapper<?, ?> mapper : mappers) {
            if (mapper.isEnabled(subscriptions)) {
                mapperBuilder.add(new Enabled(mapper, progressEventConsumer));
                this.collectTrackers(trackers, mapper.getTrackers());
                continue;
            }
            mapperBuilder.add(new Disabled(mapper));
        }
        this.mappers = ImmutableList.copyOf(mapperBuilder);
        this.trackers = ImmutableList.copyOf(trackers);
    }

    private void collectTrackers(Set<BuildOperationTracker> dest, List<? extends BuildOperationTracker> trackers) {
        for (BuildOperationTracker buildOperationTracker : trackers) {
            if (dest.contains(buildOperationTracker)) continue;
            this.collectTrackers(dest, buildOperationTracker.getTrackers());
            dest.add(buildOperationTracker);
        }
    }

    @Override
    public void started(BuildOperationDescriptor buildOperation, OperationStartEvent startEvent) {
        for (BuildOperationTracker tracker : this.trackers) {
            tracker.started(buildOperation, startEvent);
        }
        for (Mapper mapper : this.mappers) {
            Operation operation = mapper.accept(buildOperation);
            if (operation == null) continue;
            Operation previous = this.running.put(buildOperation.getId(), operation);
            if (previous != null) {
                throw new IllegalStateException("Operation " + buildOperation.getId() + " already started.");
            }
            operation.generateStartEvent(buildOperation, startEvent);
            return;
        }
        this.fallback.started(buildOperation, startEvent);
    }

    @Override
    public void progress(OperationIdentifier operationIdentifier, OperationProgressEvent progressEvent) {
        Operation operation = this.running.get(operationIdentifier);
        if (operation != null) {
            operation.progress(progressEvent);
            return;
        }
        this.fallback.progress(operationIdentifier, progressEvent);
    }

    @Override
    public void finished(BuildOperationDescriptor buildOperation, OperationFinishEvent finishEvent) {
        for (BuildOperationTracker tracker : this.trackers) {
            tracker.finished(buildOperation, finishEvent);
        }
        Operation operation = this.running.remove(buildOperation.getId());
        if (operation != null) {
            operation.generateFinishEvent(buildOperation, finishEvent);
        } else {
            this.fallback.finished(buildOperation, finishEvent);
        }
        for (BuildOperationTracker tracker : this.trackers) {
            tracker.discardState(buildOperation);
        }
    }

    private static class Disabled
    extends Mapper {
        private final Class<?> detailsType;

        public Disabled(BuildOperationMapper<?, ?> mapper) {
            this.detailsType = mapper.getDetailsType();
        }

        @Override
        @Nullable
        public Operation accept(BuildOperationDescriptor buildOperation) {
            if (this.detailsType.isInstance(buildOperation.getDetails())) {
                return DISABLED_OPERATION;
            }
            return null;
        }
    }

    private static class Enabled
    extends Mapper {
        private final BuildOperationMapper<Object, InternalOperationDescriptor> mapper;
        private final ProgressEventConsumer progressEventConsumer;
        private final Class<?> detailsType;

        public Enabled(BuildOperationMapper<?, ?> mapper, ProgressEventConsumer progressEventConsumer) {
            this.mapper = (BuildOperationMapper)Cast.uncheckedCast(mapper);
            this.detailsType = mapper.getDetailsType();
            this.progressEventConsumer = progressEventConsumer;
        }

        @Override
        @Nullable
        public Operation accept(BuildOperationDescriptor buildOperation) {
            if (this.detailsType.isInstance(buildOperation.getDetails())) {
                OperationIdentifier parentId = this.progressEventConsumer.findStartedParentId(buildOperation);
                InternalOperationDescriptor descriptor = this.mapper.createDescriptor(buildOperation.getDetails(), buildOperation, parentId);
                return new EnabledOperation(descriptor, this.mapper, this.progressEventConsumer);
            }
            return null;
        }
    }

    private static abstract class Mapper {
        private Mapper() {
        }

        @Nullable
        public abstract Operation accept(BuildOperationDescriptor var1);
    }

    private static class EnabledOperation
    extends Operation {
        private final InternalOperationDescriptor descriptor;
        private final BuildOperationMapper<Object, InternalOperationDescriptor> mapper;
        private final ProgressEventConsumer progressEventConsumer;

        public EnabledOperation(InternalOperationDescriptor descriptor, BuildOperationMapper<Object, InternalOperationDescriptor> mapper, ProgressEventConsumer progressEventConsumer) {
            this.descriptor = descriptor;
            this.mapper = mapper;
            this.progressEventConsumer = progressEventConsumer;
        }

        @Override
        public void generateStartEvent(BuildOperationDescriptor buildOperation, OperationStartEvent startEvent) {
            this.progressEventConsumer.started(this.mapper.createStartedEvent(this.descriptor, buildOperation.getDetails(), startEvent));
        }

        @Override
        public void progress(OperationProgressEvent progressEvent) {
            InternalProgressEvent mapped = this.mapper.createProgressEvent(this.descriptor, progressEvent);
            if (mapped != null) {
                this.progressEventConsumer.progress(mapped);
            }
        }

        @Override
        public void generateFinishEvent(BuildOperationDescriptor buildOperation, OperationFinishEvent finishEvent) {
            this.progressEventConsumer.finished(this.mapper.createFinishedEvent(this.descriptor, buildOperation.getDetails(), finishEvent));
        }
    }

    private static abstract class Operation {
        private Operation() {
        }

        public abstract void generateStartEvent(BuildOperationDescriptor var1, OperationStartEvent var2);

        public abstract void generateFinishEvent(BuildOperationDescriptor var1, OperationFinishEvent var2);

        public abstract void progress(OperationProgressEvent var1);
    }
}

