/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.language.nativeplatform.internal.incremental;

import java.io.File;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.gradle.api.NonNullApi;
import org.gradle.api.file.EmptyFileVisitor;
import org.gradle.api.file.FileVisitDetails;
import org.gradle.api.internal.file.collections.DirectoryFileTreeFactory;
import org.gradle.internal.impldep.com.google.common.collect.ImmutableSortedSet;
import org.gradle.language.nativeplatform.internal.incremental.HeaderDependenciesCollector;
import org.gradle.language.nativeplatform.internal.incremental.IncrementalCompilation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NonNullApi
public class DefaultHeaderDependenciesCollector
implements HeaderDependenciesCollector {
    private final Logger logger = LoggerFactory.getLogger(DefaultHeaderDependenciesCollector.class);
    private final DirectoryFileTreeFactory directoryFileTreeFactory;

    public DefaultHeaderDependenciesCollector(DirectoryFileTreeFactory directoryFileTreeFactory) {
        this.directoryFileTreeFactory = directoryFileTreeFactory;
    }

    @Override
    public ImmutableSortedSet<File> collectExistingHeaderDependencies(String taskPath, List<File> includeRoots, IncrementalCompilation incrementalCompilation) {
        HashSet<File> headerDependencies = new HashSet<File>();
        if (incrementalCompilation.isUnresolvedHeaders()) {
            this.logger.info("After parsing the source files, Gradle cannot calculate the exact set of include files for '{}'. Every file in the include search path will be considered a header dependency.", (Object)taskPath);
            this.addIncludeRoots(taskPath, includeRoots, headerDependencies);
        } else {
            this.logger.info("Found all include files for '{}'", (Object)taskPath);
            headerDependencies.addAll(incrementalCompilation.getExistingHeaders());
        }
        return ImmutableSortedSet.copyOf(headerDependencies);
    }

    private void addIncludeRoots(String taskPath, List<File> includeRoots, final Set<File> headerDependencies) {
        for (File includeRoot : includeRoots) {
            this.logger.info("adding files in {} to header dependencies for {}", (Object)includeRoot, (Object)taskPath);
            this.directoryFileTreeFactory.create(includeRoot).visit(new EmptyFileVisitor(){

                @Override
                public void visitFile(FileVisitDetails fileDetails) {
                    headerDependencies.add(fileDetails.getFile());
                }
            });
        }
    }
}

