/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.language.base.plugins;

import org.gradle.api.NamedDomainObjectProvider;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.file.DirectoryProperty;
import org.gradle.api.internal.project.ProjectInternal;
import org.gradle.api.tasks.Delete;
import org.gradle.internal.execution.BuildOutputCleanupRegistry;
import org.gradle.language.base.internal.plugins.CleanRule;

public abstract class LifecycleBasePlugin
implements Plugin<Project> {
    public static final String CLEAN_TASK_NAME = "clean";
    public static final String ASSEMBLE_TASK_NAME = "assemble";
    public static final String CHECK_TASK_NAME = "check";
    public static final String BUILD_TASK_NAME = "build";
    public static final String BUILD_GROUP = "build";
    public static final String VERIFICATION_GROUP = "verification";

    @Override
    public void apply(Project project) {
        ProjectInternal projectInternal = (ProjectInternal)project;
        this.addClean(projectInternal);
        this.addCleanRule(project);
        this.addAssemble(project);
        this.addCheck(project);
        this.addBuild(project);
    }

    private void addClean(ProjectInternal project) {
        DirectoryProperty buildDir = project.getLayout().getBuildDirectory();
        BuildOutputCleanupRegistry buildOutputCleanupRegistry = project.getServices().get(BuildOutputCleanupRegistry.class);
        buildOutputCleanupRegistry.registerOutputs(buildDir);
        NamedDomainObjectProvider clean = project.getTasks().register(CLEAN_TASK_NAME, Delete.class, cleanTask -> {
            cleanTask.setDescription("Deletes the build directory.");
            cleanTask.setGroup("build");
            cleanTask.delete(buildDir);
        });
        buildOutputCleanupRegistry.registerOutputs(clean.map(cl -> cl.getTargetFiles()));
    }

    private void addCleanRule(Project project) {
        project.getTasks().addRule(new CleanRule(project.getTasks()));
    }

    private void addAssemble(Project project) {
        project.getTasks().register(ASSEMBLE_TASK_NAME, assembleTask -> {
            assembleTask.setDescription("Assembles the outputs of this project.");
            assembleTask.setGroup("build");
        });
    }

    private void addCheck(Project project) {
        project.getTasks().register(CHECK_TASK_NAME, checkTask -> {
            checkTask.setDescription("Runs all checks.");
            checkTask.setGroup(VERIFICATION_GROUP);
        });
    }

    private void addBuild(Project project) {
        project.getTasks().register("build", buildTask -> {
            buildTask.setDescription("Assembles and tests this project.");
            buildTask.setGroup("build");
            buildTask.dependsOn(ASSEMBLE_TASK_NAME);
            buildTask.dependsOn(CHECK_TASK_NAME);
        });
    }
}

