/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.watch.registry.impl;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import java.util.stream.Stream;
import org.gradle.internal.impldep.com.google.common.primitives.Longs;
import org.gradle.internal.watch.registry.FileWatcherProbeRegistry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultFileWatcherProbeRegistry
implements FileWatcherProbeRegistry {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultFileWatcherProbeRegistry.class);
    private final Map<File, WatchProbe> watchProbesByHierarchy = new ConcurrentHashMap<File, WatchProbe>();
    private final Map<String, WatchProbe> watchProbesByPath = new ConcurrentHashMap<String, WatchProbe>();
    private final Function<File, File> probeLocationResolver;

    public DefaultFileWatcherProbeRegistry(Function<File, File> probeLocationResolver) {
        this.probeLocationResolver = probeLocationResolver;
    }

    @Override
    public void registerProbe(File watchableHierarchy) {
        if (this.watchProbesByHierarchy.containsKey(watchableHierarchy)) {
            return;
        }
        LOGGER.debug("Registering probe for {}", (Object)watchableHierarchy);
        File probeFile = this.probeLocationResolver.apply(watchableHierarchy);
        WatchProbe watchProbe = new WatchProbe(watchableHierarchy, probeFile);
        this.watchProbesByHierarchy.put(watchableHierarchy, watchProbe);
        this.watchProbesByPath.put(probeFile.getAbsolutePath(), watchProbe);
    }

    @Override
    public Stream<File> unprovenHierarchies() {
        return this.watchProbesByHierarchy.values().stream().filter(WatchProbe::leftArmed).map(WatchProbe::getWatchableHierarchy);
    }

    @Override
    public void armWatchProbe(File watchableHierarchy) {
        WatchProbe probe = this.watchProbesByHierarchy.get(watchableHierarchy);
        if (probe != null) {
            try {
                probe.arm();
            }
            catch (IOException e) {
                LOGGER.debug("Could not arm watch probe for hierarchy {}", (Object)watchableHierarchy, (Object)e);
            }
        } else {
            LOGGER.debug("Did not find watchable hierarchy to arm probe for: {}", (Object)watchableHierarchy);
        }
    }

    @Override
    public void disarmWatchProbe(File watchableHierarchy) {
        WatchProbe probe = this.watchProbesByHierarchy.get(watchableHierarchy);
        if (probe != null) {
            probe.disarm();
        } else {
            LOGGER.debug("Did not find watchable hierarchy to disarm probe for: {}", (Object)watchableHierarchy);
        }
    }

    @Override
    public void triggerWatchProbe(String path) {
        WatchProbe probe = this.watchProbesByPath.get(path);
        if (probe != null) {
            LOGGER.debug("Triggering watch probe for {}", (Object)probe.getWatchableHierarchy());
            probe.trigger();
        }
    }

    @Override
    public File getProbeDirectory(File hierarchy) {
        WatchProbe watchProbe = this.watchProbesByHierarchy.get(hierarchy);
        if (watchProbe == null) {
            throw new IllegalStateException("Cannot find probe for hierarchy: " + hierarchy);
        }
        return watchProbe.getProbeFile().getParentFile();
    }

    private static class WatchProbe {
        private final File watchableHierarchy;
        private final File probeFile;
        private State state = State.UNARMED;

        public WatchProbe(File watchableHierarchy, File probeFile) {
            this.watchableHierarchy = watchableHierarchy;
            this.probeFile = probeFile;
        }

        public synchronized void arm() throws IOException {
            switch (this.state) {
                case UNARMED: {
                    this.state = State.ARMED;
                    this.probeFile.getParentFile().mkdirs();
                    try (FileOutputStream out = new FileOutputStream(this.probeFile);){
                        out.write(Longs.toByteArray((long)System.currentTimeMillis()));
                    }
                    LOGGER.debug("Watch probe has been armed for hierarchy: {}", (Object)this.watchableHierarchy);
                    break;
                }
                case ARMED: {
                    LOGGER.debug("Watch probe for hierarchy is already armed: {}", (Object)this.watchableHierarchy);
                    break;
                }
                case TRIGGERED: {
                    LOGGER.debug("Watch probe for hierarchy has already been triggered: {}", (Object)this.watchableHierarchy);
                    break;
                }
                default: {
                    throw new AssertionError();
                }
            }
        }

        public synchronized void disarm() {
            switch (this.state) {
                case UNARMED: {
                    LOGGER.debug("Watch probe has already been disarmed for hierarchy: {}", (Object)this.watchableHierarchy);
                    break;
                }
                case ARMED: {
                    this.state = State.UNARMED;
                    LOGGER.debug("Watch probe has been disarmed for hierarchy: {}", (Object)this.watchableHierarchy);
                    break;
                }
                case TRIGGERED: {
                    LOGGER.debug("Watch probe has already been triggered for hierarchy: {}", (Object)this.watchableHierarchy);
                }
            }
        }

        public synchronized void trigger() {
            if (this.state != State.TRIGGERED) {
                LOGGER.debug("Watch probe in state {} has been triggered for hierarchy: {}", (Object)this.state, (Object)this.watchableHierarchy);
                this.state = State.TRIGGERED;
            }
        }

        public synchronized boolean leftArmed() {
            return this.state == State.ARMED;
        }

        public File getProbeFile() {
            return this.probeFile;
        }

        public File getWatchableHierarchy() {
            return this.watchableHierarchy;
        }

        public static enum State {
            UNARMED,
            ARMED,
            TRIGGERED;

        }
    }
}

