/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.typeconversion;

import java.util.concurrent.TimeUnit;
import org.gradle.api.InvalidUserDataException;
import org.gradle.internal.typeconversion.NormalizedTimeUnit;

public class TimeUnitsParser {
    public NormalizedTimeUnit parseNotation(CharSequence notation, int value) {
        String candidate;
        switch (candidate = notation.toString().toUpperCase()) {
            case "DAYS": {
                return NormalizedTimeUnit.millis(value * 24 * 60 * 60 * 1000);
            }
            case "HOURS": {
                return NormalizedTimeUnit.millis(value * 60 * 60 * 1000);
            }
            case "MINUTES": {
                return NormalizedTimeUnit.millis(value * 60 * 1000);
            }
        }
        try {
            return new NormalizedTimeUnit(value, TimeUnit.valueOf(candidate));
        }
        catch (Exception e) {
            throw new InvalidUserDataException("Unable to parse provided TimeUnit: " + notation, e);
        }
    }
}

