/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.snapshot;

import org.gradle.internal.impldep.com.google.common.annotations.VisibleForTesting;
import org.gradle.internal.snapshot.CaseSensitivity;
import org.gradle.internal.snapshot.PathUtil;

public class VfsRelativePath {
    private final String absolutePath;
    private final int offset;
    public static final String ROOT = "";

    public static VfsRelativePath of(String absolutePath) {
        String normalizedRoot = VfsRelativePath.normalizeRoot(absolutePath);
        return VfsRelativePath.of(normalizedRoot, VfsRelativePath.determineOffset(normalizedRoot));
    }

    @VisibleForTesting
    static VfsRelativePath of(String absolutePath, int offset) {
        return new VfsRelativePath(absolutePath, offset);
    }

    private static String normalizeRoot(String absolutePath) {
        if (absolutePath.isEmpty() || absolutePath.equals("/")) {
            return absolutePath;
        }
        return PathUtil.isFileSeparator(absolutePath.charAt(absolutePath.length() - 1)) ? absolutePath.substring(0, absolutePath.length() - 1) : absolutePath;
    }

    private static int determineOffset(String absolutePath) {
        for (int i = 0; i < absolutePath.length(); ++i) {
            if (PathUtil.isFileSeparator(absolutePath.charAt(i))) continue;
            return i;
        }
        return absolutePath.length();
    }

    private VfsRelativePath(String absolutePath, int offset) {
        this.absolutePath = absolutePath;
        this.offset = offset;
    }

    public VfsRelativePath pathFromChild(String relativeChildPath) {
        return relativeChildPath.isEmpty() ? this : new VfsRelativePath(this.absolutePath, this.offset + relativeChildPath.length() + 1);
    }

    public String pathToChild(String relativeChildPath) {
        return this.isEmpty() ? relativeChildPath : relativeChildPath.substring(this.length() + 1);
    }

    public boolean isEmpty() {
        return this.absolutePath.length() == this.offset;
    }

    int length() {
        return this.absolutePath.length() - this.offset;
    }

    public String getAsString() {
        return this.absolutePath.substring(this.offset);
    }

    public String getAbsolutePath() {
        return this.absolutePath;
    }

    public int lengthOfCommonPrefix(String relativePath, CaseSensitivity caseSensitivity) {
        char charInPath2;
        char charInPath1;
        int pos;
        int lastSeparator = 0;
        int maxPos = Math.min(relativePath.length(), this.absolutePath.length() - this.offset);
        for (pos = 0; pos < maxPos && PathUtil.equalChars(charInPath1 = relativePath.charAt(pos), charInPath2 = this.absolutePath.charAt(pos + this.offset), caseSensitivity); ++pos) {
            if (!PathUtil.isFileSeparator(charInPath1)) continue;
            lastSeparator = pos;
        }
        if (pos == maxPos) {
            if (relativePath.length() == this.absolutePath.length() - this.offset) {
                return pos;
            }
            if (pos < relativePath.length() && PathUtil.isFileSeparator(relativePath.charAt(pos))) {
                return pos;
            }
            if (pos < this.absolutePath.length() - this.offset && PathUtil.isFileSeparator(this.absolutePath.charAt(pos + this.offset))) {
                return pos;
            }
        }
        return lastSeparator;
    }

    public int compareToFirstSegment(String relativePath, CaseSensitivity caseSensitivity) {
        int maxPos = Math.min(relativePath.length(), this.absolutePath.length() - this.offset);
        int accumulatedValue = 0;
        for (int pos = 0; pos < maxPos; ++pos) {
            char charInPath2;
            char charInPath1 = this.absolutePath.charAt(pos + this.offset);
            int comparedChars = PathUtil.compareCharsIgnoringCase(charInPath1, charInPath2 = relativePath.charAt(pos));
            if (comparedChars != 0) {
                return comparedChars;
            }
            accumulatedValue = VfsRelativePath.computeCombinedCompare(accumulatedValue, charInPath1, charInPath2, caseSensitivity == CaseSensitivity.CASE_SENSITIVE);
            if (!PathUtil.isFileSeparator(charInPath1) || pos <= 0) continue;
            return accumulatedValue;
        }
        if (this.absolutePath.length() - this.offset == relativePath.length()) {
            return accumulatedValue;
        }
        if (this.absolutePath.length() - this.offset > relativePath.length()) {
            return PathUtil.isFileSeparator(this.absolutePath.charAt(maxPos + this.offset)) ? accumulatedValue : 1;
        }
        return PathUtil.isFileSeparator(relativePath.charAt(maxPos)) ? accumulatedValue : -1;
    }

    public boolean hasPrefix(String prefix, CaseSensitivity caseSensitivity) {
        return VfsRelativePath.isPrefix(prefix, 0, this.absolutePath, this.offset, caseSensitivity);
    }

    public boolean isPrefixOf(String otherPath, CaseSensitivity caseSensitivity) {
        return VfsRelativePath.isPrefix(this.absolutePath, this.offset, otherPath, 0, caseSensitivity);
    }

    private static boolean isPrefix(String stringEndingInPrefix, int offsetInPrefix, String stringToCheck, int offsetInStringToCheck, CaseSensitivity caseSensitivity) {
        int prefixLength = stringEndingInPrefix.length() - offsetInPrefix;
        if (prefixLength == 0) {
            return true;
        }
        int endOfPrefixInStringToCheck = offsetInStringToCheck + prefixLength;
        if (stringToCheck.length() < endOfPrefixInStringToCheck) {
            return false;
        }
        int i = stringEndingInPrefix.length() - 1;
        int j = endOfPrefixInStringToCheck - 1;
        while (i >= offsetInPrefix) {
            if (!PathUtil.equalChars(stringEndingInPrefix.charAt(i), stringToCheck.charAt(j), caseSensitivity)) {
                return false;
            }
            --i;
            --j;
        }
        return stringToCheck.length() == endOfPrefixInStringToCheck || PathUtil.isFileSeparator(stringToCheck.charAt(endOfPrefixInStringToCheck));
    }

    private static int computeCombinedCompare(int previousCombinedValue, char charInPath1, char charInPath2, boolean caseSensitive) {
        if (!caseSensitive) {
            return 0;
        }
        return previousCombinedValue == 0 ? PathUtil.compareChars(charInPath1, charInPath2) : previousCombinedValue;
    }

    public String toString() {
        return this.getAsString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        VfsRelativePath that = (VfsRelativePath)o;
        if (this.offset != that.offset) {
            return false;
        }
        return this.absolutePath.equals(that.absolutePath);
    }

    public int hashCode() {
        int result2 = this.absolutePath.hashCode();
        result2 = 31 * result2 + this.offset;
        return result2;
    }
}

