/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.reflect;

import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.gradle.api.InvalidUserDataException;
import org.gradle.api.problems.Problem;
import org.gradle.api.problems.Problems;
import org.gradle.api.problems.ReportableProblem;
import org.gradle.internal.exceptions.DefaultMultiCauseException;
import org.gradle.internal.impldep.com.google.common.collect.ImmutableList;
import org.gradle.internal.reflect.ProblemRecordingTypeValidationContext;
import org.gradle.internal.reflect.problems.ValidationProblemId;
import org.gradle.internal.reflect.validation.TypeValidationProblemRenderer;
import org.gradle.model.internal.type.ModelType;

public class DefaultTypeValidationContext
extends ProblemRecordingTypeValidationContext {
    private final boolean reportCacheabilityProblems;
    private final ImmutableList.Builder<Problem> problems = ImmutableList.builder();

    public static DefaultTypeValidationContext withRootType(Class<?> rootType, boolean cacheable) {
        return new DefaultTypeValidationContext(rootType, cacheable);
    }

    public static DefaultTypeValidationContext withoutRootType(Problems problems, boolean reportCacheabilityProblems) {
        return new DefaultTypeValidationContext(null, reportCacheabilityProblems);
    }

    private DefaultTypeValidationContext(@Nullable Class<?> rootType, boolean reportCacheabilityProblems) {
        super(rootType, Optional::empty);
        this.reportCacheabilityProblems = reportCacheabilityProblems;
    }

    @Override
    protected void recordProblem(ReportableProblem problem2) {
        if (ValidationProblemId.onlyAffectsCacheableWork(problem2.getProblemType()) && !this.reportCacheabilityProblems) {
            return;
        }
        this.problems.add((Object)problem2);
    }

    public ImmutableList<Problem> getProblems() {
        return this.problems.build();
    }

    public static void throwOnProblemsOf(Class<?> implementation, ImmutableList<Problem> validationMessages) {
        if (!validationMessages.isEmpty()) {
            String formatString = validationMessages.size() == 1 ? "A problem was found with the configuration of %s." : "Some problems were found with the configuration of %s.";
            throw new DefaultMultiCauseException(String.format(formatString, ModelType.of(implementation).getDisplayName()), (Iterable<? extends Throwable>)validationMessages.stream().map(TypeValidationProblemRenderer::renderMinimalInformationAbout).sorted().map(InvalidUserDataException::new).collect(Collectors.toList()));
        }
    }
}

