/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.jvm.inspection;

import java.util.function.BiConsumer;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.gradle.internal.impldep.com.google.common.annotations.VisibleForTesting;
import org.gradle.internal.jvm.inspection.JvmInstallationMetadata;
import org.gradle.jvm.toolchain.internal.InstallationLocation;

public class InvalidInstallationWarningReporter
implements BiConsumer<InstallationLocation, JvmInstallationMetadata> {
    private final Logger logger;

    public InvalidInstallationWarningReporter() {
        this(Logging.getLogger(InvalidInstallationWarningReporter.class));
    }

    @VisibleForTesting
    public InvalidInstallationWarningReporter(Logger logger) {
        this.logger = logger;
    }

    @Override
    public void accept(InstallationLocation installationLocation, JvmInstallationMetadata metadata) {
        if (!metadata.isValidInstallation()) {
            this.logger.warn("Invalid Java installation found at {}. It will be re-checked in the next build. This might have performance impact if it keeps failing. Run the 'javaToolchains' task for more details.", installationLocation.getDisplayName());
        }
    }
}

