/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.fingerprint.impl;

import java.util.Map;
import org.gradle.internal.file.FileType;
import org.gradle.internal.fingerprint.DirectorySensitivity;
import org.gradle.internal.fingerprint.FileSystemLocationFingerprint;
import org.gradle.internal.fingerprint.FingerprintHashingStrategy;
import org.gradle.internal.fingerprint.hashing.FileSystemLocationSnapshotHasher;
import org.gradle.internal.fingerprint.impl.AbstractDirectorySensitiveFingerprintingStrategy;
import org.gradle.internal.fingerprint.impl.DefaultFileSystemLocationFingerprint;
import org.gradle.internal.fingerprint.impl.IgnoredPathFileSystemLocationFingerprint;
import org.gradle.internal.fingerprint.impl.MissingRootAndDuplicateIgnoringFileSystemSnapshotVisitor;
import org.gradle.internal.hash.HashCode;
import org.gradle.internal.impldep.com.google.common.collect.ImmutableMap;
import org.gradle.internal.snapshot.FileSystemLocationSnapshot;
import org.gradle.internal.snapshot.FileSystemSnapshot;

public class NameOnlyFingerprintingStrategy
extends AbstractDirectorySensitiveFingerprintingStrategy {
    public static final NameOnlyFingerprintingStrategy DEFAULT = new NameOnlyFingerprintingStrategy(DirectorySensitivity.DEFAULT);
    public static final NameOnlyFingerprintingStrategy IGNORE_DIRECTORIES = new NameOnlyFingerprintingStrategy(DirectorySensitivity.IGNORE_DIRECTORIES);
    public static final String IDENTIFIER = "NAME_ONLY";
    private final FileSystemLocationSnapshotHasher normalizedContentHasher;

    public NameOnlyFingerprintingStrategy(DirectorySensitivity directorySensitivity, FileSystemLocationSnapshotHasher normalizedContentHasher) {
        super(IDENTIFIER, directorySensitivity, normalizedContentHasher);
        this.normalizedContentHasher = normalizedContentHasher;
    }

    private NameOnlyFingerprintingStrategy(DirectorySensitivity directorySensitivity) {
        this(directorySensitivity, FileSystemLocationSnapshotHasher.DEFAULT);
    }

    @Override
    public Map<String, FileSystemLocationFingerprint> collectFingerprints(FileSystemSnapshot roots) {
        final ImmutableMap.Builder builder = ImmutableMap.builder();
        roots.accept(new MissingRootAndDuplicateIgnoringFileSystemSnapshotVisitor(){

            @Override
            public void visitAcceptedEntry(FileSystemLocationSnapshot snapshot, boolean isRoot) {
                String absolutePath = snapshot.getAbsolutePath();
                if (NameOnlyFingerprintingStrategy.this.getDirectorySensitivity().shouldFingerprint(snapshot)) {
                    if (isRoot && snapshot.getType() == FileType.Directory) {
                        builder.put((Object)absolutePath, (Object)IgnoredPathFileSystemLocationFingerprint.DIRECTORY);
                    } else {
                        HashCode normalizedContentHash = NameOnlyFingerprintingStrategy.this.getNormalizedContentHash(snapshot, NameOnlyFingerprintingStrategy.this.normalizedContentHasher);
                        if (normalizedContentHash != null) {
                            builder.put((Object)absolutePath, (Object)new DefaultFileSystemLocationFingerprint(snapshot.getName(), snapshot.getType(), normalizedContentHash));
                        }
                    }
                }
            }
        });
        return builder.build();
    }

    @Override
    public FingerprintHashingStrategy getHashingStrategy() {
        return FingerprintHashingStrategy.SORT;
    }
}

