/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.event;

import java.util.Collection;
import org.gradle.api.Action;
import org.gradle.internal.dispatch.Dispatch;
import org.gradle.internal.dispatch.MethodInvocation;
import org.gradle.internal.dispatch.ProxyDispatchAdapter;
import org.gradle.internal.event.BroadcastDispatch;

public class ListenerBroadcast<T>
implements Dispatch<MethodInvocation> {
    private ProxyDispatchAdapter<T> source;
    private BroadcastDispatch<T> broadcast;
    private final Class<T> type;

    public ListenerBroadcast(Class<T> type) {
        this.type = type;
        this.broadcast = BroadcastDispatch.empty(type);
    }

    public T getSource() {
        if (this.source == null) {
            this.source = new ProxyDispatchAdapter<T>(this, this.type, new Class[0]);
        }
        return this.source.getSource();
    }

    public Class<T> getType() {
        return this.type;
    }

    public boolean isEmpty() {
        return this.broadcast.isEmpty();
    }

    public int size() {
        return this.broadcast.size();
    }

    public void add(T listener2) {
        this.broadcast = this.broadcast.add(listener2);
    }

    public void addAll(Collection<? extends T> listeners) {
        this.broadcast = this.broadcast.addAll(listeners);
    }

    public void add(Dispatch<MethodInvocation> dispatch) {
        this.broadcast = this.broadcast.add(dispatch);
    }

    public void add(String methodName, Action<?> action) {
        this.broadcast = this.broadcast.add(methodName, action);
    }

    public void remove(Object listener2) {
        this.broadcast = this.broadcast.remove(listener2);
    }

    public void removeAll(Collection<?> listeners) {
        this.broadcast = this.broadcast.removeAll(listeners);
    }

    public void removeAll() {
        this.broadcast = BroadcastDispatch.empty(this.type);
    }

    @Override
    public void dispatch(MethodInvocation event) {
        this.broadcast.dispatch(event);
    }

    public void visitListeners(Action<T> visitor) {
        this.broadcast.visitListeners(visitor);
    }

    public void visitListenersUntyped(Action<Object> visitor) {
        this.broadcast.visitListenersUntyped(visitor);
    }

    public ListenerBroadcast<T> copy() {
        ListenerBroadcast<T> result2 = new ListenerBroadcast<T>(this.type);
        result2.broadcast = this.broadcast;
        return result2;
    }
}

