/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.component.external.model;

import java.util.Collection;
import java.util.List;
import org.gradle.api.artifacts.ModuleIdentifier;
import org.gradle.api.artifacts.ModuleVersionSelector;
import org.gradle.api.artifacts.VersionConstraint;
import org.gradle.api.artifacts.component.ComponentIdentifier;
import org.gradle.api.artifacts.component.ComponentSelector;
import org.gradle.api.artifacts.component.ModuleComponentIdentifier;
import org.gradle.api.artifacts.component.ModuleComponentSelector;
import org.gradle.api.attributes.AttributeContainer;
import org.gradle.api.capabilities.Capability;
import org.gradle.api.internal.artifacts.ImmutableVersionConstraint;
import org.gradle.api.internal.artifacts.dependencies.DefaultImmutableVersionConstraint;
import org.gradle.api.internal.attributes.AttributeContainerInternal;
import org.gradle.api.internal.attributes.ImmutableAttributes;
import org.gradle.internal.impldep.com.google.common.collect.ImmutableList;

public class DefaultModuleComponentSelector
implements ModuleComponentSelector {
    private final ModuleIdentifier moduleIdentifier;
    private final ImmutableVersionConstraint versionConstraint;
    private final ImmutableAttributes attributes;
    private final ImmutableList<Capability> requestedCapabilities;
    private final int hashCode;

    private DefaultModuleComponentSelector(ModuleIdentifier module, ImmutableVersionConstraint version, ImmutableAttributes attributes, ImmutableList<Capability> requestedCapabilities) {
        assert (module != null) : "module cannot be null";
        assert (version != null) : "version cannot be null";
        assert (attributes != null) : "attributes cannot be null";
        assert (requestedCapabilities != null) : "capabilities cannot be null";
        this.moduleIdentifier = module;
        this.versionConstraint = version;
        this.attributes = attributes;
        this.requestedCapabilities = requestedCapabilities;
        this.hashCode = this.computeHashcode(module, version, attributes, requestedCapabilities);
    }

    private int computeHashcode(ModuleIdentifier module, ImmutableVersionConstraint version, ImmutableAttributes attributes, ImmutableList<Capability> requestedCapabilities) {
        int hashCode = version.hashCode();
        hashCode = 31 * hashCode + module.hashCode();
        hashCode = 31 * hashCode + attributes.hashCode();
        hashCode = 31 * hashCode + requestedCapabilities.hashCode();
        return hashCode;
    }

    @Override
    public String getDisplayName() {
        String group = this.moduleIdentifier.getGroup();
        String module = this.moduleIdentifier.getName();
        StringBuilder builder = new StringBuilder(group.length() + module.length() + this.versionConstraint.getRequiredVersion().length() + 2);
        builder.append(group);
        builder.append(":");
        builder.append(module);
        String versionString = this.versionConstraint.getDisplayName();
        if (versionString.length() > 0) {
            builder.append(":");
            builder.append(versionString);
        }
        return builder.toString();
    }

    @Override
    public String getGroup() {
        return this.moduleIdentifier.getGroup();
    }

    @Override
    public String getModule() {
        return this.moduleIdentifier.getName();
    }

    @Override
    public String getVersion() {
        return this.versionConstraint.getRequiredVersion();
    }

    @Override
    public VersionConstraint getVersionConstraint() {
        return this.versionConstraint;
    }

    @Override
    public ModuleIdentifier getModuleIdentifier() {
        return this.moduleIdentifier;
    }

    @Override
    public List<Capability> getRequestedCapabilities() {
        return this.requestedCapabilities;
    }

    @Override
    public AttributeContainer getAttributes() {
        return this.attributes;
    }

    @Override
    public boolean matchesStrictly(ComponentIdentifier identifier) {
        assert (identifier != null) : "identifier cannot be null";
        if (identifier instanceof ModuleComponentIdentifier) {
            ModuleComponentIdentifier moduleComponentIdentifier = (ModuleComponentIdentifier)identifier;
            return this.moduleIdentifier.getName().equals(moduleComponentIdentifier.getModule()) && this.moduleIdentifier.getGroup().equals(moduleComponentIdentifier.getGroup()) && this.getVersion().equals(moduleComponentIdentifier.getVersion());
        }
        return false;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DefaultModuleComponentSelector that = (DefaultModuleComponentSelector)o;
        if (this.hashCode != that.hashCode) {
            return false;
        }
        if (!this.moduleIdentifier.equals(that.moduleIdentifier)) {
            return false;
        }
        if (!this.versionConstraint.equals(that.versionConstraint)) {
            return false;
        }
        if (!this.attributes.equals(that.attributes)) {
            return false;
        }
        return this.requestedCapabilities.equals(that.requestedCapabilities);
    }

    public int hashCode() {
        return this.hashCode;
    }

    public String toString() {
        return this.getDisplayName();
    }

    public static ModuleComponentSelector newSelector(ModuleIdentifier id, VersionConstraint version, AttributeContainer attributes, Collection<Capability> requestedCapabilities) {
        assert (attributes != null) : "attributes cannot be null";
        assert (version != null) : "version cannot be null";
        assert (requestedCapabilities != null) : "capabilities cannot be null";
        DefaultModuleComponentSelector.assertModuleIdentifier(id);
        return new DefaultModuleComponentSelector(id, DefaultImmutableVersionConstraint.of(version), ((AttributeContainerInternal)attributes).asImmutable(), (ImmutableList<Capability>)ImmutableList.copyOf(requestedCapabilities));
    }

    private static void assertModuleIdentifier(ModuleIdentifier id) {
        assert (id.getGroup() != null) : "group cannot be null";
        assert (id.getName() != null) : "name cannot be null";
    }

    public static ModuleComponentSelector newSelector(ModuleIdentifier id, VersionConstraint version) {
        assert (version != null) : "version cannot be null";
        DefaultModuleComponentSelector.assertModuleIdentifier(id);
        return new DefaultModuleComponentSelector(id, DefaultImmutableVersionConstraint.of(version), ImmutableAttributes.EMPTY, (ImmutableList<Capability>)ImmutableList.of());
    }

    public static ModuleComponentSelector newSelector(ModuleIdentifier id, String version) {
        DefaultModuleComponentSelector.assertModuleIdentifier(id);
        return new DefaultModuleComponentSelector(id, DefaultImmutableVersionConstraint.of(version), ImmutableAttributes.EMPTY, (ImmutableList<Capability>)ImmutableList.of());
    }

    public static ModuleComponentSelector newSelector(ModuleVersionSelector selector) {
        return new DefaultModuleComponentSelector(selector.getModule(), DefaultImmutableVersionConstraint.of(selector.getVersion()), ImmutableAttributes.EMPTY, (ImmutableList<Capability>)ImmutableList.of());
    }

    public static ModuleComponentSelector withAttributes(ModuleComponentSelector selector, ImmutableAttributes attributes) {
        DefaultModuleComponentSelector cs = (DefaultModuleComponentSelector)selector;
        return new DefaultModuleComponentSelector(cs.moduleIdentifier, cs.versionConstraint, attributes, cs.requestedCapabilities);
    }

    public static ComponentSelector withCapabilities(ModuleComponentSelector selector, List<Capability> requestedCapabilities) {
        DefaultModuleComponentSelector cs = (DefaultModuleComponentSelector)selector;
        return new DefaultModuleComponentSelector(cs.moduleIdentifier, cs.versionConstraint, cs.attributes, (ImmutableList<Capability>)ImmutableList.copyOf(requestedCapabilities));
    }
}

