/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.cleanup;

import java.io.File;
import java.util.LinkedHashSet;
import java.util.Set;
import org.gradle.api.GradleException;
import org.gradle.api.file.FileCollection;
import org.gradle.api.internal.file.FileCollectionFactory;
import org.gradle.api.internal.project.HoldsProjectState;
import org.gradle.internal.execution.BuildOutputCleanupRegistry;
import org.gradle.internal.impldep.com.google.common.collect.Sets;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultBuildOutputCleanupRegistry
implements BuildOutputCleanupRegistry,
HoldsProjectState {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultBuildOutputCleanupRegistry.class);
    private final Object lock = new Object();
    private final FileCollectionFactory fileCollectionFactory;
    private final Set<FileCollection> outputs = Sets.newHashSet();
    private Set<String> resolvedPaths;

    public DefaultBuildOutputCleanupRegistry(FileCollectionFactory fileCollectionFactory) {
        this.fileCollectionFactory = fileCollectionFactory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void registerOutputs(Object files) {
        Object object = this.lock;
        synchronized (object) {
            if (this.resolvedPaths != null) {
                LOGGER.debug("More outputs are being registered even though the build output cleanup registry has already been finalized. New outputs: {}", files);
            } else {
                this.outputs.add(this.fileCollectionFactory.resolving(files));
            }
        }
    }

    @Override
    public boolean isOutputOwnedByBuild(File file) {
        Set<String> safeToDelete = this.getResolvedPaths();
        for (File absoluteFile = file.getAbsoluteFile(); absoluteFile != null; absoluteFile = absoluteFile.getParentFile()) {
            if (!safeToDelete.contains(absoluteFile.getPath())) continue;
            return true;
        }
        return false;
    }

    @Override
    public void resolveOutputs() {
        if (this.resolvedPaths == null) {
            LinkedHashSet<String> result2 = new LinkedHashSet<String>();
            for (FileCollection output : this.outputs) {
                for (File file : output) {
                    result2.add(file.getAbsolutePath());
                }
            }
            this.resolvedPaths = result2;
        }
    }

    @Override
    public Set<FileCollection> getRegisteredOutputs() {
        return this.outputs;
    }

    private Set<String> getResolvedPaths() {
        if (this.resolvedPaths == null) {
            throw new GradleException("Build outputs have not been resolved yet");
        }
        return this.resolvedPaths;
    }

    @Override
    public void discardAll() {
        this.resolvedPaths = null;
        this.outputs.clear();
    }
}

