/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.classpath.types;

import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.Set;
import java.util.function.BiConsumer;
import org.gradle.internal.classpath.types.InstrumentingTypeRegistry;
import org.gradle.internal.hash.HashCode;
import org.gradle.internal.impldep.com.google.common.collect.ImmutableMap;
import org.gradle.internal.impldep.com.google.common.collect.ImmutableSet;
import org.gradle.internal.impldep.org.apache.commons.io.IOUtils;
import org.gradle.internal.lazy.Lazy;

public class GradleCoreInstrumentingTypeRegistry
implements InstrumentingTypeRegistry {
    private static final String RESOURCE_FILE = "/instrumented-super-types.properties";
    private static final String HASH_FILE = "/instrumented-super-types-hash.txt";
    private static final Lazy<Map<String, Set<String>>> INSTRUMENTED_SUPER_TYPES = Lazy.locking().of(GradleCoreInstrumentingTypeRegistry::loadInstrumentedSuperTypes);
    private static final Lazy<Optional<HashCode>> INSTRUMENTED_HASH_CODE = Lazy.locking().of(GradleCoreInstrumentingTypeRegistry::loadInstrumentedSuperTypesHash);

    @Override
    public Set<String> getSuperTypes(String type) {
        return ((Map)INSTRUMENTED_SUPER_TYPES.get()).getOrDefault(type, Collections.emptySet());
    }

    @Override
    public boolean isEmpty() {
        return ((Map)INSTRUMENTED_SUPER_TYPES.get()).isEmpty();
    }

    public Optional<HashCode> getInstrumentedFileHash() {
        return (Optional)INSTRUMENTED_HASH_CODE.get();
    }

    private static Map<String, Set<String>> loadInstrumentedSuperTypes() {
        ImmutableMap immutableMap;
        block8: {
            InputStream stream = GradleCoreInstrumentingTypeRegistry.class.getResourceAsStream(RESOURCE_FILE);
            try {
                Properties properties = new Properties();
                properties.load(stream);
                ImmutableMap.Builder builder = ImmutableMap.builder();
                properties.forEach((BiConsumer<? super Object, ? super Object>)((BiConsumer<Object, Object>)(k, v) -> builder.put((Object)((String)k), (Object)ImmutableSet.copyOf((Object[])v.toString().split(",")))));
                immutableMap = builder.build();
                if (stream == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (stream != null) {
                        try {
                            stream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new UncheckedIOException(e);
                }
            }
            stream.close();
        }
        return immutableMap;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static Optional<HashCode> loadInstrumentedSuperTypesHash() {
        try (InputStream stream = GradleCoreInstrumentingTypeRegistry.class.getResourceAsStream(HASH_FILE);){
            byte[] bytes = IOUtils.toByteArray((InputStream)stream);
            if (bytes.length == 0) {
                Optional<HashCode> optional2 = Optional.empty();
                return optional2;
            }
            Optional<HashCode> optional = Optional.of(HashCode.fromBytes(bytes));
            return optional;
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }
}

