/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.initialization;

import java.io.File;
import java.util.List;
import org.gradle.StartParameter;
import org.gradle.api.GradleException;
import org.gradle.api.initialization.ProjectDescriptor;
import org.gradle.api.internal.GradleInternal;
import org.gradle.api.internal.SettingsInternal;
import org.gradle.api.internal.StartParameterInternal;
import org.gradle.api.internal.initialization.ClassLoaderScope;
import org.gradle.configuration.project.BuiltInCommand;
import org.gradle.initialization.ProjectSpec;
import org.gradle.initialization.ProjectSpecs;
import org.gradle.initialization.SettingsLoader;
import org.gradle.initialization.SettingsLocation;
import org.gradle.initialization.SettingsProcessor;
import org.gradle.initialization.SettingsState;
import org.gradle.initialization.buildsrc.BuildSrcDetector;
import org.gradle.initialization.layout.BuildLayout;
import org.gradle.initialization.layout.BuildLayoutConfiguration;
import org.gradle.initialization.layout.BuildLayoutFactory;
import org.gradle.internal.deprecation.DeprecationLogger;
import org.gradle.util.Path;

public class DefaultSettingsLoader
implements SettingsLoader {
    public static final String BUILD_SRC_PROJECT_PATH = ":buildSrc";
    private final SettingsProcessor settingsProcessor;
    private final BuildLayoutFactory buildLayoutFactory;
    private final List<BuiltInCommand> builtInCommands;

    public DefaultSettingsLoader(SettingsProcessor settingsProcessor, BuildLayoutFactory buildLayoutFactory, List<BuiltInCommand> builtInCommands) {
        this.settingsProcessor = settingsProcessor;
        this.buildLayoutFactory = buildLayoutFactory;
        this.builtInCommands = builtInCommands;
    }

    @Override
    public SettingsState findAndLoadSettings(GradleInternal gradle) {
        BuildLayout settingsLocation;
        SettingsState state;
        SettingsInternal settings;
        StartParameterInternal startParameter = gradle.getStartParameter();
        ProjectSpec spec = ProjectSpecs.forStartParameter(startParameter, settings = (state = this.findSettingsAndLoadIfAppropriate(gradle, startParameter, settingsLocation = this.buildLayoutFactory.getLayoutFor(new BuildLayoutConfiguration(startParameter)), gradle.getClassLoaderScope())).getSettings());
        if (this.useEmptySettings(spec, settings, startParameter)) {
            state.close();
            state = this.createEmptySettings(gradle, startParameter, settings.getClassLoaderScope());
            settings = state.getSettings();
        }
        this.setDefaultProject(spec, settings);
        return state;
    }

    private boolean useEmptySettings(ProjectSpec spec, SettingsInternal loadedSettings, StartParameter startParameter) {
        File customSettingsFile = DeprecationLogger.whileDisabled(startParameter::getSettingsFile);
        if (customSettingsFile != null) {
            return false;
        }
        if (spec.containsProject(loadedSettings.getProjectRegistry())) {
            return false;
        }
        for (BuiltInCommand command : this.builtInCommands) {
            if (!command.commandLineMatches(startParameter.getTaskNames())) continue;
            return true;
        }
        if (startParameter.getProjectDir() != null && startParameter.getProjectDir().getName().equals("buildSrc") && BuildSrcDetector.isValidBuildSrcBuild(startParameter.getProjectDir())) {
            return true;
        }
        return startParameter.getProjectDir() != null && loadedSettings.getSettingsDir().equals(startParameter.getProjectDir());
    }

    private SettingsState createEmptySettings(GradleInternal gradle, StartParameter startParameter, ClassLoaderScope classLoaderScope) {
        StartParameterInternal noSearchParameter = (StartParameterInternal)startParameter.newInstance();
        DeprecationLogger.whileDisabled(() -> noSearchParameter.setSettingsFile(null));
        noSearchParameter.useEmptySettings();
        noSearchParameter.doNotSearchUpwards();
        BuildLayout layout2 = this.buildLayoutFactory.getLayoutFor(new BuildLayoutConfiguration(noSearchParameter));
        SettingsState state = this.findSettingsAndLoadIfAppropriate(gradle, noSearchParameter, layout2, classLoaderScope);
        File customBuildFile = DeprecationLogger.whileDisabled(noSearchParameter::getBuildFile);
        if (customBuildFile != null) {
            ProjectDescriptor rootProject = state.getSettings().getRootProject();
            rootProject.setBuildFileName(customBuildFile.getName());
        }
        return state;
    }

    private void setDefaultProject(ProjectSpec spec, SettingsInternal settings) {
        settings.setDefaultProject(spec.selectProject(settings.getSettingsScript().getDisplayName(), settings.getProjectRegistry()));
    }

    private SettingsState findSettingsAndLoadIfAppropriate(GradleInternal gradle, StartParameter startParameter, SettingsLocation settingsLocation, ClassLoaderScope classLoaderScope) {
        SettingsState state = this.settingsProcessor.process(gradle, settingsLocation, classLoaderScope, startParameter);
        this.validate(state.getSettings());
        return state;
    }

    private void validate(SettingsInternal settings) {
        settings.getProjectRegistry().getAllProjects().forEach(project -> {
            if (project.getPath().equals(BUILD_SRC_PROJECT_PATH)) {
                Path buildPath = settings.getGradle().getIdentityPath();
                String suffix = buildPath == Path.ROOT ? "" : " (in build " + buildPath + ")";
                throw new GradleException("'buildSrc' cannot be used as a project name as it is a reserved name" + suffix);
            }
        });
    }
}

