/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.tasks.testing;

import java.io.File;
import java.util.LinkedList;
import javax.inject.Inject;
import org.gradle.api.DefaultTask;
import org.gradle.api.file.ConfigurableFileCollection;
import org.gradle.api.file.Directory;
import org.gradle.api.file.DirectoryProperty;
import org.gradle.api.internal.tasks.testing.junit.result.AggregateTestResultsProvider;
import org.gradle.api.internal.tasks.testing.junit.result.BinaryResultBackedTestResultsProvider;
import org.gradle.api.internal.tasks.testing.junit.result.TestResultsProvider;
import org.gradle.api.internal.tasks.testing.report.DefaultTestReport;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.model.ReplacedBy;
import org.gradle.api.tasks.IgnoreEmptyDirectories;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.OutputDirectory;
import org.gradle.api.tasks.PathSensitive;
import org.gradle.api.tasks.PathSensitivity;
import org.gradle.api.tasks.SkipWhenEmpty;
import org.gradle.api.tasks.TaskAction;
import org.gradle.api.tasks.testing.Test;
import org.gradle.internal.concurrent.CompositeStoppable;
import org.gradle.internal.deprecation.DeprecationLogger;
import org.gradle.internal.deprecation.DeprecationMessageBuilder;
import org.gradle.internal.operations.BuildOperationExecutor;
import org.gradle.util.internal.CollectionUtils;
import org.gradle.work.DisableCachingByDefault;

@DisableCachingByDefault(because="Not made cacheable, yet")
public abstract class TestReport
extends DefaultTask {
    private final DirectoryProperty destinationDir = this.getObjectFactory().directoryProperty();
    private final ConfigurableFileCollection resultDirs = this.getObjectFactory().fileCollection();

    @Inject
    protected BuildOperationExecutor getBuildOperationExecutor() {
        throw new UnsupportedOperationException();
    }

    @Inject
    protected ObjectFactory getObjectFactory() {
        throw new UnsupportedOperationException();
    }

    @ReplacedBy(value="destinationDirectory")
    @Deprecated
    public File getDestinationDir() {
        ((DeprecationMessageBuilder.DeprecateProperty)DeprecationLogger.deprecateProperty(TestReport.class, "destinationDir").replaceWith("destinationDirectory")).willBeRemovedInGradle9().withDslReference().nagUser();
        return ((Directory)this.getDestinationDirectory().get()).getAsFile();
    }

    @Deprecated
    public void setDestinationDir(File destinationDir) {
        ((DeprecationMessageBuilder.DeprecateProperty)DeprecationLogger.deprecateProperty(TestReport.class, "destinationDir").replaceWith("destinationDirectory")).willBeRemovedInGradle9().withDslReference().nagUser();
        this.getDestinationDirectory().set(destinationDir);
    }

    @OutputDirectory
    public DirectoryProperty getDestinationDirectory() {
        return this.destinationDir;
    }

    @InputFiles
    @SkipWhenEmpty
    @IgnoreEmptyDirectories
    @PathSensitive(value=PathSensitivity.NONE)
    public ConfigurableFileCollection getTestResults() {
        return this.resultDirs;
    }

    private void addTo(Object result2, ConfigurableFileCollection dirs) {
        if (result2 instanceof Test) {
            Test test = (Test)result2;
            dirs.from(test.getBinaryResultsDirectory());
        } else if (result2 instanceof Iterable) {
            Iterable iterable = (Iterable)result2;
            for (Object nested : iterable) {
                this.addTo(nested, dirs);
            }
        } else {
            dirs.from(result2);
        }
    }

    @Deprecated
    public void reportOn(Object ... results) {
        ((DeprecationMessageBuilder.WithDocumentation)((DeprecationMessageBuilder.DeprecateMethod)((DeprecationMessageBuilder.DeprecateMethod)DeprecationLogger.deprecateMethod(TestReport.class, "reportOn(Object...)").replaceWith("testResults")).withAdvice("invoke getTestResults().from(Object...) instead, passing references to Test#getBinaryResultsDirectory() as arguments.")).willBeRemovedInGradle9().withDslReference(TestReport.class, "testResults")).nagUser();
        for (Object result2 : results) {
            this.addTo(result2, this.getTestResults());
        }
    }

    @TaskAction
    void generateReport() {
        TestResultsProvider resultsProvider;
        block3: {
            resultsProvider = this.createAggregateProvider();
            try {
                if (resultsProvider.isHasResults()) {
                    DefaultTestReport testReport = new DefaultTestReport(this.getBuildOperationExecutor());
                    testReport.generateReport(resultsProvider, ((Directory)this.getDestinationDirectory().get()).getAsFile());
                    break block3;
                }
                this.getLogger().info("{} - no binary test results found in dirs: {}.", this.getPath(), this.getTestResults().getFiles());
                this.setDidWork(false);
            }
            catch (Throwable throwable) {
                CompositeStoppable.stoppable(resultsProvider).stop();
                throw throwable;
            }
        }
        CompositeStoppable.stoppable(resultsProvider).stop();
    }

    private TestResultsProvider createAggregateProvider() {
        LinkedList resultsProviders = new LinkedList();
        try {
            ConfigurableFileCollection resultDirs = this.getTestResults();
            if (resultDirs.getFiles().size() == 1) {
                return new BinaryResultBackedTestResultsProvider(resultDirs.getSingleFile());
            }
            return new AggregateTestResultsProvider(CollectionUtils.collect(resultDirs, resultsProviders, BinaryResultBackedTestResultsProvider::new));
        }
        catch (RuntimeException e) {
            CompositeStoppable.stoppable(resultsProviders).stop();
            throw e;
        }
    }
}

