/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.plugins.internal;

import java.util.ArrayList;
import javax.inject.Inject;
import org.gradle.api.Project;
import org.gradle.api.file.CopySpec;
import org.gradle.api.plugins.ApplicationPluginConvention;
import org.gradle.api.reflect.HasPublicType;
import org.gradle.api.reflect.TypeOf;
import org.gradle.internal.deprecation.DeprecationLogger;
import org.gradle.internal.deprecation.DeprecationMessageBuilder;

public abstract class DefaultApplicationPluginConvention
extends ApplicationPluginConvention
implements HasPublicType {
    private String applicationName;
    private String mainClassName;
    private Iterable<String> applicationDefaultJvmArgs = new ArrayList<String>();
    private String executableDir = "bin";
    private CopySpec applicationDistribution;
    private final Project project;

    @Inject
    public DefaultApplicationPluginConvention(Project project) {
        this.project = project;
        this.applicationDistribution = project.copySpec();
    }

    @Override
    public TypeOf<?> getPublicType() {
        return TypeOf.typeOf(ApplicationPluginConvention.class);
    }

    @Override
    public String getApplicationName() {
        DefaultApplicationPluginConvention.logDeprecation();
        return this.applicationName;
    }

    @Override
    public void setApplicationName(String applicationName) {
        DefaultApplicationPluginConvention.logDeprecation();
        this.applicationName = applicationName;
    }

    @Override
    public String getMainClassName() {
        DefaultApplicationPluginConvention.logDeprecation();
        return this.mainClassName;
    }

    @Override
    public void setMainClassName(String mainClassName) {
        DefaultApplicationPluginConvention.logDeprecation();
        this.mainClassName = mainClassName;
    }

    @Override
    public Iterable<String> getApplicationDefaultJvmArgs() {
        DefaultApplicationPluginConvention.logDeprecation();
        return this.applicationDefaultJvmArgs;
    }

    @Override
    public void setApplicationDefaultJvmArgs(Iterable<String> applicationDefaultJvmArgs) {
        DefaultApplicationPluginConvention.logDeprecation();
        this.applicationDefaultJvmArgs = applicationDefaultJvmArgs;
    }

    @Override
    public String getExecutableDir() {
        DefaultApplicationPluginConvention.logDeprecation();
        return this.executableDir;
    }

    @Override
    public void setExecutableDir(String executableDir) {
        DefaultApplicationPluginConvention.logDeprecation();
        this.executableDir = executableDir;
    }

    @Override
    public CopySpec getApplicationDistribution() {
        DefaultApplicationPluginConvention.logDeprecation();
        return this.applicationDistribution;
    }

    @Override
    public void setApplicationDistribution(CopySpec applicationDistribution) {
        DefaultApplicationPluginConvention.logDeprecation();
        this.applicationDistribution = applicationDistribution;
    }

    @Override
    public Project getProject() {
        DefaultApplicationPluginConvention.logDeprecation();
        return this.project;
    }

    private static void logDeprecation() {
        ((DeprecationMessageBuilder.WithDocumentation)DeprecationLogger.deprecateType(ApplicationPluginConvention.class).willBeRemovedInGradle9().withUpgradeGuideSection(8, "application_convention_deprecation")).nagUser();
    }
}

