/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.plugins;

import javax.inject.Inject;
import org.gradle.api.NamedDomainObjectProvider;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.artifacts.ConfigurationContainer;
import org.gradle.api.attributes.LibraryElements;
import org.gradle.api.file.ConfigurableFileCollection;
import org.gradle.api.file.FileCollection;
import org.gradle.api.file.SourceDirectorySet;
import org.gradle.api.internal.classpath.ModuleRegistry;
import org.gradle.api.internal.lambdas.SerializableLambdas;
import org.gradle.api.internal.plugins.DslObject;
import org.gradle.api.internal.tasks.DefaultGroovySourceSet;
import org.gradle.api.internal.tasks.DefaultSourceSet;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.plugins.ExtensionAware;
import org.gradle.api.plugins.JavaBasePlugin;
import org.gradle.api.plugins.JavaPluginExtension;
import org.gradle.api.plugins.internal.JvmPluginsHelper;
import org.gradle.api.plugins.jvm.internal.JvmLanguageUtilities;
import org.gradle.api.provider.Provider;
import org.gradle.api.reporting.ReportingExtension;
import org.gradle.api.tasks.GroovyRuntime;
import org.gradle.api.tasks.GroovySourceDirectorySet;
import org.gradle.api.tasks.SourceSet;
import org.gradle.api.tasks.TaskProvider;
import org.gradle.api.tasks.compile.AbstractCompile;
import org.gradle.api.tasks.compile.GroovyCompile;
import org.gradle.api.tasks.javadoc.Groovydoc;
import org.gradle.api.tasks.javadoc.GroovydocAccess;
import org.gradle.internal.deprecation.DeprecationLogger;
import org.gradle.internal.impldep.com.google.common.collect.Sets;
import org.gradle.jvm.toolchain.JavaLauncher;
import org.gradle.jvm.toolchain.JavaToolchainService;

public abstract class GroovyBasePlugin
implements Plugin<Project> {
    public static final String GROOVY_RUNTIME_EXTENSION_NAME = "groovyRuntime";
    private final ObjectFactory objectFactory;
    private final ModuleRegistry moduleRegistry;
    private final JvmLanguageUtilities jvmLanguageUtils;

    @Inject
    public GroovyBasePlugin(ObjectFactory objectFactory, ModuleRegistry moduleRegistry, JvmLanguageUtilities jvmPluginServices) {
        this.objectFactory = objectFactory;
        this.moduleRegistry = moduleRegistry;
        this.jvmLanguageUtils = jvmPluginServices;
    }

    @Override
    public void apply(Project project) {
        project.getPluginManager().apply(JavaBasePlugin.class);
        GroovyRuntime groovyRuntime = project.getExtensions().create(GROOVY_RUNTIME_EXTENSION_NAME, GroovyRuntime.class, project);
        GroovyBasePlugin.configureCompileDefaults(project, groovyRuntime);
        this.configureSourceSetDefaults(project);
        this.configureGroovydoc(project, groovyRuntime);
    }

    private static void configureCompileDefaults(Project project, GroovyRuntime groovyRuntime) {
        project.getTasks().withType(GroovyCompile.class).configureEach(compile -> compile.getConventionMapping().map("groovyClasspath", () -> groovyRuntime.inferGroovyClasspath(compile.getClasspath())));
    }

    private void configureSourceSetDefaults(Project project) {
        GroovyBasePlugin.javaPluginExtension(project).getSourceSets().all(sourceSet -> {
            GroovySourceDirectorySet groovySource = this.getGroovySourceDirectorySet((SourceSet)sourceSet);
            sourceSet.getExtensions().add(GroovySourceDirectorySet.class, "groovy", groovySource);
            groovySource.srcDir("src/" + sourceSet.getName() + "/groovy");
            GroovySourceDirectorySet groovySourceFiles = groovySource;
            sourceSet.getResources().getFilter().exclude(SerializableLambdas.spec(element -> groovySourceFiles.contains(element.getFile())));
            sourceSet.getAllJava().source(groovySource);
            sourceSet.getAllSource().source(groovySource);
            TaskProvider<GroovyCompile> compileTask = this.createGroovyCompileTask(project, (SourceSet)sourceSet, groovySource);
            ConfigurationContainer configurations = project.getConfigurations();
            GroovyBasePlugin.configureLibraryElements(sourceSet, configurations, project.getObjects());
            this.configureTargetPlatform(compileTask, (SourceSet)sourceSet, configurations);
        });
    }

    private GroovySourceDirectorySet getGroovySourceDirectorySet(SourceSet sourceSet) {
        DefaultGroovySourceSet groovySourceSet = this.objectFactory.newInstance(DefaultGroovySourceSet.class, "groovy", ((DefaultSourceSet)sourceSet).getDisplayName(), this.objectFactory);
        DeprecationLogger.whileDisabled(() -> new DslObject(sourceSet).getConvention().getPlugins().put("groovy", groovySourceSet));
        return groovySourceSet.getGroovy();
    }

    private static void configureLibraryElements(SourceSet sourceSet, ConfigurationContainer configurations, ObjectFactory objectFactory) {
        configurations.getByName(sourceSet.getCompileClasspathConfigurationName()).attributes(attrs -> attrs.attribute(LibraryElements.LIBRARY_ELEMENTS_ATTRIBUTE, objectFactory.named(LibraryElements.class, "classes+resources")));
    }

    private void configureTargetPlatform(TaskProvider<GroovyCompile> compileTask, SourceSet sourceSet, ConfigurationContainer configurations) {
        this.jvmLanguageUtils.useDefaultTargetPlatformInference(configurations.getByName(sourceSet.getCompileClasspathConfigurationName()), compileTask);
        this.jvmLanguageUtils.useDefaultTargetPlatformInference(configurations.getByName(sourceSet.getRuntimeClasspathConfigurationName()), compileTask);
    }

    private TaskProvider<GroovyCompile> createGroovyCompileTask(Project project, SourceSet sourceSet, GroovySourceDirectorySet groovySource) {
        NamedDomainObjectProvider compileTask = project.getTasks().register(sourceSet.getCompileTaskName("groovy"), GroovyCompile.class, groovyCompile -> {
            JvmPluginsHelper.compileAgainstJavaOutputs(groovyCompile, sourceSet, this.objectFactory);
            JvmPluginsHelper.configureAnnotationProcessorPath(sourceSet, groovySource, groovyCompile.getOptions(), project);
            groovyCompile.setDescription("Compiles the " + groovySource + ".");
            groovyCompile.setSource(groovySource);
            groovyCompile.getJavaLauncher().convention(GroovyBasePlugin.getJavaLauncher(project));
            groovyCompile.getGroovyOptions().getDisabledGlobalASTTransformations().convention((Iterable)Sets.newHashSet((Object[])new String[]{"groovy.grape.GrabAnnotationTransformation"}));
        });
        JvmPluginsHelper.configureOutputDirectoryForSourceSet(sourceSet, (SourceDirectorySet)groovySource, project, (TaskProvider<? extends AbstractCompile>)compileTask, compileTask.map(GroovyCompile::getOptions));
        project.getTasks().named(sourceSet.getClassesTaskName(), arg_0 -> GroovyBasePlugin.lambda$createGroovyCompileTask$6((TaskProvider)compileTask, arg_0));
        return compileTask;
    }

    private void configureGroovydoc(Project project, GroovyRuntime groovyRuntime) {
        project.getTasks().withType(Groovydoc.class).configureEach(groovydoc -> {
            groovydoc.getConventionMapping().map("groovyClasspath", () -> {
                FileCollection groovyClasspath = groovyRuntime.inferGroovyClasspath(groovydoc.getClasspath());
                ConfigurableFileCollection jansi = project.getObjects().fileCollection().from(this.moduleRegistry.getExternalModule("jansi").getImplementationClasspath().getAsFiles());
                return groovyClasspath.plus(jansi);
            });
            groovydoc.getConventionMapping().map("destinationDir", () -> GroovyBasePlugin.javaPluginExtension(project).getDocsDir().dir("groovydoc").get().getAsFile());
            groovydoc.getConventionMapping().map("docTitle", () -> GroovyBasePlugin.extensionOf(project, ReportingExtension.class).getApiDocTitle());
            groovydoc.getConventionMapping().map("windowTitle", () -> GroovyBasePlugin.extensionOf(project, ReportingExtension.class).getApiDocTitle());
            groovydoc.getAccess().convention(GroovydocAccess.PROTECTED);
            groovydoc.getIncludeAuthor().convention(false);
            groovydoc.getProcessScripts().convention(true);
            groovydoc.getIncludeMainForScripts().convention(true);
        });
    }

    private static Provider<JavaLauncher> getJavaLauncher(Project project) {
        JavaPluginExtension extension = GroovyBasePlugin.javaPluginExtension(project);
        JavaToolchainService service = GroovyBasePlugin.extensionOf(project, JavaToolchainService.class);
        return service.launcherFor(extension.getToolchain());
    }

    private static JavaPluginExtension javaPluginExtension(Project project) {
        return GroovyBasePlugin.extensionOf(project, JavaPluginExtension.class);
    }

    private static <T> T extensionOf(ExtensionAware extensionAware, Class<T> type) {
        return extensionAware.getExtensions().getByType(type);
    }

    private static /* synthetic */ void lambda$createGroovyCompileTask$6(TaskProvider compileTask, Task task) {
        task.dependsOn(compileTask);
    }
}

