/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.tasks.testing.testng;

import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.Callable;
import org.gradle.api.Action;
import org.gradle.api.internal.plugins.DslObject;
import org.gradle.api.internal.tasks.testing.TestFramework;
import org.gradle.api.internal.tasks.testing.WorkerTestClassProcessorFactory;
import org.gradle.api.internal.tasks.testing.detection.ClassFileExtractionManager;
import org.gradle.api.internal.tasks.testing.filter.DefaultTestFilter;
import org.gradle.api.internal.tasks.testing.testng.TestNGDetector;
import org.gradle.api.internal.tasks.testing.testng.TestNGSpec;
import org.gradle.api.internal.tasks.testing.testng.TestNgTestClassProcessorFactory;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.provider.Provider;
import org.gradle.api.reporting.DirectoryReport;
import org.gradle.api.tasks.testing.Test;
import org.gradle.api.tasks.testing.TestFilter;
import org.gradle.api.tasks.testing.testng.TestNGOptions;
import org.gradle.internal.Factory;
import org.gradle.process.internal.worker.WorkerProcessBuilder;

public class TestNGTestFramework
implements TestFramework {
    private final TestNGOptions options;
    private TestNGDetector detector;
    private final DefaultTestFilter filter;
    private final ObjectFactory objects;
    private final Factory<File> testTaskTemporaryDir;
    private final DirectoryReport htmlReport;
    private final Provider<Boolean> dryRun;

    public TestNGTestFramework(Test testTask, DefaultTestFilter filter, ObjectFactory objects) {
        this(filter, objects, testTask.getTemporaryDirFactory(), testTask.getReports().getHtml(), objects.newInstance(TestNGOptions.class, new Object[0]), testTask.getDryRun());
    }

    private TestNGTestFramework(DefaultTestFilter filter, ObjectFactory objects, Factory<File> testTaskTemporaryDir, DirectoryReport htmlReport, TestNGOptions options, Provider<Boolean> dryRun) {
        this.filter = filter;
        this.objects = objects;
        this.testTaskTemporaryDir = testTaskTemporaryDir;
        this.htmlReport = htmlReport;
        this.options = options;
        this.detector = new TestNGDetector(new ClassFileExtractionManager(testTaskTemporaryDir));
        this.dryRun = dryRun;
        TestNGTestFramework.conventionMapOutputDirectory(options, htmlReport);
    }

    private static void conventionMapOutputDirectory(TestNGOptions options, final DirectoryReport html) {
        new DslObject(options).getConventionMapping().map("outputDirectory", new Callable<File>(){

            @Override
            public File call() {
                return html.getOutputLocation().getAsFile().getOrNull();
            }
        });
    }

    @Override
    public TestFramework copyWithFilters(TestFilter newTestFilters) {
        TestNGOptions copiedOptions = this.objects.newInstance(TestNGOptions.class, new Object[0]);
        copiedOptions.copyFrom(this.options);
        return new TestNGTestFramework((DefaultTestFilter)newTestFilters, this.objects, this.testTaskTemporaryDir, this.htmlReport, copiedOptions, this.dryRun);
    }

    @Override
    public WorkerTestClassProcessorFactory getProcessorFactory() {
        List<File> suiteFiles = this.options.getSuites(this.testTaskTemporaryDir.create());
        TestNGSpec spec = this.toSpec(this.options, this.filter);
        return new TestNgTestClassProcessorFactory(this.options.getOutputDirectory(), spec, suiteFiles);
    }

    private TestNGSpec toSpec(TestNGOptions options, DefaultTestFilter filter) {
        return new TestNGSpec(filter.toSpec(), options.getSuiteName(), options.getTestName(), options.getParallel(), options.getThreadCount(), options.getUseDefaultListeners(), options.getIncludeGroups(), options.getExcludeGroups(), options.getListeners(), options.getConfigFailurePolicy(), options.getPreserveOrder(), options.getGroupByInstances(), this.dryRun.get());
    }

    @Override
    public Action<WorkerProcessBuilder> getWorkerConfigurationAction() {
        return workerProcessBuilder -> workerProcessBuilder.sharedPackages("org.gradle.internal.impldep.org.testng");
    }

    @Override
    public boolean getUseDistributionDependencies() {
        return false;
    }

    @Override
    public TestNGOptions getOptions() {
        return this.options;
    }

    @Override
    public TestNGDetector getDetector() {
        return this.detector;
    }

    @Override
    public void close() throws IOException {
        this.detector = null;
    }
}

